% Averages by Party excluding administrations
%   mww, 7/22/2015
%

clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';
outfile_name = [outdir 'avg_by_excl_admin.out'];
fileID = fopen(outfile_name,'w');

% Load Data 
dr_data_calendar;

iq = 1;
qmin = 12;      % Minimum number of quarters in administration for computing results .. if less than this then data are missing @
nma = 6;        % Number of algs for HAC Standard errors

dem_rep_ind;

slist = {
{'gdp', 3}; ... 
};


for istr = 1:size(slist,1);
   ustr = char(slist{istr,1}{1,1});
   eval(['ylevel = ' ustr ';']);
   itran = slist{istr,1}{1,2};
   if itran == 1;
     ydata = ylevel;
   end;
   if itran == 3;
     ydata = NaN*zeros(dnobs,1);
     ydata(2:dnobs) = 100*(((ylevel(2:dnobs)./ylevel(1:dnobs-1)).^4)-1.0);
   end;
   if itran == 10;
     ydata = 16*ylevel;  % Multiply by 16 so this will be average quarters in 16-quarter administration @
   end;
   Truman_2_y = ydata(Truman_2==1,:);
   Eisenhower_1_y = ydata(Eisenhower_1==1,:);
   Eisenhower_2_y = ydata(Eisenhower_2==1,:);
   Kennedy_1_y = ydata(Kennedy_1==1,:);
   Johnson_1_y = ydata(Johnson_1==1,:);
   Nixon_1_y = ydata(Nixon_1==1,:);
   Nixon_2_y = ydata(Nixon_2==1,:);
   Carter_1_y = ydata(Carter_1==1,:);
   Reagan_1_y = ydata(Reagan_1==1,:);
   Reagan_2_y = ydata(Reagan_2==1,:);
   BushG_1_y = ydata(BushG_1==1,:);
   Clinton_1_y = ydata(Clinton_1==1,:);
   Clinton_2_y = ydata(Clinton_2==1,:);
   BushGW_1_y = ydata(BushGW_1==1,:);
   BushGW_2_y = ydata(BushGW_2==1,:);
   Obama_1_y = ydata(Obama_1==1,:);

   
  % -- ALL 
  dem = [Truman_2_y Kennedy_1_y Johnson_1_y Carter_1_y Clinton_1_y Clinton_2_y Obama_1_y];
  rep = [Eisenhower_1_y Eisenhower_2_y Nixon_1_y Nixon_2_y Reagan_1_y Reagan_2_y BushG_1_y BushGW_1_y BushGW_2_y];
  dem_ind_mat = [Truman_2 Kennedy_1 Johnson_1 Carter_1 Clinton_1 Clinton_2 Obama_1];
  rep_ind_mat = [Eisenhower_1 Eisenhower_2 Nixon_1 Nixon_2 Reagan_1 Reagan_2 BushG_1 BushGW_1 BushGW_2];
  
%   % -- Exclude Truman_2 and Eisenhower_1 
%   dem = [Kennedy_1_y Johnson_1_y Carter_1_y Clinton_1_y Clinton_2_y Obama_1_y];
%   rep = [Eisenhower_2_y Nixon_1_y Nixon_2_y Reagan_1_y Reagan_2_y BushG_1_y BushGW_1_y BushGW_2_y];
%   dem_ind_mat = [Kennedy_1 Johnson_1 Carter_1 Clinton_1 Clinton_2 Obama_1];
%   rep_ind_mat = [Eisenhower_2 Nixon_1 Nixon_2 Reagan_1 Reagan_2 BushG_1 BushGW_1 BushGW_2];
%  
%   % -- Exclude Johnson_1 and Nixon_1 
%   dem = [Truman_2_y Kennedy_1_y Carter_1_y Clinton_1_y Clinton_2_y Obama_1_y];
%   rep = [Eisenhower_1_y Eisenhower_2_y Nixon_2_y Reagan_1_y Reagan_2_y BushG_1_y BushGW_1_y BushGW_2_y];
%   dem_ind_mat = [Truman_2 Kennedy_1 Carter_1 Clinton_1 Clinton_2 Obama_1];
%   rep_ind_mat = [Eisenhower_1 Eisenhower_2 Nixon_2 Reagan_1 Reagan_2 BushG_1 BushGW_1 BushGW_2];
%   
%   % -- Exclude BushG_1 and BushGW_1
%   dem = [Truman_2_y Kennedy_1_y Johnson_1_y Carter_1_y Clinton_1_y Clinton_2_y Obama_1_y];
%   rep = [Eisenhower_1_y Eisenhower_2_y Nixon_1_y Nixon_2_y Reagan_1_y Reagan_2_y BushGW_2_y];
%   dem_ind_mat = [Truman_2 Kennedy_1 Johnson_1 Carter_1 Clinton_1 Clinton_2 Obama_1];
%   rep_ind_mat = [Eisenhower_1 Eisenhower_2 Nixon_1 Nixon_2 Reagan_1 Reagan_2 BushGW_2];
%    
%   % -- Exclude Truman_2 Eisenhower_1, Johnson_1 and Nixon_1 ---
%   dem = [Kennedy_1_y Carter_1_y Clinton_1_y Clinton_2_y Obama_1_y];
%   rep = [Eisenhower_2_y Nixon_2_y Reagan_1_y Reagan_2_y BushG_1_y BushGW_1_y BushGW_2_y];
%   dem_ind_mat = [Kennedy_1 Carter_1 Clinton_1 Clinton_2 Obama_1];
%   rep_ind_mat = [Eisenhower_2 Nixon_2 Reagan_1 Reagan_2 BushG_1 BushGW_1 BushGW_2];
%   
%   % -- Exclude Truman_2 and Eisenhower_1, Johnson_1, Nixon_1, BushG_1 and BushGW_1 ---
%   dem = [Kennedy_1_y Carter_1_y Clinton_1_y Clinton_2_y Obama_1_y];
%   rep = [Eisenhower_2_y Nixon_2_y Reagan_1_y Reagan_2_y BushGW_2_y];
%   dem_ind_mat = [Kennedy_1 Carter_1 Clinton_1 Clinton_2 Obama_1];
%   rep_ind_mat = [Eisenhower_2 Nixon_2 Reagan_1 Reagan_2 BushGW_2];
%    
%   % -- Exclude BushGW_2 and Obama_1
%   dem = [Truman_2_y Kennedy_1_y Johnson_1_y Carter_1_y Clinton_1_y Clinton_2_y];
%   rep = [Eisenhower_1_y Eisenhower_2_y Nixon_1_y Nixon_2_y Reagan_1_y Reagan_2_y BushG_1_y BushGW_1_y];
%   dem_ind_mat = [Truman_2 Kennedy_1 Johnson_1 Carter_1 Clinton_1 Clinton_2];
%   rep_ind_mat = [Eisenhower_1 Eisenhower_2 Nixon_1 Nixon_2 Reagan_1 Reagan_2 BushG_1 BushGW_1];
%
% -- Through Eisehower 
  dem = [Truman_2_y];
  rep = [Eisenhower_1_y Eisenhower_2_y];
  dem_ind_mat = [Truman_2];
  rep_ind_mat = [Eisenhower_1 Eisenhower_2];
  
  % -- Through Nixon_2 
  dem = [Truman_2_y Kennedy_1_y Johnson_1_y];
  rep = [Eisenhower_1_y Eisenhower_2_y Nixon_1_y Nixon_2_y];
  dem_ind_mat = [Truman_2 Kennedy_1 Johnson_1];
  rep_ind_mat = [Eisenhower_1 Eisenhower_2 Nixon_1 Nixon_2];
  
  % -- Through BushG
  dem = [Truman_2_y Kennedy_1_y Johnson_1_y Carter_1_y];
  rep = [Eisenhower_1_y Eisenhower_2_y Nixon_1_y Nixon_2_y Reagan_1_y Reagan_2_y BushG_1_y];
  dem_ind_mat = [Truman_2 Kennedy_1 Johnson_1 Carter_1];
  rep_ind_mat = [Eisenhower_1 Eisenhower_2 Nixon_1 Nixon_2 Reagan_1 Reagan_2 BushG_1];
  
  % -- Through BushII-2
  dem = [Truman_2_y Kennedy_1_y Johnson_1_y Carter_1_y Clinton_1_y Clinton_2_y];
  rep = [Eisenhower_1_y Eisenhower_2_y Nixon_1_y Nixon_2_y Reagan_1_y Reagan_2_y BushG_1_y BushGW_1_y BushGW_2_y];
  dem_ind_mat = [Truman_2 Kennedy_1 Johnson_1 Carter_1 Clinton_1 Clinton_2];
  rep_ind_mat = [Eisenhower_1 Eisenhower_2 Nixon_1 Nixon_2 Reagan_1 Reagan_2 BushG_1 BushGW_1 BushGW_2];
 

  
  dem_ind = sum(dem_ind_mat,2);
  rep_ind = sum(rep_ind_mat,2);
  % -- Cluster by 4-year administration
  dem_pavg = NaN*zeros(size(dem,2),1);
  rep_pavg = NaN*zeros(size(rep,2),1);
  for i = 1:size(dem,2);
    tmp = packr(dem(:,i));
 	if size(tmp,1) >= qmin;
 	  dem_pavg(i) = mean(tmp);
    end;
  end;
  for i = 1:size(rep,2);
    tmp = packr(rep(:,i));
 	if size(tmp,1) >= qmin;
 	 rep_pavg(i) = mean(tmp);
    end;
  end;
  a_rep = packr(rep_pavg);
  n_rep = size(a_rep,1);
  a_dem = packr(dem_pavg);
  n_dem = size(a_dem,1);
  dem_avg = mean(a_dem);
  dem_std = std(a_dem);
  dem_se_clust = dem_std/sqrt(n_dem);
  rep_avg = mean(a_rep);
  rep_std = std(a_rep);
  rep_se_clust = rep_std/sqrt(n_rep); 
  dif_avg = dem_avg-rep_avg;
  dif_se_clust = sqrt(dem_se_clust.^2+rep_se_clust.^2);
  
  % -- Hac ----
  isel = dem_ind+rep_ind;
  tmp = [ydata dem_ind rep_ind];
  tmp = tmp(isel==1,:);
  tmp = packr(tmp);
  yp = tmp(:,1);
  dp = tmp(:,2);
  rp = tmp(:,3);
  xp = [dp rp];
  [b,vb,se_b,ser,rbarsq]=hac(yp,xp,nma,1);
  dem_avg = b(1);
  rep_avg = b(2);
  dem_se_hac = se_b(1);
  rep_se_hac = se_b(2);
  tmp = [1 -1]';
  dif_avg = tmp'*b;
  dif_se_hac = sqrt(tmp'*vb*tmp);
  
  % Under random assignment of party of administrations
  a_all = [a_dem;a_rep];
  n_all = n_dem+n_rep;
  mean_all = mean(a_all);
  mean_dem = mean(a_dem);
  mean_rep = (n_all/n_rep)*(mean_all-(n_dem/n_all)*mean_dem);
  dr_gap = mean_dem-mean_rep;
  dem_val_all = nchoosek(a_all,n_dem);
  mean_dem_all = mean(dem_val_all,2);
  mean_rep_all = (n_all/n_rep)*(repmat(mean_all,size(mean_dem_all,1),1)-(n_dem/n_all)*mean_dem_all);
  dr_gap_all = mean_dem_all-mean_rep_all;
  
  num = sum(abs(dr_gap_all) >= abs(dr_gap));
  den = nchoosek(n_all,n_dem);
  pval_ts = num/den;
  
  % Output 
  fprintf(fileID,[ustr ',']);
  fprintf(fileID,'%4.2f ',dem_avg);
  fprintf(fileID,'(%4.2f) ',dem_se_clust);
  fprintf(fileID,'[%4.2f],',dem_se_hac);
  fprintf(fileID,'%4.2f ',rep_avg);
  fprintf(fileID,'(%4.2f) ',rep_se_clust);
  fprintf(fileID,'[%4.2f],',rep_se_hac);
  fprintf(fileID,'%4.2f ',dif_avg);
  fprintf(fileID,'(%4.2f) ',dif_se_clust);
  fprintf(fileID,'[%4.2f] ,',dif_se_hac);
  fprintf(fileID,'%4.2f ,',pval_ts);
  fprintf(fileID,'%6i  %6i \n',[num den]);
end;


