% varages_shock_control_m.gss
%   Compute differences in averages controlling for shocks -- multivariate
%   mww, 6/3/2015


clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';

% Load Data 
dr_data_calendar;

iq = 1;
qmin = 8;
nma = 6;  % Newey-West Lags for HAC @
nlag = 6; % number of lags in distributed lag regression @

dem_rep_ind;

% Setup models to run 
slist = {...
'h_oil' ...
'k_oil' ...
'd_tfp_util' ...
'eps_gali' ...
'dtfp_lr' ...
'dtfp_uadj' ...
'ramey_news' ...
'fp_exret' ...
'oecd_gdp_e_dt_67_res' ...
'd_exrate_res' ...
'rr_extax' ...
'rr_aer04' ...
'sz_ms' ...
'eps_chol_mp' ...
'baa_aaa_res' ...
'gz_ebp_res' ...
'ted_spread_res' ...
'frb_sloos_res' ...
'ln_icc_res' ...
'ln_ice_res' ...
'ln_bbd_res' ...
'jln_res' ...
};
sname = {...
   'Hamilton' ...
   'Killian' ...
   'TFP(Fernald ADJ)' ...
   'LaborProb(LR-SVAR)' ...
   'TFP(LR-SVAR)' ...
   'TFP(AuthorsUA)' ...
   'Ramey Def' ...
   'FP Def' ...
   'GDP Europe' ...
   'ExchangeRates' ...
   'Taxes(RR)' ...
   'MP(RR)' ...
   'MP(SZ)' ...
   'MP(Authors-Chol)' ...
   'BaaAaaSpread' ...
   'GZ Spread' ...
   'TED Spread' ...
   'FRBSloos' ...
   'ICC' ...
   'ICE' ...
   'Uncertainty-BBD' ...
   'Uncertainty-JLN' ...
 }

% Indicator matrix for models to run: 0-1 indicators for include(1) or
% exclud (0);

% % Table 8 
% outfile_name = [outdir 'averages_shock_control_m_tab8.csv'];
% fileID = fopen(outfile_name,'w');
% model_ind = [...
% [1 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]; ...
% [1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]; ...
% [1 0 0 0 0 1 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0]; ...
% [1 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0]; ...
% [1 0 0 0 0 1 1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0]; ...
% ];
% ifirst = [1949 2];
% ilast = [2013 1];

% % Table 9 Column 1 
% outfile_name = [outdir 'averages_shock_control_m_tab9_col1.csv'];
% fileID = fopen(outfile_name,'w');
% model_ind = [...
% [1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]; ...
% ];
% ifirst = [1963 1];
% ilast = [2013 1];

% Table 9, Cols 2-5 
outfile_name = [outdir 'averages_shock_control_m_tab9_cols2_5.csv'];
fileID = fopen(outfile_name,'w');
model_ind = [...
[1 0 0 0 0 1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0]; ...
[1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0 0]; ...
[1 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1]; ...
[1 0 0 0 0 1 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0]; ...
];
ifirst = [1949 2];
ilast = [2013 1];


nmodel = size(model_ind,1);
nvariable = size(slist,2);
cal_mat = NaN(2,nmodel);
cont_mat = NaN(nvariable,nmodel);
cont_se_mat = NaN(nvariable,nmodel);
total_mat = NaN(nmodel,1);
total_se_mat = NaN(nmodel,1);
expl_mat = NaN(nmodel,1);
expl_se_mat = NaN(nmodel,1);
expl_int_mat = NaN(nmodel,1);
expl_int_se_mat = NaN(nmodel,1);
fvalue_mat = NaN(nmodel,1);

for imodel = 1:nmodel;
  % Compute real GDP Growth Rates @
  ylevel = gdp;
  g_gdp = NaN*zeros(dnobs,1);
  g_gdp(2:dnobs) = 100*(((ylevel(2:dnobs)./ylevel(1:dnobs-1)).^4)-1.0);
  % Select variables;
  ylags = 1;
  for istr = 1:nvariable;
      if model_ind(imodel,istr);
          ustr = char(slist{istr});
          eval(['ydata = ' ustr ';']);
          % Construct current and lagged values of ydata 
          ylags_tmp = lagmatrix(ydata,(0:1:nlag));
          if size(ylags,1) == 1;
              ylags = ylags_tmp;
          else;
              ylags = [ylags ylags_tmp];
          end;
       end;
  end;
  
   yfs = g_gdp;                           % Full-sample y 
   xfs = [dem_ind ones(dnobs,1) ylags];   % Full-sample x 
 
   % Select for period of time when we have dems and reps @
   isel = dem_ind+rep_ind;
   ismpl = smpl(calvec,ifirst,ilast,4);
   isel = isel.*ismpl;
   yfs(isel==0,:) = NaN;
   xfs(isel==0,:) = NaN;
 
   ydata = ydata(isel==1,:);
   cal = calvec(isel==1,:);
   demi = dem_ind(isel==1,:);
   repi = rep_ind(isel==1,:);
   dgdpi = g_gdp(isel==1,:);
   ylagsi = ylags(isel==1,:);
 
   % Run regression of real GDP growth on lags of x, constant and dem indicator @
   x = [demi ones(size(demi,1),1) ylagsi];
   tmp = packr([cal dgdpi x]);
   calp = tmp(:,1);
   yp = tmp(:,2);
   xp = tmp(:,3:end);
   
   % Standardize regressors
   xp(:,3:end) = zscore(xp(:,3:end));
   
   cal_mat(1,imodel) = calp(1);
   cal_mat(2,imodel) = calp(end);
   
   % Benchmark Regression -- No Controls 
   [bb,vbeta,se_bb,ser,rbarsq] = hac(yp,xp(:,1:2),nma,1);
   total_mat(imodel) = bb(1);
   total_se_mat(imodel) = se_bb(1);
   
   % Regression with controls 
   [bc,vbc,se_bc,ser,rbarsq] = hac(yp,xp,nma,1);
   vbc = vbc*size(xp,1)/(size(xp,1)-size(xp,2));
   se_bc = se_bc*sqrt(size(xp,1)/(size(xp,1)-size(xp,2)));  % Degrees of Freedom correction 
 
   % Compute Results Using Regression with Controls @
   % Indicator for Dems and Reps @
   dem_xp = xp(:,1);  
   rep_xp = 1-dem_xp;
   % Average Values of Regressors .. Dems and Reps 
   mxp = mean(xp)';  % Overall Average 
   mxp_d = mean(xp(dem_xp==1,:))';
   mxp_r = mean(xp(rep_xp==1,:))';
   dif_xp = mxp_d-mxp_r;    % Differences in average values of regressors 
   dif_xpc = dif_xp;
   dif_xpc(1:2)=zeros(2,1); % Differences in average value of controls 
   dif_xpd = dif_xp;
   dif_xpd(3:end) = zeros(size(dif_xpd,1)-2,1);
   expl_mat(imodel) = dif_xpc'*bc;
   expl_se_mat(imodel) = sqrt(dif_xpc'*vbc*dif_xpc);
   jj = 0;
   for istr = 1:size(slist,2);
      if model_ind(imodel,istr)==1;
          jj = jj+1;
          dif_xpc_i = zeros(size(xp,2),1);
          ii = (jj-1)*(nlag+1);  
          dif_xpc_i(3+ii:3+ii+nlag) = dif_xpc(3+ii:3+ii+nlag);
          cont_mat(istr,imodel) = dif_xpc_i'*bc;
          cont_se_mat(istr,imodel) = sqrt(dif_xpc_i'*vbc*dif_xpc_i);
      end;
   end;
  % Run regression with controls and interactions
   tmp = repmat(xp(:,1),1,size(xp,2)-2).*xp(:,3:end);
   xp_i = [xp tmp];
   [bc_i,vbc_i,se_bc_i,ser,rbarsq] = hac(yp,xp_i,nma,1);
   vbc_i = vbc_i*size(xp_i,1)/(size(xp_i,1)-size(xp_i,2));            % Degrees of Freedom correction 
   se_bc_i = se_bc_i*sqrt(size(xp_i,1)/(size(xp_i,1)-size(xp_i,2)));  % Degrees of Freedom correction 
 
   % Compute Wald-statistic for interactions;
   nreg_cont = size(xp,2);      % Number of regressors with controls
   nreg_cont_i = size(xp_i,2);  % Number of regressors with controls and interactions
   ndf = nreg_cont_i-nreg_cont;
   R = zeros(ndf,nreg_cont_i);
   R(:,nreg_cont+1:end) = eye(ndf);
   wstat = (R*bc_i)'*inv(R*vbc_i*R')*(R*bc_i);
   pvalue = 1-chi2cdf(wstat,ndf);
   fvalue_mat(imodel) = pvalue;
    
   % Compute Results Using Regression with Controls and interactions @
   % Indicator for Dems and Reps @
   dem_xp = xp_i(:,1);  
   rep_xp = 1-dem_xp;
   % Average Values of Regressors .. Dems and Reps 
   mxp = mean(xp_i)';  % Overall Average 
   mxp_d = mean(xp_i(dem_xp==1,:))';
   mxp_r = mean(xp_i(rep_xp==1,:))';
   dif_xp = mxp_d-mxp_r;    % Differences in average values of regressors 
   dif_xpc = dif_xp;
   dif_xpc(1:2)=zeros(2,1); % Differences in average value of controls 
   dif_xpd = dif_xp;
   dif_xpd(3:end) = zeros(size(dif_xpd,1)-2,1);
   expl_int_mat(imodel) = dif_xpc'*bc_i;
   expl_int_se_mat(imodel) = sqrt(dif_xpc'*vbc_i*dif_xpc);
    
end; 

fprintf(fileID,' ,');
for imodel = 1:nmodel;
    fprintf(fileID,'%2i',imodel);
    if imodel < nmodel;
        fprintf(fileID,',');
    else;
        fprintf(fileID,'\n\n');
    end;
end;
fprintf(fileID,'Begin ,');
for imodel = 1:nmodel;
    fprintf(fileID,'%6.2f',cal_mat(1,imodel));
    if imodel < nmodel;
        fprintf(fileID,',');
    else;
        fprintf(fileID,'\n');
    end;
end;
fprintf(fileID,'End ,');
for imodel = 1:nmodel;
    fprintf(fileID,'%6.2f',cal_mat(2,imodel));
    if imodel < nmodel;
        fprintf(fileID,',');
    else;
        fprintf(fileID,'\n\n');
    end;
end;

fprintf(fileID,'TotalGap ,');
for imodel = 1:nmodel;
    fprintf(fileID,'%4.2f (%4.2f)',[total_mat(imodel) total_se_mat(imodel)]);
    if imodel < nmodel;
        fprintf(fileID,',');
    else;
        fprintf(fileID,'\n\n');
    end;
end;

for i = 1:nvariable
  ustr = char(sname(i));
  fprintf(fileID,[ustr ',']);
  for imodel = 1:nmodel;
    if isnan(cont_mat(i,imodel)) == 0;
     fprintf(fileID,'%4.2f (%4.2f)',[cont_mat(i,imodel) cont_se_mat(i,imodel)]);
    end;
    if imodel < nmodel;
        fprintf(fileID,',');
    else;
        fprintf(fileID,'\n');
    end;
  end;
end;
fprintf(fileID,'\n');

fprintf(fileID,'Expl_C_Gap ,');
for imodel = 1:nmodel;
    fprintf(fileID,'%4.2f (%4.2f)',[expl_mat(imodel) expl_se_mat(imodel)]);
    if imodel < nmodel;
        fprintf(fileID,',');
    else;
        fprintf(fileID,'\n\n');
    end;
end;

fprintf(fileID,'Expl_I_Gap ,');
for imodel = 1:nmodel;
    fprintf(fileID,'%4.2f (%4.2f)',[expl_int_mat(imodel) expl_int_se_mat(imodel)]);
    if imodel < nmodel;
        fprintf(fileID,',');
    else;
        fprintf(fileID,'\n');
    end;
end;

fprintf(fileID,'FPvalue ,');
for imodel = 1:nmodel;
    fprintf(fileID,'%4.2f',[fvalue_mat(imodel)]);
    if imodel < nmodel;
        fprintf(fileID,',');
    else;
        fprintf(fileID,'\n');
    end;
end;




 