% averages_shock_control_u.gss
%   Compute differences in averages controlling for shocks -- univariate
%   mww, 7/2/2015

clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';
outfile_name = [outdir 'averages_shock_control_u.out'];
fileID = fopen(outfile_name,'w');

% Load Data 
dr_data_calendar;

iq = 1;
qmin = 8; 
nma = 6;  % Newey-West Lags for HAC @
nlag = 6; % number of lags in distributed lag regression @

dem_rep_ind;

slist = {...
'h_oil' ...
'k_oil' ...
'h_oilksmpl' ...
'd_tfp_util' ...
'eps_gali' ...
'dtfp_lr' ...
'dtfp_uadj' ...
'ramey_news' ...
'fp_exret' ...
'oecd_gdp_e_dt_67_res' ...
'd_exrate_res' ...
'rr_extax' ...
'rr_aer04' ...
'sz_ms' ...
'eps_chol_mp' ...
'baa_aaa_res' ...
'gz_ebp_res' ...
'ted_spread_res' ...
'frb_sloos_res' ...
'ln_icc_res' ...
'ln_ice_res' ...
'ln_bbd_res' ...
'jln_res' ...
};

% Compute real GDP Growth Rates @
ylevel = gdp;
g_gdp = NaN*zeros(dnobs,1);
g_gdp(2:dnobs) = 100*(((ylevel(2:dnobs)./ylevel(1:dnobs-1)).^4)-1.0);

ifirst = [1949 2];
ilast = [2013 1];

for istr = 1:size(slist,2);
   ustr = char(slist{istr});
   eval(['ydata = ' ustr ';']);
 
   % Construct current and lagged values of ydata 
   ylags = NaN*zeros(dnobs,nlag+1);
   for i = 0:nlag;
    ylags(:,i+1) = lag(ydata,i);
   end;
 
   yfs = g_gdp;                           % Full-sample y 
   xfs = [dem_ind ones(dnobs,1) ylags];   % Full-sample x 
 
   % Select for period of time when we have dems and reps @
   isel = dem_ind+rep_ind;
   ismpl = smpl(calvec,ifirst,ilast,4);
   isel = isel.*ismpl;
   yfs(isel==0,:) = NaN;
   xfs(isel==0,:) = NaN;
 
   ydata = ydata(isel==1,:);
   cal = calvec(isel==1,:);
   demi = dem_ind(isel==1,:);
   repi = rep_ind(isel==1,:);
   dgdpi = g_gdp(isel==1,:);
   ylagsi = ylags(isel==1,:);
 
   % Run regression of real GDP growth on lags of x, constant and dem indicator @
   x = [demi ones(size(demi,1),1) ylagsi];
   tmp = packr([cal dgdpi x]);
   calp = tmp(:,1);
   yp = tmp(:,2);
   xp = tmp(:,3:end);
   % Standardize regressors for shocks
   xp(:,3:end) = zscore(xp(:,3:end));
   
   
   fprintf(fileID,['\n \n Control: ' ustr '\n']); 
   fprintf(fileID,'  Sample Period: %6.2f - %6.2f \n',[calp(1) calp(end)]);
   % Benchmark Regression -- No Controls 
   [bb,vbeta,se_bb,ser,rbarsq] = hac(yp,xp(:,1:2),nma,1);
   fprintf(fileID,'  Benchmark D-R Gap: %6.2f (%6.2f) \n',[bb(1) se_bb(1)]); 
   
    % Run regression with controls 
   [bc,vbc,se_bc,ser,rbarsq] = hac(yp,xp,nma,1);
   vbc = vbc*size(xp,1)/(size(xp,1)-size(xp,2));            % Degrees of Freedom correction 
   se_bc = se_bc*sqrt(size(xp,1)/(size(xp,1)-size(xp,2)));  % Degrees of Freedom correction 
   tmp = zeros(1,size(xp,2));
   tmp(3:end) = ones(1,size(xp,2)-2);
   lrmult = tmp*bc;
   se_lrmult = sqrt(tmp*vbc*tmp');
 
   % Compute Estimate of R-squared @
   er = yp - xp(:,1:2)*bb;
   eu = yp - xp*bc;
   ver = er'*er/(size(xp,1)-2);
   veu = eu'*eu/(size(xp,1)-size(xp,2));
   rbar2 = 1 - (veu/ver); 
   fprintf(fileID, '\n  Partial rbar-squared for controls: %6.2f \n',rbar2);
   fprintf(fileID, '  Sum of coefficients and SE: %6.3f (%6.3f) \n',[lrmult se_lrmult]);
   
  % Compute Results Using Regression with Controls @
  % Indicator for Dems and Reps @
  dem_xp = xp(:,1);  
  rep_xp = 1-dem_xp;
  % Average Values of Regressors .. Dems and Reps 
  mxp = mean(xp)';  % Overall Average 
  mxp_d = mean(xp(dem_xp==1,:))';
  mxp_r = mean(xp(rep_xp==1,:))';
  dif_xp = mxp_d-mxp_r;    % Differences in average values of regressors 
  dif_xpc = dif_xp;
  dif_xpc(1:2)=zeros(2,1); % Differences in average value of controls 
  dif_xpd = dif_xp;
  dif_xpd(3:end) = zeros(size(dif_xpd,1)-2,1);
  fprintf(fileID,'  Total D-R Gap from Regression with Controls: %6.2f (%6.2f) \n', [dif_xp'*bc sqrt(dif_xp'*vbc*dif_xp)]);
  fprintf(fileID,'  Control Component of D-R gap:  %6.2f (%6.2f) \n', [dif_xpc'*bc sqrt(dif_xpc'*vbc*dif_xpc)]);
  fprintf(fileID,'  Intercept Component of D-R gap:  %6.2f (%6.2f) \n', [dif_xpd'*bc sqrt(dif_xpd'*vbc*dif_xpd)]);
  fprintf(fileID,'    Average values of controls \n');
  fprintf(fileID,'      Lag, b, Dem, Rep, Difference \n');
  for ilag = 0:nlag;
      fprintf(fileID,'        %1i, %6.3f, %6.3f, %6.3f, %6.3f \n',[ilag bc(3+ilag) mxp_d(3+ilag) mxp_r(3+ilag) dif_xpc(3+ilag)]);
  end;
  fprintf(fileID,'     Avg., %6.3f, %6.3f, %6.3f, %6.3f \n',[mean(bc(3:end)) mean(mxp_d(3:end)) mean(mxp_r(3:end)) mean(dif_xpc(3:end))]);
  fprintf(fileID,'\n \n');
  
  % Compute Results for h_oil over killian sample 
  if istr == 1;
      ismpl = smpl(calp,[1972 3],[2004 3],4);
      calpp = calp(ismpl==1);
      xpp = xp(ismpl==1,:); 
      dem_xpp = xpp(:,1);  
      rep_xpp = 1-dem_xpp;
      % Average Values of Regressors .. Dems and Reps 
      mxpp = mean(xpp)';  % Overall Average 
      mxpp_d = mean(xpp(dem_xpp==1,:))';
      mxpp_r = mean(xpp(rep_xpp==1,:))';
      dif_xpp = mxpp_d-mxpp_r;    % Differences in average values of regressors 
      dif_xppc = dif_xpp;
      dif_xppc(1:2)=zeros(2,1); % Differences in average value of controls 
      dif_xppd = dif_xpp;
      dif_xppd(3:end) = zeros(size(dif_xppd,1)-2,1);
      fprintf(fileID,'-------- Addendum .. values over shorter sample period: %6.2f - %6.2f \n',[calpp(1) calpp(end)]);
      fprintf(fileID,'  Control Component of D-R gap:  %6.2f (%6.2f) \n', [dif_xppc'*bc sqrt(dif_xppc'*vbc*dif_xppc)]);
      fprintf(fileID,'    Average values of controls \n');
      fprintf(fileID,'      Lag, b, Dem, Rep, Difference \n');
      for ilag = 0:nlag;
        fprintf(fileID,'        %1i, %6.3f, %6.3f, %6.3f, %6.3f \n',[ilag bc(3+ilag) mxpp_d(3+ilag) mxpp_r(3+ilag) dif_xppc(3+ilag)]);
      end;
      fprintf(fileID,'     Avg., %6.3f, %6.3f, %6.3f, %6.3f \n',[mean(bc(3:end)) mean(mxpp_d(3:end)) mean(mxpp_r(3:end)) mean(dif_xppc(3:end))]);
      fprintf(fileID,'-------- End Addendum ------');
      fprintf(fileID,'\n \n');
  end;
          
  
  % Compute deviation of mean for each administration from grand mean 
  fprintf(fileID,'   Results by administration \n');
  % Construct indicator for obs used in control regression 
  isel_c = (calvec >= (min(calp)-.0001)) .* (calvec <= (max(calp)+.0001));
 
  admin_str = { ...
  'Truman_2' ...
  'Kennedy_1' ...
  'Johnson_1' ...
  'Carter_1' ...
  'Clinton_1' ...
  'Clinton_2' ...
  'Obama_1' ...
  'Eisenhower_1' ...
  'Eisenhower_2' ...
  'Nixon_1' ...
  'Nixon_2' ...
  'Reagan_1' ...
  'Reagan_2' ...
  'BushG_1' ...
  'BushGW_1' ...
  'BushGW_2' ...
  'dem_ind' ...
  'rep_ind' ...
  };
 
 for i_admin = 1:size(admin_str,2);
   ustr = char(admin_str(i_admin));
   eval(['admin_ind = ' ustr ';']);
   isel_i = admin_ind(isel_c==1);
   xp_a = xp(isel_i==1,:);  % Regressors for this administration
   mxp_a = mean(xp_a)';  % Overall Average 
   mxp_a(1:2) = 0;
   if size(xp_a,1) >= qmin;
     bdif = mxp_a'*bc;
     vbdif = mxp_a'*vbc*mxp_a;
     fprintf(fileID,['        ' ustr ': %6.2f (%6.2f) \n'],[bdif sqrt(vbdif)]);       
   end;
 end;
 
   % Run regression with controls and interactions
   tmp = repmat(xp(:,1),1,size(xp,2)-2).*xp(:,3:end);
   xp_i = [xp tmp];
   [bc_i,vbc_i,se_bc_i,ser,rbarsq] = hac(yp,xp_i,nma,1);
   vbc_i = vbc_i*size(xp_i,1)/(size(xp_i,1)-size(xp_i,2));            % Degrees of Freedom correction 
   se_bc_i = se_bc_i*sqrt(size(xp_i,1)/(size(xp_i,1)-size(xp_i,2)));  % Degrees of Freedom correction 
   
   % Compute Estimate of R-squared @
   er = yp - xp*bc;
   eu = yp - xp_i*bc_i; 
   ver = er'*er/(size(xp,1)-size(xp,2));
   veu = eu'*eu/(size(xp_i,1)-size(xp_i,2));
   rbar2 = 1 - (veu/ver); 
   fprintf(fileID, '\n  Partial rbar-squared for interactions: %6.2f \n',rbar2);
   
   % Compute Wald-statistic for interactions;
   nreg_cont = size(xp,2);      % Number of regressors with controls
   nreg_cont_i = size(xp_i,2);  % Number of regressors with controls and interactions
   ndf = nreg_cont_i-nreg_cont;
   R = zeros(ndf,nreg_cont_i);
   R(:,nreg_cont+1:end) = eye(ndf);
   wstat = (R*bc_i)'*inv(R*vbc_i*R')*(R*bc_i);
   pvalue = 1-chi2cdf(wstat,ndf);
   fprintf(fileID,'  F-statistic and p-value for interactions: %6.2f (%6.3f) \n',[wstat/ndf pvalue]);
    
  % Compute Results Using Regression with Controls and interactions @
  % Indicator for Dems and Reps @
  dem_xp = xp_i(:,1);  
  rep_xp = 1-dem_xp;
  % Average Values of Regressors .. Dems and Reps 
  mxp = mean(xp_i)';  % Overall Average 
  mxp_d = mean(xp_i(dem_xp==1,:))';
  mxp_r = mean(xp_i(rep_xp==1,:))';
  dif_xp = mxp_d-mxp_r;    % Differences in average values of regressors 
  dif_xpc = dif_xp;
  dif_xpc(1:2)=zeros(2,1); % Differences in average value of controls 
  dif_xpd = dif_xp;
  dif_xpd(3:end) = zeros(size(dif_xpd,1)-2,1);
  fprintf(fileID,'  Total D-R Gap from Regression with Controls and interactions: %6.2f (%6.2f) \n', [dif_xp'*bc_i sqrt(dif_xp'*vbc_i*dif_xp)]);
  fprintf(fileID,'  Control and Interaction Component of D-R gap:  %6.2f (%6.2f) \n', [dif_xpc'*bc_i sqrt(dif_xpc'*vbc_i*dif_xpc)]);
  fprintf(fileID,'  Intercept Component of D-R gap:  %6.2f (%6.2f) \n', [dif_xpd'*bc_i sqrt(dif_xpd'*vbc_i*dif_xpd)]);
  
  if istr == 1;
      ismpl = smpl(calp,[1972 3],[2004 3],4);
      calpp = calp(ismpl==1);
      xpp = xp_i(ismpl==1,:); 
      dem_xpp = xpp(:,1);  
      rep_xpp = 1-dem_xpp;
      % Average Values of Regressors .. Dems and Reps 
      mxpp = mean(xpp)';  % Overall Average 
      mxpp_d = mean(xpp(dem_xpp==1,:))';
      mxpp_r = mean(xpp(rep_xpp==1,:))';
      dif_xpp = mxpp_d-mxpp_r;    % Differences in average values of regressors 
      dif_xppc = dif_xpp;
      dif_xppc(1:2)=zeros(2,1); % Differences in average value of controls 
      dif_xppd = dif_xpp;
      dif_xppd(3:end) = zeros(size(dif_xppd,1)-2,1);
      fprintf(fileID,'-------- Addendum .. values over shorter sample period: %6.2f - %6.2f \n',[calpp(1) calpp(end)]);
      fprintf(fileID,'  Control and Interaction Component of D-R gap:  %6.2f (%6.2f) \n', [dif_xppc'*bc_i sqrt(dif_xppc'*vbc_i*dif_xppc)]);
      fprintf(fileID,'-------- End Addendum ------');
      fprintf(fileID,'\n \n');  
  end;
 
end;

