% Averages by Year  (first year, second year, and so forth)
%   mww, 5/31/2015
%

clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';
outfile_name = [outdir 'avg_by_year.out'];
fileID = fopen(outfile_name,'w');

% Load Data 
dr_data_calendar;

iq = 1;
qmin = 12;      % Minimum number of quarters in administration for computing results .. if less than this then data are missing @
nma = 6;        % Number of algs for HAC Standard errors

dem_rep_ind_lag;  % Adds one lagged year to term


slist = {
{'gdp', 3}; ... 
{'unrate', 1}; ... 
{'d_ppce', 1}; ... 
};


for istr = 1:size(slist,1);
   ustr = char(slist{istr,1}{1,1});
   eval(['ylevel = ' ustr ';']);
   itran = slist{istr,1}{1,2};
   if itran == 1;
     ydata = ylevel;
   end;
   if itran == 3;
     ydata = NaN*zeros(dnobs,1);
     ydata(2:dnobs) = 100*(((ylevel(2:dnobs)./ylevel(1:dnobs-1)).^4)-1.0);
   end;
   if itran == 10;
     ydata = 16*ylevel;  % Multiply by 16 so this will be average quarters in 16-quarter administration @
   end;
   Truman_2_y = ydata(Truman_2==1,:);
   Eisenhower_1_y = ydata(Eisenhower_1==1,:);
   Eisenhower_2_y = ydata(Eisenhower_2==1,:);
   Kennedy_1_y = ydata(Kennedy_1==1,:);
   Johnson_1_y = ydata(Johnson_1==1,:);
   Nixon_1_y = ydata(Nixon_1==1,:);
   Nixon_2_y = ydata(Nixon_2==1,:);
   Carter_1_y = ydata(Carter_1==1,:);
   Reagan_1_y = ydata(Reagan_1==1,:);
   Reagan_2_y = ydata(Reagan_2==1,:);
   BushG_1_y = ydata(BushG_1==1,:);
   Clinton_1_y = ydata(Clinton_1==1,:);
   Clinton_2_y = ydata(Clinton_2==1,:);
   BushGW_1_y = ydata(BushGW_1==1,:);
   BushGW_2_y = ydata(BushGW_2==1,:);
   Obama_1_y = ydata(Obama_1==1,:);
  
  dem = [Truman_2_y Kennedy_1_y Johnson_1_y Carter_1_y Clinton_1_y Clinton_2_y Obama_1_y];
  rep = [Eisenhower_1_y Eisenhower_2_y Nixon_1_y Nixon_2_y Reagan_1_y Reagan_2_y BushG_1_y BushGW_1_y BushGW_2_y];
  
  dem_pavg = NaN*zeros(size(dem,2),5);
  rep_pavg = NaN*zeros(size(rep,2),5);
  
  for i = 1:size(dem,2);
    for j = 1:5;
        ii = 4*(j-1);
        tmp = packr(dem(ii+1:ii+4,i));
        dem_pavg(i,j) = mean(tmp);
    end;
  end;
  
  for i = 1:size(rep,2);
    for j = 1:5;
        ii = 4*(j-1);
        tmp = packr(rep(ii+1:ii+4,i));
        rep_pavg(i,j) = mean(tmp);
    end;
  end;
 
 dem_avg = NaN*zeros(5,1);
 rep_avg = NaN*zeros(5,1);
 for j = 1:5;
   ii = 4*(j-1);
   tmp = packr(reshape(dem(ii+1:ii+4,:),4*size(dem,2),1));
   dem_avg(j) = mean(tmp);
   tmp = packr(reshape(rep(ii+1:ii+4,:),4*size(rep,2),1));
   rep_avg(j) = mean(tmp); 
 end;
 
  
  
  for j = 1:5;
      if j == 1;
          fprintf(fileID,[ustr ',']);
      else;
          fprintf(fileID,',');
      end;
      fprintf(fileID,'%3i,,',j-1);
      prtmat_comma(dem_pavg(:,j)',fileID,'%4.2f',',,');
      prtmat_comma(rep_pavg(:,j)',fileID,'%4.2f',',,');
      fprintf(fileID,'%4.2f,',dem_avg(j));
      fprintf(fileID,'%4.2f,',rep_avg(j));
      fprintf(fileID,'%4.2f \n',dem_avg(j)-rep_avg(j));
  end;
  
end;

