%    Early period average etc.
%    mww, 7/22/2015

% ----------- Sample Period, Calendars and so forth
[dnobs,calvec,calds] = calendar_make([1875 1],[1947 1],4);

% Data Set 
xlsname='/users/mwatson/dropbox/demrep/ddisk/data/demrep.xlsx';     % DATA Set (Excel File) 
ns=3;    % Number of monthly series in dataset 
miss_code = 1.0e+32;
nma = 6;

% Read in Data Series 

  ndesc=2;
  ncodes=0;
  sheet='preww2';
  [namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns,dnobs,ndesc,ncodes);
  labelvec=descmat(:,1);
  % Convert Namestrings to upper case 
  namevec = upper(namevec);
  % Eliminate any leading or trailing blanks 
  namevec=strtrim(namevec);
  labelvec=strtrim(labelvec);
  % Replace missing values with NaN
  isel = datamat == miss_code;
  datamat(isel) = NaN;
  
  str='RGDP';  % Utilization adjusted tfp 
  str=upper(str);
  j = colnumber(str,namevec);
  gdp=datamat(:,j);

  str='RECESSION';  % Utilization adjusted tfp 
  str=upper(str);
  j = colnumber(str,namevec);
  rec=datamat(:,j);
  
  str='DEM';  % Utilization adjusted tfp 
  str=upper(str);
  j = colnumber(str,namevec);
  dem=datamat(:,j);
  
  g_gdp = NaN*zeros(dnobs,1);
  g_gdp(2:dnobs) = 100*(((gdp(2:dnobs)./gdp(1:dnobs-1)).^4)-1.0);
  
  rep = ones(dnobs,1)-dem;
  
  tmp = [g_gdp rec dem rep];
  tmp = packr(tmp);
  yp_gdp = tmp(:,1);
  yp_rec = tmp(:,2);
  xp = tmp(:,3:4);
  
  % Results for GDP
  yp = yp_gdp;
  [b,vb,se_b,ser,rbarsq]=hac(yp,xp,nma,1);
  dem_avg = b(1);
  rep_avg = b(2);
  dem_se_hac = se_b(1);
  rep_se_hac = se_b(2);
  tmp = [1 -1]';
  dif_avg = tmp'*b;
  dif_se_hac = sqrt(tmp'*vb*tmp);
  
  % Results for recession quarters
  yp = yp_rec;
  [b,vb,se_b,ser,rbarsq]=hac(yp,xp,nma,1);
  dem_avg = b(1);
  rep_avg = b(2);
  dem_se_hac = se_b(1);
  rep_se_hac = se_b(2);
  tmp = [1 -1]';
  dif_avg = tmp'*b;
  dif_se_hac = sqrt(tmp'*vb*tmp);

  




