%    DR_data_calendar.m
%    Set up calendars and read in data for DR Project
%    mww, 7/22/2015

% ----------- Sample Period, Calendars and so forth
[dnobs_m,calvec_m,calds_m] = calendar_make([1947 1],[2015 3],12);
[dnobs_q,calvec_q,calds_q] = calendar_make([1947 1],[2015 1],4);
[dnobs_a,calvec_a,calds_a] = calendar_make([1947 1],[2014 1],1);

% Data Set 
xlsname='/users/mwatson/dropbox/demrep/ddisk/data/demrep.xlsx';     % DATA Set (Excel File) 
ns_m=20;    % Number of monthly series in dataset 
ns_q=35;    % Number of quarterly series in dataset
miss_code = 1.0e+32;


% Read in Data Series 

  % --------------- Read In Monthly Data ---------------- 
  ndesc=2;
  ncodes=0;
  sheet='Monthly';
  [namevec,descmat,tcodemat,datevec,datamat_m] = readxls(xlsname,sheet,ns_m,dnobs_m,ndesc,ncodes);
  labelvec=descmat(:,1);
  % Convert Namestrings to upper case 
  namevec = upper(namevec);
  % Eliminate any leading or trailing blanks 
  namevec=strtrim(namevec);
  labelvec=strtrim(labelvec);
  % Replace missing values with NaN
  isel = datamat_m == miss_code;
  datamat_m(isel) = NaN;
    
  str='INDPRO';    % INDPRO 
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  indpro=mtoq(tmp_m,calds_m,calds_q,0);
  
  str='PAYEMS';    % Employment
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  emp_est=mtoq(tmp_m,calds_m,calds_q,0);
  
  str='CE16OV';    % Employment
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  emp=mtoq(tmp_m,calds_m,calds_q,0);
  
  str='UNRATE';    % Unemployment Rate
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  unrate=mtoq(tmp_m,calds_m,calds_q,0);
  
  str='RET_VW';    % CRSP VW Returns on SP500
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  vwret=mtoq(tmp_m,calds_m,calds_q,0);
  vwret = 1200*vwret;         % Quarterly returns in PAAR 
  
  str='RET_SP500';    % Returns on SP500 Index
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  sp500ret=mtoq(tmp_m,calds_m,calds_q,0);
  sp500ret = 1200*sp500ret;         % Quarterly returns in PAAR 

  str='FEDFUNDS';    % Federal Funds
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  r_fedfunds=mtoq(tmp_m,calds_m,calds_q,0);
  
  str='TB3MS';    % 3-Month Treasury Bills
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  r_tb3m=mtoq(tmp_m,calds_m,calds_q,0);
  r_tb3m_lmq=mtoq(tmp_m,calds_m,calds_q,3);
  
  str='GS10';    % 10-Year Treasury Bonds
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  r_tb10y=mtoq(tmp_m,calds_m,calds_q,0);
  r_tb10y_lmq=mtoq(tmp_m,calds_m,calds_q,3);
  
  str='MED3';    % 3-Month EuroDollar
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  r_med3=mtoq(tmp_m,calds_m,calds_q,0);
  
  str='AAA';    % Aaa corporate bond yield
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  r_aaa=mtoq(tmp_m,calds_m,calds_q,0);
  r_aaa_lmq=mtoq(tmp_m,calds_m,calds_q,3);
  
  str='BAA';    % Baa corporate bond yield
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  r_baa=mtoq(tmp_m,calds_m,calds_q,0);
  
  str='GZ_EBP';    % Baa corporate bond yield
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  gz_ebp_m = tmp_m;
  gz_ebp=mtoq(tmp_m,calds_m,calds_q,0);
  
  str='exrate';    % US Dollar Exchange Rate
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  exrate_m = tmp_m;
  exrate=mtoq(tmp_m,calds_m,calds_q,0);

  str='WPU0561';    % Oil Prices
  str=upper(str);
  j = colnumber(str,namevec);
  tmp=datamat_m(:,j);
  poil = mtoq(tmp,calds_m,calds_q,3);     % Last month in quarter; Hamilton (2003) fn 8 
  maxoil = NaN*zeros(dnobs_q,1);
  % Following Hamilton, treat 1947:q1 as max over previous three years 
  poil_tmp = [(poil(1)*ones(12,1));poil];
  for t = 1:dnobs_q;
      maxoil(t) = max(poil_tmp(t+12-12:t+12-1));
  end;
  dpm = 100*log(poil./maxoil);
  h_oil = (dpm > 0).*dpm;
  
  % Demeaned Hamilton Oil, and series interacted with dummies in 1985 
  h_oil_dm = h_oil - mean(packr(h_oil));
  ii1 = (calvec_q < 1984.99);
  ii2 = (calvec_q > 1984.99);
  h_oil_dm_pre85 = h_oil_dm.*ii1;
  h_oil_dm_pst85 = h_oil_dm.*ii2;
  
  str='SZ_MS';    % Sims-Zha Markov Switching SVAR MP Shocks
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  sz_ms=mtoq(tmp_m,calds_m,calds_q,0);
  
  str='RR_AER04';    % RR AER 2004 MP Shocks
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  rr_aer04=mtoq(tmp_m,calds_m,calds_q,0);
  
  str='U0M023';    % Commodity Price Spot Price Index (TCB Indicator Series) 
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  p_commodity=mtoq(tmp_m,calds_m,calds_q,0);
  
  str='BBD';    % BBD Long-term News Index 
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  bbd=mtoq(tmp_m,calds_m,calds_q,0);
  bbd = bbd/100;
  ln_bbd = log(bbd); 
  
  str='JLN_3';    % Jurado, Ludvigson, and NG uncertainty measure
  str=upper(str);
  j = colnumber(str,namevec);
  tmp_m=datamat_m(:,j);
  jln=mtoq(tmp_m,calds_m,calds_q,0);
 
  % ------------------------------- Read in Quarterly Data ----------------------------- 
  ndesc=2;
  ncodes=0;
  sheet='Quarterly';
  [namevec,descmat,tcodemat,datevec,datamat] = readxls(xlsname,sheet,ns_q,dnobs_q,ndesc,ncodes);
  labelvec=descmat(:,1);
  % Convert Namestrings to upper case 
  namevec = upper(namevec);
  % Eliminate any leading or trailing blanks 
  namevec=strtrim(namevec);
  labelvec=strtrim(labelvec);
  % Replace missing values with NaN
  isel = datamat == miss_code;
  datamat(isel) = NaN;

  str='GDPC96';    % Real GDP 
  str=upper(str);
  j = colnumber(str,namevec);
  gdp=datamat(:,j);
  
  % Annual Growth Rates 
  g_gdp_a = NaN*zeros(dnobs_a,1);
  for i = 1:dnobs_a-1;
	 j = 4*i+1;
	 g_gdp_a(i)=100*((gdp(j)/gdp(j-4))-1);  % Note ... this is growth Q1 - Q1 ... consistent with benchmark timing for administrations @
  end;
  
  str='RECQTR';    % Recession Quarters 
  str=upper(str);
  j = colnumber(str,namevec);
  rec_qtr=datamat(:,j);
  
  str='GDPDEF';    % GDP Delfator
  str=upper(str);
  j = colnumber(str,namevec);
  p_gdp=datamat(:,j);
  
  str='PCECTPI';    % PCE Delfator
  str=upper(str);
  j = colnumber(str,namevec);
  p_pce=datamat(:,j);
  
  str='A939RC0Q052SBEA';    % Nominal GDP per Capita
  str=upper(str);
  j = colnumber(str,namevec);
  n_gdp_pc=datamat(:,j);
  gdp_pc = n_gdp_pc./p_gdp;  % Real GDP Per Capita 

  str='OUTNFB';    % output NFB
  str=upper(str);
  j = colnumber(str,namevec);
  output_nfb=datamat(:,j);
  
  str='HOANBS';    % Hours NFB
  str=upper(str);
  j = colnumber(str,namevec);
  hours_nfb=datamat(:,j);
  
  str='GDI';    % nomimal GDI
  str=upper(str);
  j = colnumber(str,namevec);
  gdi=datamat(:,j);
  
  str='CPAXTAX';    % Corporate Profits (Nominal) 
  str=upper(str);
  j = colnumber(str,namevec);
  corp_prof=datamat(:,j);
  corp_prof_share = 100*(corp_prof./gdi);    % Corporate Profit Share in Percentage Points 
  
  str='COMPRNFB';    % Get Real Compensation per Hour 
  str=upper(str);
  j = colnumber(str,namevec);
  comp_hr=datamat(:,j);
  
  str='OPHNFB';    % Get Output per Hour
  str=upper(str);
  j = colnumber(str,namevec);
  oph_nfb=datamat(:,j);
  
  str='DTFP';    % Fernald TFP
  str=upper(str);
  j = colnumber(str,namevec);
  d_tfp=datamat(:,j);
  
  str='DTFP_UTIL';    % Fernald TFP
  str=upper(str);
  j = colnumber(str,namevec);
  d_tfp_util=datamat(:,j);
  
  str='FE_SURP';    % Full Employment Surplus (as percent of potential output)
  str=upper(str);
  j = colnumber(str,namevec);
  fe_surp=datamat(:,j);
  
  str='D_HOUSE';    % Democrats control House
  str=upper(str);
  j = colnumber(str,namevec);
  d_house=datamat(:,j);
  
  str='D_SENATE';    % Democrats control Senate
  str=upper(str);
  j = colnumber(str,namevec);
  d_senate=datamat(:,j);
  
  str='D_FED';    % Federal Reserve Chair was nominated by Democratic President
  str=upper(str);
  j = colnumber(str,namevec);
  d_fed=datamat(:,j);

  str='Killian_OPEC';    % Killian Opec Oil Shortfall
  str=upper(str);
  j = colnumber(str,namevec);
  k_oil=datamat(:,j);
  
  str='R_NEWS';    % Ramey News
  str=upper(str);
  j = colnumber(str,namevec);
  ramey_news=datamat(:,j);

  str='FP_EXRET';    % Fisher-Peters
  str=upper(str);
  j = colnumber(str,namevec);
  fp_exret=datamat(:,j);
  
  str='RR_EXTAX';    
  str=upper(str);
  j = colnumber(str,namevec);
  rr_extax=datamat(:,j);
  
  str='DRIWCIL';     % SLOOS
  str=upper(str);
  j = colnumber(str,namevec);
  frb_sloos=datamat(:,j);
  
  str='ICE';    
  str=upper(str);
  j = colnumber(str,namevec);
  ice=datamat(:,j);
  ln_ice = log(ice);
  
  str='ICC';    
  str=upper(str);
  j = colnumber(str,namevec);
  icc=datamat(:,j);
  ln_icc = log(icc);
  
  str='ICS';    
  str=upper(str);
  j = colnumber(str,namevec);
  ics=datamat(:,j);
  ln_ics = log(ics);

  str='UK_G_GDP';    
  str=upper(str);
  j = colnumber(str,namevec);
  uk_g_gdp=datamat(:,j);
  uk_g_gdp = 100*((1+0.01*uk_g_gdp).^4-1);
  
  str='UK_LEFT';    
  str=upper(str);
  j = colnumber(str,namevec);
  uk_left=datamat(:,j);
  
  str='FR_G_GDP';    
  str=upper(str);
  j = colnumber(str,namevec);
  fr_g_gdp=datamat(:,j);
  fr_g_gdp = 100*fr_g_gdp;
  
  str='FR_LEFT';    
  str=upper(str);
  j = colnumber(str,namevec);
  fr_left=datamat(:,j);

  str='CN_G_GDP';    
  str=upper(str);
  j = colnumber(str,namevec);
  cn_g_gdp=datamat(:,j);
  
  str='CN_LEFT';    
  str=upper(str);
  j = colnumber(str,namevec);
  cn_left=datamat(:,j);
  
  str='DE_G_GDP';    
  str=upper(str);
  j = colnumber(str,namevec);
  de_g_gdp=datamat(:,j);
  de_g_gdp = 100*((1+0.01*de_g_gdp).^4-1);

  str='DE_LEFT';    
  str=upper(str);
  j = colnumber(str,namevec);
  de_left=datamat(:,j);
  
  str='OECD_GDP_E';    
  str=upper(str);
  j = colnumber(str,namevec);
  oecd_gdp_e=datamat(:,j);
  oecd_gdp_e = 4*oecd_gdp_e;  % Annual Rate 
  
  str='Exports';    
  str=upper(str);
  j = colnumber(str,namevec);
  exports=datamat(:,j);
  d_exports = 400*dif(log(exports),1);

 calvec = calvec_q;
 dnobs = dnobs_q;
 calds = calds_q;
 nper = 4;

% ------------- Construct Some Additional Series ------------ 
     % -- Inflation -- 
     d_pgdp = 400*dif(log(p_gdp),1);
     d_ppce = 400*dif(log(p_pce),1);
   
     % -- Real Returns -- 
     vwret_r = vwret - d_ppce;
     sp500ret_r = sp500ret - d_ppce;
     
     % -- Exchange Rates
     d_exrate = 400*dif(log(exrate),1);
   
     % -- Detrended GDP Growth Rates -- @
     g_gdp = NaN*zeros(dnobs,1);
     g_gdp(2:dnobs) = 100*(((gdp(2:dnobs)./gdp(1:dnobs-1)).^4)-1.0);
     g_gdp_trd_inf = ones(dnobs,1)*mean(packr(g_gdp));
     g_gdp_trd_100 = bw_trend(g_gdp,100);
     g_gdp_trd_67 = bw_trend(g_gdp,67);
     g_gdp_trd_33 = bw_trend(g_gdp,33);
     g_gdp_dt_inf = g_gdp - g_gdp_trd_inf;
     g_gdp_dt_100 = g_gdp - g_gdp_trd_100;
     g_gdp_dt_67 = g_gdp - g_gdp_trd_67;
     g_gdp_dt_33 = g_gdp - g_gdp_trd_33;
   
     % -- OECD Detrended Growth Rates -- 
     oecd_gdp_e_trd_100 = bw_trend(oecd_gdp_e,100);
     oecd_gdp_e_trd_67 = bw_trend(oecd_gdp_e,67);
     oecd_gdp_e_dt_100 = oecd_gdp_e - oecd_gdp_e_trd_100;
     oecd_gdp_e_dt_67 = oecd_gdp_e - oecd_gdp_e_trd_67;
   
      % -- Interest Rate Spreads -- @
     ted_spread = r_med3-r_tb3m;
     aaa_tb = r_aaa - r_tb3m;
     aaa_tb_lmq = r_aaa_lmq - r_tb3m_lmq;  % Last month in quarter 
     baa_aaa = r_baa-r_aaa;
     tb10y_tb3m = r_tb10y-r_tb3m;
     
     % -- h_oil over killian sample
     h_oilksmpl = h_oil;
     h_oilksmpl(isnan(k_oil)==1) = NaN;
   
   % -- Gali SVAR Productivity Shocks -- 
   svar_gali;
   
   % -- LR TFP Shocks -- 
   svar_dtfp1;
   svar_dtfp2;
   
   % -- Cholesky MP Shocks -- 
   svar_chol_mp;
   
   % Construct Various Shocks from regressions onto own lags and lags of real GDP growth @
   nlag_o = 4;
   nlag_x = 4;

% Save Variable Series 
  ylist = {...
           'baa_aaa' ...
           'gz_ebp' ...
           'ted_spread' ...
           'frb_sloos' ...
           'ln_ice' ...
           'ln_icc' ...
           'ln_ics' ...
           'ln_bbd' ...
           'jln' ...
           'oecd_gdp_e_dt_67' ...
           'd_exrate' ...
          }';
   d_gdp = 400*dif(log(gdp),1);
   d_pgdp = 400*dif(log(p_gdp),1);
   dd_pgdp = dif(d_pgdp,1);
   d_tb3m = dif(r_tb3m_lmq,1); 
   d_pcom = 400*dif(log(p_commodity),1);
   w = [d_gdp dd_pgdp d_pcom d_tb3m];
   for iseries = 1:size(ylist,1);
       ustr = char(ylist(iseries));
       eval(['y = ' ustr ';']);
       nw = size(w,2);
	   x = NaN*zeros(dnobs,nlag_o+1+nlag_x);
	   for i = 1:nlag_o;
		   x(:,i)=lag(y,i);
       end;
       for i = 0:nlag_x;
         j = i*nw;
	     x(:,nlag_o+j+1:nlag_o+j+nw)=lag(w,i);
       end;
	   x = [ones(dnobs,1) x];
	   tmp = packr([y x]);
	   yp = tmp(:,1);
	   xp = tmp(:,2:end);
       b = xp\yp;
	   yres = y - x*b;
	   ustr_res = [ustr '_res'];
       eval([ustr_res '= yres;'])
   end;
       

   





