% Construct "Direct" forecasts of GDP growth from AR/VAR/ARX models
% mww, 7/22/2015

clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';


% Load Data 
dr_data_calendar;

% Growth rates as log differences
d_gdp = 400*dif(log(gdp),1);
d_gdp4 = 100*dif(log(gdp),4);
d_gdp4_lead = lag(d_gdp4,-4);


% % Panel D AR 
ifirst = [1947 1];
s = d_gdp;
outfile_name = [outdir 'fcst_direct_D_AR.out'];


% % Panel D VAR 
% ifirst = [1947 1];
% s = [d_gdp aaa_tb];
% outfile_name = [outdir 'fcst_direct_D_VAR.out'];

 
% % Panle D AR-NL 
% ifirst = [1947 1];
% s = [d_gdp rec_qtr (d_gdp.*rec_qtr)];
% outfile_name = [outdir 'fcst_direct_D_ARNL.out'];


% % Panel C AR 
% ifirst = [1969 1];
% s = d_gdp;
% outfile_name = [outdir 'fcst_direct_C_AR.out'];

% Panel C VAR @
% ifirst = [1969 1];
% s = [d_gdp aaa_tb];
% outfile_name = [outdir 'fcst_direct_C_VAR.out'];

% % Panle C AR-NL 
% ifirst = [1969 1];
% s = [d_gdp rec_qtr (d_gdp.*rec_qtr)];
% outfile_name = [outdir 'fcst_direct_C_ARNL.out'];


fileID = fopen(outfile_name,'w');

% Add lags 
nlag = 4;
s_lags = NaN*zeros(dnobs,size(s,2)*(nlag+1));
for ilag = 0:nlag;
	j = size(s,2)*ilag;
	s_lags(:,j+1:j+size(s,2)) = lag(s,ilag);
end;
x = [ones(dnobs,1) s_lags];
tmp = packr([calvec d_gdp4_lead x]);
calp= tmp(:,1);
y = tmp(:,2);
x = tmp(:,3:end);
ismpl = smpl(calp,ifirst,[2015 4],4);
y = y(ismpl==1,:);
x = x(ismpl==1,:);
calp = calp(ismpl==1,:);
b = x\y;
yfit = x*b;


% Results for each administration 
dem_dt =[ ...
[1949 1]; ...
[1961 1]; ... 
[1965 1]; ...
[1977 1]; ...
[1993 1]; ...
[1997 1]; ...
[2009 1]; ...
];

rep_dt = [ ...
[1953 1]; ...
[1957 1]; ...
[1969 1]; ...
[1973 1]; ...
[1981 1]; ...
[1985 1]; ...
[1989 1]; ...
[2001 1]; ...
[2005 1]; ...
];

dem_rslt = NaN*zeros(7,2);
rep_rslt = NaN*zeros(9,2);
for i = 1:size(dem_dt,1);
	dt = dem_dt(i,:);
	ii = smpl(calp,dt,dt,4);
    if sum(ii) > 0;
	 dem_rslt(i,1)=y(ii==1);
	 dem_rslt(i,2)=yfit(ii==1);
    end;
end;

for i=1:size(rep_dt,1);
	dt = rep_dt(i,:);
	ii = smpl(calp,dt,dt,4);
    if sum(ii) > 0;
	 rep_rslt(i,1)=y(ii==1);
	 rep_rslt(i,2)=yfit(ii==1);
    end;
end;

fprintf(fileID,'Average for Dems \n');
fprintf(fileID,'Actual and Fitted Value: %4.1f %4.1f \n', mean(packr(dem_rslt)));
fprintf(fileID,'Average for Reps \n');
fprintf(fileID,'Actual and Fitted Value: %4.1f %4.1f \n', mean(packr(rep_rslt)));
fprintf(fileID,'Differences \n');
fprintf(fileID,'Actual and Fitted Value: %4.1f %4.1f \n', mean(packr(dem_rslt))-mean(packr(rep_rslt)));
	

