% Averages by Party and Difference
%   mww, 7/22/2015
%

clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';
outfile_name = [outdir 'hist_by_party.out'];
fileID = fopen(outfile_name,'w');

% Load Data 
dr_data_calendar;

iq = 1;
qmin = 12;      % Minimum number of quarters in administration for computing results .. if less than this then data are missing @
nma = 6;        % Number of algs for HAC Standard errors

dem_rep_ind;

ylevel = gdp;
ydata = NaN(dnobs,1);
ydata(2:dnobs) = 100*(((ylevel(2:dnobs)./ylevel(1:dnobs-1)).^4)-1.0);

ismpl = smpl(calvec,[1949 2],[2013 1],4);
dem_y = ydata((ismpl.*dem_ind)==1);
rep_y = ydata((ismpl.*rep_ind)==1);
cal_dem = calvec((ismpl.*dem_ind)==1);
cal_rep = calvec((ismpl.*rep_ind)==1);

% Histrogram cells
ngrid = 11;
c_mid=linspace(-8,12,ngrid);
n2 = (c_mid(2)-c_mid(1))/2;
freq_dem = zeros(ngrid,1);
freq_rep = zeros(ngrid,1);
n_dem = size(dem_y,1);
n_rep = size(rep_y,1);
freq_dem(1) = sum(dem_y < (c_mid(1)+n2))/n_dem;
freq_rep(1) = sum(rep_y < (c_mid(1)+n2))/n_rep;
for ii = 2:ngrid-1;
   freq_dem(ii) = sum((dem_y >= c_mid(ii)-n2).*(dem_y < c_mid(ii)+n2))/n_dem;
   freq_rep(ii) = sum((rep_y >= c_mid(ii)-n2).*(rep_y < c_mid(ii)+n2))/n_rep;
end;
freq_dem(end) = sum((dem_y >= c_mid(end)-n2))/n_dem;
freq_rep(end) = sum((rep_y >= c_mid(end)-n2))/n_rep;
fprintf(fileID,'Histogram data \n');
fprintf(fileID,'X, Dem, Rep \n');
for i = 1:ngrid;
    fprintf(fileID,'%6.3f, %7.5f, %7.5f \n',[c_mid(i) freq_dem(i) freq_rep(i)]);
end;
    
 fprintf(fileID,'\n\n\n');
 fprintf(fileID,'Summary Statistics \n');
 fprintf(fileID,'n: %3i  %3i \n',[size(dem_y,1) size(rep_y,1)]);
 fprintf(fileID,'mean: %5.2f  %5.2f \n',[mean(dem_y) mean(rep_y)]);
 fprintf(fileID,'median: %5.2f  %5.2f \n',[median(dem_y) median(rep_y)]);
 fprintf(fileID,'sd: %5.2f  %5.2f \n',[std(dem_y) std(rep_y)]);
 fprintf(fileID,'skewness: %5.2f  %5.2f \n',[skewness(dem_y) skewness(rep_y)]);
 fprintf(fileID,'Excess kurtosis: %5.2f  %5.2f \n',[kurtosis(dem_y)-3 kurtosis(rep_y)-3]);
 [tmp,i_d]=min(dem_y);
 [tmp,i_r]=min(rep_y);
 fprintf(fileID,'Minimum %5.2f (%5.2f) %5.2f (%5.2f) \n',[dem_y(i_d) cal_dem(i_d) rep_y(i_r) cal_rep(i_r)]);
 [tmp,i_d]=max(dem_y);
 [tmp,i_r]=max(rep_y);
 fprintf(fileID,'Maximum %5.2f (%5.2f) %5.2f (%5.2f) \n',[dem_y(i_d) cal_dem(i_d) rep_y(i_r) cal_rep(i_r)])
 fprintf(fileID,'\n\n\n');
 
 % Eliminate four largest and four smallest obs 
 temp = sort(dem_y);
 md = mean(temp(5:end-4));
 temp = sort(rep_y);
 mr = mean(temp(5:end-4));
 fprintf(fileID,'Eliminating 4 smallest and largests obs, mean of D, R and DRGap: %5.2f, %5.2f, %5.2f \n',[md mr md-mr]);
 


