% Analyse fed funds and GDP Growth -- using all available obs */
% MWW, 7/22/2015

clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';
outfile_name = [outdir 'scatter_fedfunds.out'];
fileID = fopen(outfile_name,'w');

% Load Data 
dr_data_calendar;

iq = 1;

dem_rep_ind;

d_gdp4 = 100*dif(log(gdp),4);
d_gdp4_l4 = lag(d_gdp4,4);
inflation = 100*dif(log(p_pce),4);
real_fedfunds = r_fedfunds-inflation;
d_nom_ff = dif(r_fedfunds,4);
d_real_ff = dif(real_fedfunds,4);

ydata = [d_nom_ff d_gdp4_l4];    % Panel A 
%ydata = [d_real_ff d_gdp4_l4];    % Panel B 

Truman_2_y = ydata(Truman_2==1,:);
Eisenhower_1_y = ydata(Eisenhower_1==1,:);
Eisenhower_2_y = ydata(Eisenhower_2==1,:);
Kennedy_1_y = ydata(Kennedy_1==1,:);
Johnson_1_y = ydata(Johnson_1==1,:);
Nixon_1_y = ydata(Nixon_1==1,:);
Nixon_2_y = ydata(Nixon_2==1,:);
Carter_1_y = ydata(Carter_1==1,:);
Reagan_1_y = ydata(Reagan_1==1,:);
Reagan_2_y = ydata(Reagan_2==1,:);
BushG_1_y = ydata(BushG_1==1,:);
Clinton_1_y = ydata(Clinton_1==1,:);
Clinton_2_y = ydata(Clinton_2==1,:);
BushGW_1_y = ydata(BushGW_1==1,:);
BushGW_2_y = ydata(BushGW_2==1,:);
Obama_1_y = ydata(Obama_1==1,:);
 
dem = [Truman_2_y(4:end,:);Kennedy_1_y(4:end,:);Johnson_1_y(4:end,:);Carter_1_y(4:end,:);Clinton_1_y(4:end,:);Clinton_2_y(4:end,:);Obama_1_y(4:end,:)];
rep = [Eisenhower_1_y(4:end,:);Eisenhower_2_y(4:end,:);Nixon_1_y(4:end,:);Nixon_2_y(4:end,:);Reagan_1_y(4:end,:);Reagan_2_y(4:end,:);BushG_1_y(4:end,:);BushGW_1_y(4:end,:);BushGW_2_y(4:end,:)];
   
tmp = packr(dem);
ydem = tmp(:,1);
xdem = tmp(:,2);
x = [ones(size(tmp,1),1) tmp(:,2)];
[db,vdb]=hac(ydem,x,6,1);
fprintf('Means for Dems, Y and X %6.2f %6.2f %i3 \n',[mean(tmp) size(tmp,1)]);
fprintf('Dem Slope %6.2f (%6.2f) \n',[db(2) sqrt(vdb(2,2))]);


tmp = packr(rep);
yrep = tmp(:,1);
xrep = tmp(:,2);
x = [ones(size(tmp,1),1) tmp(:,2)];
[rb,vrb]=hac(yrep,x,6,1);
fprintf('Means for Reps, Y and X %6.2f %6.2f %i3 \n',[mean(tmp) size(tmp,1)]);
fprintf('Rep Slope %6.2f (%6.2f) \n',[rb(2) sqrt(vrb(2,2))]);

% Interacted regression 
y = [ydem;yrep];
x = [xdem;xrep];
dem_ind = zeros(size(y,1),1);
dem_ind(1:size(ydem,1)) = ones(size(ydem,1),1);
x = [ones(size(y,1),1) dem_ind x (dem_ind.*x)];
[b,vb]=hac(y,x,6,1);

 % scatter plot
 xtmp = linspace(-5,11,100);
 ydtmp = db(1)+db(2)*xtmp;
 yrtmp = rb(1)+rb(2)*xtmp;
   plot(xdem,ydem,'+b','MarkerSize',8,'LineWidth',2);
   hold on;
     plot(xrep,yrep,'or','MarkerSize',8,'LineWidth',2);
     plot(xtmp,ydtmp,'--b','LineWidth',4);
     plot(xtmp,yrtmp,'-r','LineWidth',4);
   hold off;
   xlabel('4-Quarter change in ln(GDP) lagged 1 year');
   %ylabel('4-Quarter change in Nominal Federal Runds Rate');
   ylabel('4-Quarter change in Real Federal Runds Rate');
   ylim=([-4 2]);
   ax = gca;
   ax.FontSize = 20;
   ax.XLim = [-6 12];
 







