% Compute correlation of Shocks
%  mww, 7/22/2015


clear all;
small = 1.0e-10;
big = 1.0e+6; 

outdir = '/Users/mwatson/Dropbox/demrep/ddisk/matlab/out/';
outfile_name = [outdir 'Shock_Correlation.out'];
fileID = fopen(outfile_name,'w');

% Load Data 
dr_data_calendar;

iq = 1;
qmin = 12;      % Minimum number of quarters in administration for computing results .. if less than this then data are missing @
nma = 6;        % Number of lags for HAC Standard errors

dem_rep_ind;
ismpl_main = smpl(calvec,[1949 2],[2013 1],4);

slist = {...
'h_oil' ...
'k_oil' ...
'd_tfp_util' ...
'eps_gali' ...
'dtfp_lr' ...
'dtfp_uadj' ...
'ramey_news' ...
'fp_exret' ...
'oecd_gdp_e_dt_67_res' ...
'd_exrate_res' ...
'rr_extax' ...
'rr_aer04' ...
'sz_ms' ...
'eps_chol_mp' ...
'baa_aaa_res' ...
'gz_ebp_res' ...
'ted_spread_res' ...
'frb_sloos_res' ...
'ln_icc_res' ...
'ln_ice_res' ...
'ln_bbd_res' ...
'jln_res' ...
};

% Read in Shocks 
for istr = 1:size(slist,2);
 ustr = char(slist(istr));
 eval(['ydata = ' ustr ';']);
 if istr == 1;
  ydata_mat = ydata;
 else;
  ydata_mat = [ydata_mat ydata];
 end;
end;
 
% Select for period of time when we have dems and reps @
 isel = (dem_ind+rep_ind).*ismpl_main;
 ydata_mat = ydata_mat(isel==1,:);
 
 nseries = size(ydata_mat,2);
 cormat = NaN*zeros(nseries,nseries);
 
 for i = 1:nseries;
     for j = 1:i;
       x = ydata_mat(:,i);
       y = ydata_mat(:,j);
       tmp = packr([x y]);
       x = tmp(:,1);
       y = tmp(:,2); 
       x = x - mean(x);   
       y = y - mean(y);
       num = x'*y;
       den = sqrt( (x'*x)*(y'*y));
       cor = num/den;
       cormat(i,j) = cor;
     end;
 end;
prtmat_comma(cormat,fileID,'%4.2f','\n');