% Monetary Policy VAR -- Cholesky Identification  

% Variables to include in VAR
d_gdp = 400*dif(log(gdp),1);
d_pgdp = 400*dif(log(p_gdp),1);
dd_pgdp = dif(d_pgdp,1);
d_r_fedfunds = dif(r_fedfunds,1); 
d_pcom = 400*dif(log(p_commodity),1);

s= [d_gdp dd_pgdp d_pcom d_r_fedfunds];       % Variables in VAR @
ii = calvec < 2008.99;                    
s_ii = s(ii==1,:);
calvec_ii = calvec(ii==1);

nlag = 4;          % Number of lags @

[betahat, seps, eps, Q, M, G] = varest(s_ii,nlag,1,calvec_ii,[1947 1],[2008 4],4,1);

% Form MP Shock from Wold Causal Ordering with Fed Funds Ordered Last 
y = eps(:,end);
x = eps(:,1:end-1);
tmp = packr([y x]);
yp = tmp(:,1);
xp = tmp(:,2:end);
bp = xp\yp;
eps_chol_mp = y - x*bp;

i1 = sum(calvec < calvec_ii(1));
i2 = sum(calvec > calvec_ii(end));

if i1 > 0;
 pad1 = NaN*zeros(i1,1);
 eps_chol_mp = [pad1;eps_chol_mp];
end;
if i2 > 0;
 pad2 = NaN*zeros(i2,1);
 eps_chol_mp = [eps_chol_mp;pad2];
end;