% Productivity Shock -- Gali LR Identification 

% Variables to include in VAR 
d_y = 400*dif(log(gdp),1);
d_emp = 400*dif(log(emp_est),1);
d_prod = d_tfp;
infl = 400*dif(log(p_gdp),1);
d_infl = dif(infl,1);
d_tb3m = dif(r_tb3m,1);
y1 = d_prod;
y2 = [d_emp d_infl d_tb3m];
dy2 = dif(y2,1);

nlag = 6;          % Number of lags 

% Regressors 
xreg = NaN*zeros(dnobs,1+(1+size(y2,2))*nlag);
xreg(:,1) = ones(dnobs,1);
j=1;
for i = 1:nlag;
 xreg(:,j+1) = lag(y1,i);
 j = j+1; 
end;
for i = 0:nlag-1;
 xreg(:,j+1:j+size(y2,2)) = lag(dy2,i);
 j = j+size(y2,2); 
end;

% Instruments 
zreg = NaN*zeros(dnobs,1+(1+size(y2,2))*nlag);
zreg(:,1) = ones(dnobs,1);
j=1;
for i=1:nlag;
 zreg(:,j+1) = lag(y1,i);
 j = j+1; 
end;
for i = 1:nlag;
 zreg(:,j+1:j+size(y2,2)) = lag(y2,i);
 j = j+size(y2,2); 
end;

tmp = packr([d_prod xreg zreg]);
yp = tmp(:,1);
xp = tmp(:,2:size(xreg,2)+1);
zp = tmp(:,size(xreg,2)+2:size(tmp,2));
b = inv(zp'*xp)*(zp'*yp);
dtfp_lr = d_prod-xreg*b;
