@ adf.prc      JHS 5/15/91
  proc to compute augmented DF statistic
  y = data vector
  nobs = no. observations desired in regression
  p = no. lags in first differences
  fdtrnd = 0  -- demean
         = 1  -- linearly detrend
 Returns:
  tdf = ADF t-statistic
  rhohat = OLS estimator of alpha(a) -- coefficient on y(t-1)
@
proc (2)=adf(y,p,nobs,fdtrnd);
  local nobs1,dy,x,ip,xxi,ehat,bhat,seesq,tdf;
  nobs1=minc(nobs|(rows(y)-p-1));
  dy=y[(p+2):rows(y),.]-y[(p+1):(rows(y)-1),.];
  x=y[(p+1):(rows(y)-1),.];
  ip=1; do until ip>p;
   x=x~(y[(p+2-ip):(rows(y)-ip),.]-y[(p+1-ip):(rows(y)-ip-1),.]);
  ip=ip+1; endo;
  x=x~ones(rows(x),1);
    if fdtrnd==1;  x=x~seqa(1,1,rows(x)); endif;
  x=x[(rows(x)-nobs1+1):rows(x),.]; dy=dy[(rows(dy)-nobs1+1):rows(dy),.];
  xxi=inv(x'x);bhat=xxi*(x'dy);
  ehat=dy-x*bhat; seesq=(ehat'ehat)/(rows(x)-cols(x));
  tdf=bhat[1,1]/sqrt(xxi[1,1]*seesq);
retp(tdf,1+bhat[1,1]);
endp;


