/* debugkw.prc */
/* proc debugkw(systmat);
local opt, tolz, tolp, k1, k1a, sa1, sa2, lz, nz, rz, t, z, h, poly;
local tem1, k2, k3, k4, k5, k6, LR, inflv, aev, linf, ninf, lfin, lfinix;
local flip, flip1, ns, nzev, nus, npd, str, track, ew, aew, sflip, sflip1;
local rf, i, i1, j, j1;
local nd, nf, AN, BN, reord, CFN; */

new;
library pgraph;
graphset;

/* *************************
		BEGIN USER INPUTS
**************************** */
#include setparms.gss;
#include ss1.gss;

/* #include moreckk.out;
#include moreckka.out; */
#include linold1.gss;
@ #include ss_rb4a.gss; @
tolz=10^(-10);
tolp=10^(-6);

/* *************************
		END USER INPUTS
**************************** */

opt=5;

do while opt/=0;

	print "Select the following debugging option";
	print "  ";
	print "   (0) quit";
	print "   (1) check for rows of zeros in [A B]";
	print "   (2) check for det(Az-B) nonzero graphically";
	print "   (3) check LR multipliers";
	print "   (4) check # stable roots versus # predetermined vraibles";
	print "   (5) check equations of the model";
	print " ";
	print "choose option: ";
	k1=con(1,1);
	opt=k1;

	if opt==1;

		tolz=10^(-6);

		print "Checking for rows of zeros in [A B]";
		print " ";

		tem1=A~B;
		sa1=sortc(maxc(abs(tem1')),1);
		sa2=sortind(maxc(abs(tem1')));
/* sa1 contains the absolute value of the biggest element of each row A.

sa2 contains indices that sort these from lowest to highest. */

@ determine location and number of rows of A with effectively zero elements @

		lz=(sa1.<tolz);
		nz=sumc(lz);

		print "Number of zero rows in [A B] is " nz;
		print "with zero being defined as less than tolz = 10^(-6)";
		print " ";
		
		if nz>0;
			lz=lz';
			rz=sa2[lz,1];
			print "The zero rows are: ";
			print rz;
		endif;

	elseif opt==2;

		print "Checking for |Az-B| non zero on z=(-10, 10)";
		print "which can be time consuming in large systems";
		print " ";

		t=1;
		z=-10;
		h=zeros(81,1);
		poly=zeros(81,1);
		do while z<=10;
			h[t,1]=z;
			poly[t,1]=det(A*z-B);
			z=z+1/4;
			t=t+1;
		endo;

		if poly==zeros(rows(poly),1);
			print "  ";
			print "Necessary condition for Solvability violated: |Az-B|=0";
			print "strike any key to continue";
			k2=keyw;
		else;
			print "  ";
			print "Necessary condition for Solvability satisfied: |Az-B| not = 0";
			print "strike any key to continue";
			k3=keyw;
		endif;

		@ plot(h,poly),title('Test of determinant '),xlabel('z'),ylabel('|Az-B|') @
		k4=keyw;
	
	elseif opt==3;

		if abs(det(A-B))>.00001;
		
			if rank(A-B)<cols(A);
				LR=zeros(ny,nx);
						
				i=0;
				do while i<=nlead;
					LR=LR+CF[.,i*nx+1:(i+1)*nx];
					i=i+1;
				endo;
				LR=inv(A-B)*LR; 
						
				output file=debugr.out reset;
				print "Long Runs Effects from Original System";
				print "long run effect of x(j) on y(i) is (i,j) element";
				print LR;
				print " ";
				print "results saved debugr.out";
				output off;
			else;
						
				print "(A-B) is rank deficient: multipliers not computed";
			endif;
		else;
			print "Matrix A-B is singular - long-run effects not calculable";
			print "Press a key to continue";
			print "";
			k1a=keyw;
		endif;

	elseif opt==4;

		print "choose a power of 10 to test for effectively infinite eigenvalues ";
		inflv=con(1,1);
@ critical value: a root is zero if it is less than 10^-inflv @

/* We are interested in the the nature of the solutions to |Az-B|=0: 
How many are infinite, how many finite but unstable, how many are stable 

For computational reasons, though, we look at the reciprocal solutions,
i.e., the solutions to |Bz-A|=0.   */

/*       ev=eig(A,B);  */
		load ev;
		ny=rows(ev);
@       ev[5,1]=0; @

/* solutions to |Bz-A|=0, i.e., the reciprocals to the generalized eigenvalues that we are used to thinking about. */

		aev=abs(ev);  @ absolute value of eigenvalues @
		nzev=rows(aev)-rows(packr(aev));

/* find the small solutions to |Bz-A|=0, i.e., the infinite solutions to |Az-B|=0. */
		inflv=10^(-inflv);
		linf=(aev.<inflv);
		ninf=sumc(linf);
		lfin=ones(rows(aev),cols(aev))-linf;  @ location of finite eigenvalues @

		flip=selif(aev,lfin);
		flip1=ones(rows(flip),1)./flip;  @ finite eigenvalues to |Az-B|=0 @

		nus=sumc(aev.<0.9999); 
/* number of unstable eigenvalues to |Az-B=0,
i.e., the solutions to |A-Bz|=0 that are just less than 1*/

		ns=sumc(aev.>=0.9999);
/*       nzev=ny-nus-ns; */
@ test for zero evs to |Az-B|=0, which show up as NaN solutions to |A-Bz|=0.  Example: a=1, b=0, z=a/b=NaN. @
		nus=nus-ninf;

		npd=cols(lpd);
		if rows(lpd)>cols(lpd);
			npd=rows(lpd);
		endif;
		print " ";
		print "Based on generalized eigenvalue analysis:";
		print " ";
		print "Number of infinite eigenvalues        (nf) = " ninf;
		print "Number of other unstable eigenvalues (nus) = " nus;
		print "Number of stable eigenvalues          (ns) = " ns;
		print "Number of predetermined variables    (npd) = " npd;
		print " ";
		print "this last entry may include zero stable evs";
		str= "A count suggests "$+ftos(nzev,"%*.*lf",1,0)$+" zero eigenvalues";
		print str;
		print;
		print "press any key to continue";
		print;
		k5=keyw;

		print "System reduction analsysis:";
		print;

		track=1;

#include csr.prc
#include mconv.prc
#include redkw.prc
	{ nd,nf,AN,BN,reord,CFN }=redkw(A,B,CF,nx,lpd,track,&mconv,&csr);

		ew=eig(BN[nf+1:ny,nf+1:ny]);
		aew=abs(ew);

		sflip1=sortc(flip1,1);
/* this next part only necess in Matlab, which seems to move
missing values around differently than Gauss */
/*       rf=rows(flip1);
		sflip=sflip1[(nus+ns+1):rf,1]|sflip1[1:nus+ns,1]; */
		
		print "Finite eigenvalues (in modulus)";
		print "before and after reduction:";
		aew=sortc(aew,1);
		tem1=sflip1~aew;
		print tem1;
		print " ";
		print "strike any key to continue";
		k6=keyw;
	
	elseif opt==5;

		output file=debugr.out on;

		print "NOTE:  This equation checker will work correctly IFF the entries in your  ";
		print "       variable list are ordered exactly as you have numbered your variables. ";
		print "       You will need to have your A, B, and CF matrices in memory, along ";
		print "       with your lists of variable names and shock names.";
		print " ";
		print " ";

		print "What is your list of variables called? ";
		i=cons;
		i1=varget(i);
		i1=""$+i1;
		print "What is your list of shocks called?";
		j=cons;
		j1=varget(j);
		j1=""$+j1;
		print "  ";

#include eqnbugs.prc;
		i=eqnbugs(A,B,CF,i1,j1);
		output off;

		print "NOTE:   If your list of equations is terribly long, you may wish to view the diary file.";
		print " ";

	elseif (opt/=0);
		print "Make a new selection that is between 0 and 5"; 
	endif;

endo;

/* retp(tem1);
endp; */
