proc (2)=dynkw(B,nf,ny,lpd,bcrit,track,schuryn,nb);
   local np, W, Q, T, lus, Llam, rLlam, tem, LER, MU, nus;
   local les,j;

@ dynkw.prc @

/* This program computes the LE,MU matrices that are used
to solve the "fundamendal dynamic equation" of the model,
which has been isolated in the program redkw.m

This equation takes the form

   Ed(t+1)|I(t) = W d(t) + psid(F) Ex(t)|I(t)

where d(t) is a vector of dynamic variables in the reduced
system.  The program redkw.m found "nf" elements of the y(t)
vector that are excluded from this dynamic system.  Thus, there 
are nd=ny=nf elements of d(t).  to be used in dynamic solution
programs (relies on function lus.m)

To solve this system, we must find a "diagonalization" of it, 
as in Blanchard and Kahn, that allows for the decoupling of the
dynamic variables that are unstable from those that are stable.
There are two methods allowed: an eigenvector method (with or 
without the balancing of the eigenvalues) and a schur decomposition
method.  The latter is numerically most stable and accurate, but
may be slower.
*/

np=cols(lpd); 
if track==1 .and schuryn==0;
   print "";
   print "dynkw: default is balanced eigenvalues";
   print "Set 8th argument to nb=1 for nonbalanced eigenvalues";
endif;

nf=ny-nd;
W=B[nf+1:ny,nf+1:ny];
if schuryn/=1;

/* The subroutine eigl.prc computes the left eigenvectors of W, using
a balance (nb=0) or no balance (nb=1) option as indicated by the 
researcher in the call to dynkw */
   { LER,MU }=eigl(W,nb);
else;

/* The schurl program yields a decomposition, LS*W*LS'=T
where T is LOWER triangular  (Note lower and not upper)
and the diagonal entries of T are the ordered
eigenvalues of  W with T[i,i] >= T[j,j], for i < j. */

   { LER,MU }=schurl(W);
endif;

/* In either case, we now have matrices that isolate the unstable
eigenvalues first and then isolate the stable eigenvalues.
Determine the number of eigenvalues greater than critical level */

/* print abs(diag(MU)); */
nus=sumc(abs(bcrit*diag(MU)).>1);

/* Select the portion of the LE matrix that isolates these eigenvalues. */

if nus>0;
   LER=LER[1:nus,.];
   "eigenvalues are";
   abs(diag(MU));
   MU=MU[1:nus,1:nus];
   
else;
   print "";
   print "System has no unstable eigenvalues - Gauss solution will not work";
   LER={ 0 };
   MU={ 0 };
endif;

@ Tests of the decomposition @

/* Test 1: are there the same number of unstable roots
as there are nonpredetermined variables in 
the reduced system? */

if track==1;
   print "";
   tem=1/bcrit;
   print "dynkw: critical value for instability is " tem;
   print "which corresponds to bcrit = " bcrit;
   print"";
endif;

tem=nd~np~nus;
print tem;
if nus>nd-np;
   print "";
   print "Using a critical value of bcrit =" bcrit;
  print "There are too many unstable roots, i.e., roots such that";
  print "bcrit*mu >=1.  Hence, there is no stable solution to the model";
  print "This can be due to an inappropriate choice of bcrit, an intrinsically";
  print "unsolvable model, or an error in the specified system";
  print "Use debugkw.m to look into system errors, which could include";
  print "the wrong number of predetermined variables";
  print "  ";
  print "Dimension of reduced system            " np;
  print "Number of nonpredetermined variables: " nd-np;
  print "Number of unstable roots               " nus;
  print "  ";
  print "Program will terminate";
   stop;
endif;

if nus<nd-np;
  print " ";
  print "Using a critical value of bcrit =" bcrit;
  print "There are too few unstable roots, i.e., roots such that";
  print "bcrit*mu >=1. Equivalently, there are too many stable roots";
  print "Hence, there are multiple stable RE solutions to the model";
  print "This can be due to an inappropriate choice of bcrit, a model that";
  print "cannot be uniquely solved, or an error in the specified system";
  print "Use debugkw.m to look into system errors, which could include";
  print "the wrong number of predetermined variables";
  print "  ";
  print "Dimension of reduced system            " np ;
  print "Number of nonpredetermined variables:  " nd-np;
  print "Number of unstable roots               " nus;
  print "  ";
  print "Program will terminate";
  stop;
endif;

if nus>0; @ If there are unstable roots @
   
/* Test 2: is it possible to associate the unstable canonical
        variables and the nonpredetermined variables? */

   Llam=LER[.,1:nus];
   rLlam=rank(Llam);

   if nus>rLlam;
      print "";
      print "dynkw: Rank condition on Llam is violated";
      print "Number of unstable roots: " nus;
      print "Rank of Llam:" rLlam;
      print "Llam:";
      print Llam;
      print "Model cannot be solved: program should be terminated";
      print "Run debugkw program to check system";
      stop;
   endif;

endif;

/* Orthonormalize LE result to match Matlab */
/* les=(abs(LER))'.^2;
les=sumc(les.^(.5));
/* print les;
print; */
j=1;
do while j<=rows(LER);
   LER[j,.]=LER[j.,]./les[j];
   j=j+1;
endo; */
/* print "LER" LER[1:3,.]';
print; */

retp(LER,MU);
endp;

