proc(2) = eigl(W,nb);
   local LER, MU, mud, mudd, nw, ord;

/* subroutine to undertake the following tasks:
 (1) compute the left eigenvalues and eignvectors of W,
     allowing the user to specify whether the eigenvalues
     are balanced or not;
 (2) reorder the eigenvalues and eigenvectors so that the
     the eigenvalues occur in diminsising absolute value. */

/* The Gauss eigv command computes the right eigenvectors of W, so
we begin by specifying how to use this code to find left eigenvectors.

The right eigenvectors of W are a matrix RE such that W*RE=RE*MU
The left eigenvectors of W are a matrix LE such that LE*W=MU*LE
where in each case MU is the diagonal matrix of eigenvalues.  Thus,
taking the transpose of LE*W=MU*LE, we find that W'*LE'=LE'*MU'=LE'*MU
where the last equality stems from the fact that MU is diagonal. Thus,
the left eigenvectors of W can be found by computing the right 
eigenvectors of W' and then transposing the result.

Compute the left eigenvectors of W'.*/

if (nb==1);
   print "Note that in Gauss, non-balanced evals is not an option";
   print "Program will use regular evals";
   { MU,LER }=eigv(W');
else;
   { MU,LER }=eigv(W');
endif;

LER=LER.';

@ Order the eigenvalues of W from highest to lowest in absolute value @

nw=cols(W);

ord=sortind(abs(MU));  @ eigenvalues sorted in ascending absolute value @

ord=rev(ord)';
mud=MU[ord,.];

MU=diagrv(eye(rows(LER)),mud);
LER=LER[ord,.];

/* print "LER" LER;
print; */

retp(LER,MU);
endp;

