/* facvskw.prc */

print "facvskw.prc: This program retrieves desired components of the";
print "filtered autocovariance generating function created by fdfkw.prc";
print "and stored in fdfilter.cfg.";

print "Optionally load FACV from fddilter.mat? 1 for yes ";
ld=con(1,1);

if ld==1;
   clear FACV;
   run fdfilter;
   print "fdfilter.fcg loaded";
else;
   print "using results in existing workspace";
endif;

print "The lags available are: ";
print lags;
print "if this is not what you want, then you must re-run fdfilter";
pause(2);

print "Prepare Tables (1) or Look at Selected Correlations (2)";
opt=con(1,1);

if opt==1;

   nM=rows(M);

   sl=rows(list);
   i=1;
   do while i<=sl;
      tem1=zeros(1,2);
      tem1[1,1]=list[i,.];
      tem1[1,2]=ftos(i,"%*.*lf",1,0); 
      print $tem1;
      i=i+1;
   endo;

   print "";

   print "choose reference variable : ";
   r=con(1,1);
   print "";
   print "reference variable is " $list[r,.];
   pause(2);
   cls;

   print "the standard lags for correlations with reference variable";
   print "are  +/- 1,2,4,8,12 ";
   print "edit lags? 1 for yes, 0 for no ";
   edt=con(1,1);

   if edt==1;
      print "input a new vector in form: [1 2 4 8 12] ";
      print "type a semicolon when finished: ";
      lv=con(1,20);
      lv=lv';
      lv=delif(lv,lv.<=0);
      lv=lv';
   elseif edt==0;
      lv={ 1 2 4 8 12 };
   else;
      print "inadmissable editing choice: program will finish";
      stop;
   endif;
   cls;

   print "the standard lags for autocorrelations";
   print "are:   1,2,4 ";
   print "edit lags? 1 for yes, 0 for no ";
   edt=con(1,1);

   if edt==1;
      print "input a new vector in form: [1 2 4] ";
      print "type a semicolon when finished: ";
      alv=con(1,20);
      alv=alv';
      alv=delif(alv,alv.<=0);
      alv=alv';
   elseif edt==0;
      alv={ 1 2 4 };
   else;
      print "inadmissable editing choice: program will finish";
      stop;
   endif;
   cls;

   print "the default ordering is given in the table";
   print $list;
   print "edit table: 1 for yes, 0 for no ";
   edt=con(1,1);

   if edt==1;
      print "input a new vector in form: [1 2 3 ....] ";
      print "the number of elements is up to you ";
      print "but the reference variable must be included ";
      print "type a semicolon when finished: ";
      ord=con(1,ny);
      alv=delif(ord,ord.<=0);
      iord=ord;
   else;
      print "default ordering chosen";
      iord=seqa(1,1,ny)';
      ord=iord;
   endif;

   cls;

@ Compute the standard deviations of the variables: @

   sd = sqrt(diag(FACV[1:rPI,1:rPI]));
   tcorr=sd.*.sd';

/* Create relative volatility measure by dividing through by the
standard deviation of reference variable */

   sdr = sd./sd[r,1];

/* create a blank table with enough space for own autocorrelations and cross
correlations with output:
compute number of entries in table:
std, rel std, auto, cross */

   ent=1+1+cols(alv)+2*cols(lv)+1;

   TABL=zeros(rPI,ent);  
   TABL[1:rPI,1] = sd;
   TABL[1:rPI,2] = sdr;

/* Compute Correlation Matrix of Variables:

Operate on tcorr to avoid division by zero in next step */

   i=1;
   j=1;
   do while i<=rPI;
      do while j<=rPI;
         if tcorr[i,j]==0;
            tcorr[i,j]=1;
         endif;
         j=j+1;
       endo;
      i=i+1;
   endo;

   Corr=FACV[1:rPI,1:rPI]./tcorr;

/* Select reference column of correlation matrix (e.g., correlation with output):

identify the reference variable correlation column */

   rcrcol=2+cols(alv)+cols(lv)+1;

@  place correlations with reference variable in table @

   TABL[1:rPI,rcrcol]=Corr[1:rPI,r];

@ CROSS CORRELATIONS WITH REFERENCE VARIABLE: @

   j=1;
   do while j<=cols(lv);
      TEMP=FACV[.,j*rPI+1:(j+1)*rPI]./tcorr;
      TABL[1:rPI,rcrcol+j]=TEMP[r,1:rPI]';
      TABL[1:rPI,rcrcol-j]=TEMP[1:rPI,r];
      j=j+1;
   endo;

@ AUTOCORRELATIONS  @

   j=1;
   do while j<=cols(alv);
      TEMP=FACV[.,j*rPI+1:(j+1)*rPI]./tcorr;
      TABL[1:rPI,2+j]=diag(TEMP);
      j=j+1;
   endo;

@ Select and reorder the variables @

   h=cols(TABL);
   m=rows(ord);
   RTAB=zeros(m,h);

   j=1;
   do while j<=m;
      RTAB[j,.]=TABL[ord[1,j],.]; 
      j=j+1;
   endo;

   output file=facvs.out reset;
   print $list;

   print "Variance Covariance Matrix of Shocks to System:";
   print Vii;
   format /rd 1,2;
   print "columns of tables are std, rstd, autocorrelations, cross correlations";
   print "autocorrelations: ";
   print alv;
   print "cross correlations: ";
   print lv;
   print "Contemporaneous Correlation Matrix of Variables:";
   print Corr;
   print "extended table with rows ordered as follows:";
   print "states, forecasting variables, controls, etc.";
   print TABL;
   print "selected table with variables ordered as per variable list";
   print iord;
   print RTAB;
   print "Contemporaneous Correlation Matrix of Variables:";
   print Corr;
   format /ros 16,8;
   output off;

   print "Standard Tables Have Been Prepared: ";
   print "Information is In facvs.out";

   print "Look at Selected Correlations? 1 for no and 2 for yes";
   opt=con(1,1);
endif;

if opt==2;

@ Compute the standard deviations of the variables: @

   sd = sqrt(diag(FACV[1:rPI,1:rPI]));
   tcorr=sd.*.sd';

   nd=1;

   do while nd==1;
      print "Available Lags Are:" lags;
      print "lag = ";
      tau=con(1,1);
      
      print $list;
      print "Enter pair of variables: in form [1 2] ";
      pr=con(1,2);

      j=minindc(abs(lags-abs(tau))'); @ selects the FACV index corresponding to lag; @
      j=j-1;

      TEMP=FACV[.,j*rPI+1:(j+1)*rPI]./tcorr;

      if tau>=0;
         print "tauth order cross-correlation between variables";
         print "tau = " tau;
         print $list[pr,.];
         print "correlation is " TEMP[pr[1,1],pr[1,2]];
      else;
         print "tauth order cross-correlation between variables";
         print "tau = " tau;
         print $list[pr,.];
         print "correlation is " TEMP[pr[1,2],pr[1,1]];
      endif;

      print "Look at another (1) or quit (2) ";
      nd=con(1,1);
   endo;
endif;

