/* fdfkw.m
frequency domain filtering of state space model */

dos del fdfilter.mat;
t1=date;

@ specify lags for filter autocovarieances @

lags={ 0 1 2 4 8 12 };
nlgs=cols(lags);


@ determine size of M matrix @

nM=rows(M);

@ identity matrix of size of M @

if rows(M)==1;
   Minv=1;
else;
   Minv=eye(rows(M));
endif;


@ number of points at which Fourier transform is evaluated: 2*m @

littlem=200;

@ set grid for omega in evaluationg spectral density, etc. @

bnd=-1+(1/(2*littlem));
om=seqa(bnd,1/littlem,2*littlem);
om=om';
om=om*pi;

@ define imaginary number @
im=sqrt(-1);

print "Select Filter:";
print " 0 = No Filter";
print " 1 = First Difference";
print " 2 = Exact Bandpass";
print " 3 = Approximate Bandpass";
print " 4 = Hodrick Prescott";
print " 5 = Truncated Hodrick-Prescott";

print "Selection = ";
ch=con(1,1);

if ch==0;
   @ No Filter @
   ftfil=ones(1,cols(om));
   xy((om./pi)',ftfil');
   /* title('transfer function of null filter";
   pause
   close */
elseif ch==1;
   @  First Difference Filter @
   ftfil=ones(1,cols(om))-exp(-im*om);
   ftfil=abs(ftfil).^2;
   xy((om./pi)',ftfil');
   /* title('transfer function of first difference";
   pause
   close */
elseif ch==2;
@ Exact Bandpass Filter @

/* Period corresponding to upper cutoff frequency
   updc=2 makes this a high pass filter (since period = 2 implies om=pi). */
   updc=6;

@ Period corresponding to lower cutoff frequency @
   lpdc=32;

@ Implied Frequencies @
   omubar=2*pi/updc;
   omlbar=2*pi/lpdc;

   top=(abs(om).>omubar); @ high frequencies @
   bot=(abs(om)<omlbar); @ low frequencies @
   ftfil=ones(1,cols(om))-top-bot;
   xy((om./pi)',ftfil');
   /* title('transfer function of exact bandpass";
   pause
   close */

elseif ch==3;

@ Approximate Bandpass Filter @

/* Period corresponding to upper cutoff frequency
   updc=2 makes this a high pass filter (since period = 2 implies om=pi). */
   updc=6;

@ Period corresponding to lower cutoff frequency @
   lpdc=32;

@ Implied Frequencies @
   omubar=2*pi/updc;
   omlbar=2*pi/lpdc;

/* To construct a low pass filter, with a cutoff frequency of "ombar",
we note that the transfer function of the approximating filter
is given by:

 alpha(om) = a0 + a1 cos(om) + ... aK cos(K om)

and the ak's are given by:

 a0 = ombar/(pi)

 ak = sin(k ombar)/(k pi)

where ombar is the cutoff frequency.

We employ the fact that a bandpass filter is the difference between two 
low pass filters,
  bp(L) = bu(L) - bl(L)
with bu(L) being the filter with the high cutoff point and bl(L) being 
that with the low cutoff point. */

@ set number of leads/lags @
   bigk=32;

@ Construct Filter Weights @

   akvec=zeros(1,bigk+1);

   akvec[1,1]=(omubar-omlbar)/(pi);

   k=1;
   do while k<=bigk;
      akvec[1,k+1]=(sin(k*omubar)-sin(k*omlbar))/(k*pi);
      k=k+1;
   endo;

/* Impose constraint that transfer is zero at om = 0 
This amounts to requiring that weights sum to zero.
Initial sum of weights: */

   lam=akvec[1,1]+2*sumc(akvec[1,2:bigk+1]');

@ amount to add to each weight to get sum to add to zero @
   lam=-lam/(2*bigk+1);
   akvec=akvec+lam;

   ftfil=akvec[1,1]*ones(1,cols(om));
   k=1;
   do while k<=bigk;
      ftfil=ftfil+akvec[1,k+1]*2*cos(om*k);
      k=k+1;
   endo;

   ftfil=ftfil.^2;
   xy((om./pi)',ftfil');
   /* title('transfer function of app bp filter";
   pause
   close */

elseif ch==4;

/* HPFilter
Compute the transfer function */
   lam=1600;
   ftfil=(4*lam*(1-cos(om)).^2)./(1+4*lam*(1-cos(om)).^2);
   xy((om./pi)',ftfil');
   /* title('transfer function of Hodrick-Prescott filter";
   pause
   close */

elseif ch==5;

   lam=1600;
   hpfilt=(4*lam*(1-cos(om)).^2)./(1+4*lam*(1-cos(om)).^2);

/* Truncated HP filter used in KR's "Low Frequency Filtering" paper

Treat this as a 103 element moving average.  Compute the transfer 
function by evaluating this moving average at all points on the grid. */
   maxf=51;

   print "constructing lag weights of truncated HP filter";

@ Construction of Lag Weights @

   FILT=zeros(1,2*maxf+1);
   FILT[1,maxf+1]=1-((.894^0)*(.0561*cos(.112*0) + .0558*sin(.112*0)));
   j=1;
   do while j<=maxf;
      FILT[1,maxf+1-j]=-(.894^j)*(.0561*cos(.112*j) + .0558*sin(.112*j)); @ change @
      FILT[1,maxf+1+j]=FILT[1,maxf+1-j];
      j=j+1;
   endo;

   print "constructing Transfer Function of Truncated HP Filter";

@ Construction of Transfer Function @

   filt1=zeros(1,2*littlem);

   j=-maxf;
   do while j<=maxf;
      filt1=filt1+FILT[1,maxf+1+j]*(exp(-im*om*j));
      j=j+1;
   endo;

   ftfil=abs(filt1).^2;
   xy((om./pi)',ftfil');
   /* title('transfer function of truncated Hodrick-Prescott";
   pause
   close */

else;
   print "inadmissable choice";
   stop;
endif;

print "computing power spectrum of filtered states";
print "  ";
print "  ";
nom=cols(om);

FSD=zeros(nM,nom*nM);
j=1;
do while j<=nom;
@ compute power spectrum of s @
   tem1 = inv(exp(im*om[1,j]).*Minv-M);
   tem1 = (tem1*Vii*tem1')./(2*pi);
   FSD[1:nM,1+(j-1)*nM:j*nM]=ftfil[1,j].*tem1;
   j=j+1;
endo;

print "computing the selected components of the";
print "autocovariance generating function";
print "of the filtered variables";

/* To do this, we first define a matrix of indexing vectors */

IND=zeros(nM,nM*nom);
i=1;
do while I<=nom;
   IND[1:nM,(i-1)*nM+1:i*nM]=eye(nM);
   i=i+1;
endo;

FSACV=zeros(nM,nM);
rPI=rows(PII);
FACV=zeros(rPI,nlgs*rPI);
n=1;

do while n<=nlgs;
   print "lag =" lags[1,n];

@ loop over the elements of the power spectrum of the filtered states @

   i=1;
   do while i<=nM;
      j=1;
      do while j<=nM;

   @ set indicator vector so to pick up i,j th elements of FSD @
         ind1=seqa(1,1,cols(IND));
         lind=selif(ind1,IND[j,.]')';

   @ get i,jth elements @
         tem1=FSD[i,lind];

   /* To generate the term in the autocovaraince generating function of
   of the filtered series: approximate the inverse fourier transform
   integral to with tau=0 */

         tau=lags[1,n];

   /*  Construct vector containing product of filter power spectrum and 
    the inverse Fourier transform weights, evaluated at pertinent lag: */

         tem1=tem1.*(exp(im*om*tau));

   /*  Sum these and weight by length of approximating segments to obtain
    approximation to integral: */

         tem1=sumc(tem1')*(pi/littlem);

   @ put this in the relevant spot @
         FSACV[i,j]=tem1;

         j=j+1;
      endo;  @ row loop @
      i=i+1;
   endo;  @ column loop @

/* compute the acv term for the filtered variables:"; */

   FACV[1:rPI,(n-1)*rPI+1:n*rPI]=real(PII*FSACV*PII');

   n=n+1;
endo;  @ lag loop @
/* print FACV; */

t2=date;
tm=ethsec(t1,t2)/100;
/* saveall fdfilter; */

print "computations completed";
print "elapsed time (in seconds) = " tm;
