proc(2) = givens(a,b);
   local tau, s, c;

/* This function file computes the two constants c and s
in the Givens Rotations described by Golub and Van Loan, 
section 5.1.8 (page 201-3).  Briefly, the Givens rotation
involves creating a modification of the identity matrix
in the ith and kth locations with G(i,i)=G(k,k)=c and
G(i,k)=s and G(k,i)=-s.  (This modification creates
an orthogonal matrix). The constants c and s are selectd
so that application of this matrix application
to a vector zeros a specified element. If "a" is the ith
element of a vector v and "b" is the kth element of v, then
Gv has "r" as the ith element and 0 as the kth element.

The algorithm described below is algorithm 5.1.5 in GL, p 202. */


if b == 0;

   c=1; s=0;

elseif abs(b) > abs(a);
   tau=-a/b; s=1/(sqrt(1+tau*tau')); c=s'*tau;

else;
   tau=-b/a; c=1/(sqrt(1+tau*tau')); s=c*tau;s=s';

endif;

retp(c,s);
endp;

