proc (3) = mdrkw(B,CF,Q,RHO,LER,MU,reord,nd,lpd,nx,bcrit,sc,toli);

   local npd,ny,nf,nlead,j,R,PHI,nus,q1,theta,IRHO,i,lamk,lamdr;
   local BT,B2,B3,nk,PII,ndrv,M,IPI,ind,back,t;
   local matl,matth, aaa, as,ix, asi;
   local im,H;    @ this line alw 4-27-00 @

npd=cols(lpd);
nus=rows(mu);

ind=sortc(reord',1);
back=sortind(reord');

if nus>0;
   ny=rows(B);
   nf=ny-nd;

/* Consider the equation: E d(t+1|t) = W d(t) + PSId(F) E x(t|t)

The solution strategy is then as follows:  We know that 
 (1)  LE*Ed(t+1|t) = LE*W d(t) + LE*PSId(F) Ex(t|t)
We know further that LE*W = MU * LE from the definition
of left eigenvectors (this holds for any set of eigenvectors).
Hence, equation (1) is the unstable canonical variables 
equation.  We can hence solve it "forward" as
 (2)  LE*d(t) = inv(MU)*LE Ed(t+1|t) -inv(MU)*LE*PSId(F) Ex(t|t) */

   nlead=cols(CF)/nx;
   nlead=nlead-1;

/* Calculate CF0*Q*I+CF1*Q*RHO+CF2*Q*RHO^2 + ...CFn*Q*RHO^nlead
      i.e., calculate C(F) Ex(t)|I(t) */

   R=eye(cols(RHO));
   PHI=CF[.,1:nx]*Q*R;
   
   j=0;
   do while j<nlead;
      R=R*RHO;
      PHI=PHI+CF[.,(j+1)*nx+1:(j+2)*nx]*Q*R;
      j=j+1;
   endo;

/* We now have a system in the form 
  A* E y(t+1)|I(t) = B y(t) + PHI drv(t),
with the A and B matrices having been "reduced" by dynkw.m
but we still need to rule out explosive paths, etc. Part of this system
is E d(t+1)|I(t) = W  d(t) +   PHId drv(t).  Multiplying this by LE we get
   Eu(t+1)|I(t) =  MU u(t) + LE*PHId drv(t), which are "separated"
dynamic equations for the nonpredetermined/unstable canonical
variables u(t) since MU is upper triangular. Set q = LE*PHI2.

To impose stability, we seek a matrix theta such that
theta*RHO = MU * theta + q.  There are then two cases
If MU is diagonal, then the ith row of theta satisfies:
thetai * RHO = MU(i,i) * thetai + qi => thetai = qi/(RHO-MU(i,i)*eye(RHO);
If MU is lower triangular, then we must add in some 
additional terms that involve MU(i,j)*thetaj for j
=1,2,...i-1. */

   q1 = LER*PHI[nf+1:ny,.];
   theta=zeros(nus,cols(PHI));
   IRHO=eye(cols(RHO));

   i=0;
   do until i==nus;
      i=i+1;
      theta[i,.]=q1[i,.];
      if sc==1;
         j=1;
         do while j<i;
            theta[i,.]=theta[i,.]+MU[i,j]*theta[j,.];
            j=j+1;
         endo;
      endif;
      theta[i,.]=theta[i,.]*inv(RHO-MU[i,i]*IRHO);
   endo;

/* We now know that u(t) = LE * d(t) = theta * drv(t).  We solve for lam(t),
the first nus elements of d(t), as lam(t) = -(Ll\Lk) k(t) + (Ll\theta) drv(t): */

   if npd>0;
      lamk=-LER[.,nus+1:nd]/LER[.,1:nus];
   endif;
   lamdr= inv(LER[.,1:nus])*theta;

   BT=B;

@ We want to impose this solution on the dynamic system, i.e.,
  "substitute out" for lam(t) using the above rule, which we write
  as lam(t) = lamk * k(t) + lamdr * drv(t).  We have equations of the form:
   B2 * lam(t) +         B3 * k(t) +   PHI           * m(t) = 0.  Adding

  -B2 * lam(t) +    B2*lamk * k(t) +   B2*lamdr      * m(t) = 0,  we get

   0  * lam(t) + B3+B2*lamk * k(t) +  (PHI+B2*lamdr) * m(t) = 0   @

   B2 = BT[.,nf+1:nf+nus];
   B3 = BT[.,nf+nus+1:ny];

@ incorporate the influence of k(t) via lam(t) into system.@

   if npd>0;
      BT[.,nf+nus+1:ny]=B3+B2*lamk;
   endif;

@ incorporate the influence of m(t) via lam(t) into system.@

   PHI=PHI+B2*lamdr;

@ patch up the lam(t) influences and the lam(t) equations.@
   BT[.,nf+1:nf+nus]=zeros(rows(B2),cols(B2));
   BT[nf+1:nf+nus,nf+1:nf+nus]=eye(nus);
   if npd>0;
      BT[nf+1:nf+nus,nf+nus+1:nf+nd]=-lamk;
   endif;
   PHI[nf+1:nf+nus,.] = -lamdr;

@ solve for state space system:
  z(t) =   PI*s(t)
  s(t+1) = M*s(t) + e(t+1)
  with s(t) = |k(t)  |   and z(t) = |y(t)|
              |m(t)  |              |k(t)|
                                    |x(t)| @

   ndrv=cols(Q);

   PII= ((-BT[1:nf+nus,nf+nus+1:ny])~(-PHI[1:nf+nus,.]))|
         (eye(npd)~zeros(npd,ndrv));

@ This is a PI matrix for the new ordering, we now create one
  for the old ordering and add exogenous variables @

   PII=  PII[back,.]|(zeros(nx,npd)~Q);

   M = (BT[nf+nus+1:ny,nf+nus+1:ny]~PHI[nf+nus+1:ny,.])|
        (zeros(ndrv,npd)~RHO);

endif;

@ test for the presence of larger imaginary components @

IPI=imag(PII);
t=maxc(maxc(abs(IPI)));
"MDRKW Largest Imaginary part of pii =";;t;

if t>toli;
   print "Imaginary component of PI is larger than " toli;
   print "This tolerance can be adjusted by setting the last argument";
   print "of the mdrkw function, as called in resolkw";
   print "Strike any key to continue";
   stop;
endif;

IM=imag(M);
t=maxc(maxc(abs(IM)));
"MDRKW Largest Imaginary part of M =";;t;

if t>toli;
   print "Imaginary component of M is larger than " toli;
   print "This tolerance can be adjusted by setting the last argument";
   print "of the mdrkw function, as called in resolkw";
   print "Strike any key to continue";
   stop;
endif;

M=real(M);
PII=real(PII);

@ these 2 lines added by alw 4-27-y2k @
H = zeros(rows(M),nshock);
H[npd+1:npd+nshock,.]=eye(nshock);

/* print "M" M;
print;
print "PII" PII;
print; */

retp(M,PII,H);
endp;
