proc (6) = redkw(A,B,CF,nx,lpd,track,&mconv,&csr);
   local tolz, tolp, ny,ord,npdloc,npd,pdloc,reord;
   local nf,nlead,it,nnf,Al,Be,sa1,sa2,ra,nz,nd,str;
   local U,S,V,Sd,UP,tem1,tem2,tem3,rowr,tol;
   local IA,Q,E,R,qx,qp,ncf,b1lam,reords,reordl,Rd;
   local mconv:proc,csr:proc;

@ redkw.prc @

@ This function file is the dynamic system reduction program
as described in "System Reduction and Model Solution Algorithms
for Singular Linear Rational Expectations Models." 

This version is designed to maximize computation speed in 
large systems by eliminating operations with large, sparse matrices.

The inputs are the dynamic system elements, i.e., the matrices
A,B, and CF=[C0 ... Cn], the parameter nx which indicates the number
of exogenous variables, and the vector lpd, which gives the 
location of predetermined variables.

Other potential elements are a tolerance levels:
'tolp' for determining when elements are nonzero,
'tolz' for determining when elements are zero.

The outputs a transformed dynamic system: matrices 
A,B, PSIF = [PSI0 ... PSIq] and the parameters nf and nd,
which indicates the number of variables eliminated in the 
reduction (nf) and the size of the dynamic subsystem
contained in the specified model (nd).

More formally, the program reduces a singular dynamic
system of the form:

  A Ey(t+1|t) = B y(t) + C(F) Ex(t|t),

with ny being the dimension of the vector of endogenous
variables y(t) and nx the dimension of x(t). The notation
Ey(t+k|t) means the rational expectation of y at date t+k
given information at t. The result is a dynamic system 
of the form:

 | 0  0  | |Ef(t+1|t)|   | I     K | |f(t)|    |PSIf(F)|
 |       | |         | = |         | |    |  + |       |  Ex(t|t)    
 | 0  I  | |Ed(t+1|t)|   | 0     W | |d(t)|    |PSId(F)| 

with nd the dimension of d(t) and with a reordering of variables
permitted. Theoretically, the reordering is a (permutation) matrix L, 
such that  
              | f(t) |
 L * y(t) =   |      |
              | d(t) |

but this is replaced by an ordering vector in the interest
of computational efficiency.

The notation reflects the idea that f(t) are variables
that are similar to "flows" that do not figure in the 
dynamic subsystem, once they have been "solved out." 
The remaining variables are intrinsically dynamic and
hence are called d(t). @

@ no setting of track or tols in this procedure - they
are created as local variables in control (??) program @

@ determine the size of the y(t) vector @

@ format /rd 1,2; @
ny=cols(A);
rowr=zeros(1,ny);

tolz=10^(-16);
tolp=10^(-16);
if track==1;
   print;   
   print "tolz parameter set to default value of 10^(-6)";
   print "tolp parameter set to default value of 10^(-10)";
   print;
endif;

@ REORDERING SYSTEM TO PLACE PREDETERMINED VARIABLES LAST

The KW solution algorithm allows for the variables
to be reordered, but allows no other transformations
of variables. The first step is to undertake the intial
reordering to place the predetermined variables are last.

The code is designed to run even if there are no 
predetermined variables (as in Cagan money demand
model or asset pricing models). @

if rows(lpd)>cols(lpd);
   lpd=lpd';
endif;

npd=cols(lpd);

ord=seqa(1,1,ny);

if npd>0;  @ construct a vector of original ordering @

@ location matrices for predetermined and nonpredetermined variables @
   
   npdloc=ones(ny,1); @ initialize location of nonpredetermined variables @
   npdloc[lpd,.]=zeros(cols(lpd),rows(lpd));
   pdloc=ones(ny,1)-npdloc;
   
@ construct a reordering vector @
   tem1=selif(ord,npdloc)';   
   tem2=selif(ord,pdloc)';
   reord=tem1~tem2;
@    reord=[ord[1,npdloc] ord[1,pdloc]]; @

@ Reorder columns of A and B to reflect reordering of variables @

   A=A[.,reord];
   B=B[.,reord];

else; @ If there are are no predetermined variables @
   reord=ord;
endif;

@ LOCATION OF OR INTRODUCTION OF ROWS OF ZEROS IN A @

@ We begin by specifying an initial number of flows (nf=0).
  As we progressively reduce the system, we always have
  systems of the form

   | 0  0  | |Ef(t+1)|I(t)|   | I     Nu | |f(t)|    |Ch1(F)|
   |       | |            | = |          | |    |  + |      |  Ex(t)|I(t)
   | 0  Al | |Ed(t+1)|I(t)|   | 0     Be | |d(t)|    |Ch2(F)|
@

ny=rows(A);
nf=0; @ number of flows initialized at zero @
  
nlead=cols(CF)/nx;
nlead=nlead-1; @ take account of C0 @

@ We describe two alternative approaches to introducing rows of zeros 
The system is partitioned:

A = | 0  0  |     B = | I     Nu|   C(F) =  |Cf~(F)|     
    | 0  Al |         | 0     Be|           |Cd~(F)|
@

Al=A[nf+1:ny,nf+1:ny];
Be=B[nf+1:ny,nf+1:ny];

@ We want to get some more zero rows in Al, making it

Al = |  0    0  |
     | a2lam a2k|


The standard way of doing this is to compute the singular value
decomposition of a.  But this may not be necessary if we are
on the first iteration and there are lots of rows of zeros in A.
Further, there are usually such rows of zeros because
most models have some equations with no leads.

Method 1:

Check for rows of zeros and then reorder A,B,CF
based on rows of zeros in A @

tem1=maxc(abs(A'));
  

sa1=sortc(tem1,1);
sa2=sortind(maxc(abs(A')));
 
/* { sa1,sa2 }=matlsort(tem1); */
sa1=sa1';
sa2=sa2';
/* print sa1;
print "";
print sa2;
print ""; */

@ sa1 contains the absolute value of the biggest
element of each row A. 
sa2 contains indices that sort these from lowest to highest. @

A=A[sa2,.];   @ rows of A are reordered to place zeros first. @
B=B[sa2,.];   @ rows of B are similarly reordered. @
CF=CF[sa2,.];   @ rows of C(F) are similarly reordered. @

@ determine number of rows of A with effectively zero elements @

nz=sumc(sa1'.<tolz);  
ra=ny-nz;
nd=ny;

if track>0;
   str="The initial step of redkw finds "$+ftos(nz,"%*.*lf",1,0);
   str=str$+" zero rows in A";
   print str;
   print "";
endif;
print " in redkw and nz =  ";;nz;
if nz==0;
   
@ Method 2: Computation of Singular Value Decomposition

  Find rows of A that are zero, by computing the svd @

 print " i am at line 207 in redkw and about to do svd  ";

   {U,S,V}=svd1(Al);
   if _svderr>0;
      print "Error in svd calculation - terminate program ";
      stop;
   endif;

@ U and V are unitary matrices (U*U'=I and V*V'=I) and S is
S = |sigma  0 |
    |  0    0 |
with sigma being a diagonal matrix with rank(a) postive numbers
(the singular values) on its diagonal.

The rank of a matrix is theoretically the number of non-zero
singular values.  We approximate this here as in the PC-MATLAB
rank command, where the computation is based on the number of
singular values greater than a given tolerance level. @

   Sd=diag(S);
   tol = cols(S)*Sd[1,1]*tolp;

   ra = sumc(Sd .> tol);

@ To utilize the svd, we need to make two system translations

System Translation #1:

We now want to transform the system, leaving the flow equations unaltered
but changing the equations describing the d(t) so that these are 
in form S*V'*Ed(t+1|t) = U'*b*d(t) + U'*Cd~(F)*Ex(t|t). @

   UP=U';

   A[nf+1:ny,nf+1:ny]=UP*A[nf+1:ny,nf+1:ny];
   B[nf+1:ny,nf+1:ny]=UP*B[nf+1:ny,nf+1:ny];

@ Translate the C(F) polynomial @
   CF[nf+1:ny,.]=mconv(UP,CF[nf+1:ny,.],0,nlead);

@ System Translation #2:

We also want to rearrange the ordering of the equations of the system
so that those with zeros appear before the non-degenerate ones. Formally,
this involves multiplying by a matrix:
  | I  0  0|
  | 0  0  I|
  | 0  I  0|
with suitably chosen dimensions of the identity matrices.  This trsansformation
is necessitated because the singular values are decreasing on
the diagonal of 'S'.  However, here is accomplished with a row reordering. @

   tem1=seqa(1,1,nf);
   tem1=tem1';
   tem2=seqa(nf+ra+1,1,ny-nf-ra);
   tem2=tem2';
   tem3=seqa(nf+1,1,ra);
   tem3=tem3';
   rowr=tem1~tem2~tem3;

@ Translate the matrices @
   A=A[rowr,.];
   B=B[rowr,.];
   CF=CF[rowr,.];

   if track>0;
      str="the initial step of redkw finds A has: "$+ftos(nf,"%*.*lf",1,0);
      str=str$+" singular values";
      print str;
      print "";
   endif;

endif;   @ loop for case of no zeros @

@ SYSTEM REDUCTION STEPS @

@ Intialize iteration@
it=0;

nnf=1; @ pretend flows were eliminated on prior iteration@

do while (ra<nd) .and nnf>0;

@ The "d(t) equations" of the system are now in the form:

    |  0   0   | |Elam(t)|I(t)|   | Be11 Be12 | |lam(t)|   | Cl(F)|
    |          | |            | = |           | |      | + |      | Ex(t)|I(t)
    | ah21 ah22| |Ek(t)  |I(t)|   | Be21 Be22 | |k(t)  |   | Ck(F)|

  where lam(t) are the non-predetermined d(t) and k(t) are predetermined.
  Notice that this suggests that there are "candidate flows",
  i.e., elements of d(t) attached to behavioral equations that contain
  no leads.  We want to solve for as many of these as possible.

  Get the first nd-max(ra,npd) rows and nd-np columns of the Be matrix, Be11
  rows reorganized.  We take max(ra,npd) since we don't want
  an inconsistent equation system.@

   tem1=zeros(2,1);
   tem1[1,1]=ra;
   tem1[2,1]=npd;
   ncf=nd-maxc(tem1);
   b1lam=B[nf+1:nf+ncf,nf+1:ny-npd];

@ The QR factorization is used here. Matrix b is what we
are going to decompose. (This b is not the same as 'b' used earlier,
but rather is a subcomponent of it as explained later.)
We compute the "QR" factorization of this matrix, i.e., we find matrices
  Q,R, and P such that b P = QR.  Q is unitary, P is a permutation
  matrix and R is upper triangular.  (If the rank of row b is less than full
  then the last rows of R are zero).

  Hence, if we want to solve the system of equations b x = k, we can do so
  as follows: k = bx <=> k = b P (P'x) <=> Q'k = R (P'x).  Thus, if we are
  willing to reorder the x's (using X=P'x), we can solve for a subset--call
  it x1--as a function of the others: R11 x1 + R12 x2 = k1 =>
  x1 = inv(R11)*{k1-R12*x2}.  In this expression, we have used only the parts
  of the system for which the transformed equations are non-zero.  As a
  consistency check, we also need to verify that the elements k2 =0. @

@ We are now looking at a system of equations of the form
0=b1 * d(t) + c1(F)Ex(t|t), where the 1 denotes that this
is the subsystem associated with candidate flows, i.e.
variables to be moved out of the nonpredetermined part
of d(t) into f(t).  Partitioning the above equation
further, we have that 0=b1lam*lam(t)+b1k*k(t)+c1(F)Ex(t|t)
If there are ncf equations, frequently only nnf of 
these are linearly independent, so we can only solve
for nnf variables.  The consistency check discussed
above involves making sure that the "remaining" equations
(after we have used up nnf components of b1lam) do not
involve equations such as 0*lam(t)+b1k*k(t)+c1(F)Ex(t|t)
This involves two ideas.  We must decide whether the 
coefficient on lam(t) is really zero. If it is and the
consistency condition is violated, we report whether
it is violated for k(t) or x(t). @

   {Q,R,E}=qqre(b1lam);

@ Translation #3: @

   reords=reord[1,nf+1:ny-npd];  @ locations of lam(t) @

   if nf>0;
      reord=reord[1:nf]~reords[1,E']~reord[ny-npd+1:ny];
      tem1=seqa(1,1,nf);
      tem1=tem1';
   else;
      reord=reords[1,E']~reord[ny-npd+1:ny];
   endif;

   tem2=E+nf;
   tem2=tem2';
   tem3=seqa(ny-npd+1,1,npd);
   tem3=tem3';
   if nf>0;
      reordl=tem1~tem2~tem3;
   else;
      reordl=tem2~tem3;
   endif;

   A=A[.,reordl];
   B=B[.,reordl];

@ This reordering implies that the ncf=nd-max(ra,npd) candidate flows
are ordered first in the d(t). @

@ Translation 4:
multiply the ncf equations of the "candidate flows" by Q' @

   B[nf+1:nf+ncf,nf+1:ny]=Q'*B[nf+1:nf+ncf,nf+1:ny];
   
   CF[nf+1:nf+ncf,.]=mconv(Q',CF[nf+1:nf+ncf,.],0,nlead);

@ Solving for the candidate flows.

We determine how many linearly independent rows of the equations there are
by finding the total number of elements in each row that are close to zero;
computing the number of rows with all zeros and subtracting from the number
of rows. @

   Rd=abs(diag(R[.,1:rows(R)]));  
   tol = rows(b1lam) * Rd[1,1] * tolp;
   nnf = sumc(Rd .> tol);

   @ old Watson version of above @
   @ nnf=abs(R).<0.00001;
   nnf=sumc(nnf');
   nnf=nnf./cols(R);
   nnf=sumc(nnf.==1);
   nnf=rows(R)-nnf; @

   if nnf>0;
@ We check the elements of the linear system if nnf < ncf @
      if nnf<ncf;
         qx=maxc(maxc(abs(CF[nf+nnf+1:nf+ncf,.])));
         if qx>tolp;
            print "The redkw program--system reduction--has encountered";
            print "major problems with flow equations and exogenous variables";
            print "This can arise for either of two reasons. First, you";
            print "may have a well-specified model containing an equation";
            print "of the form:  0=sm*lamj(t)+c1(F)*Ex(t|t),";
            print "where lamj(t) is nonpredetermined and sm is sufficiently small";
            print "that elements of c1(F)/sm falls above the tolp value, which is" tolp;
            print "To explore this run the debugkw.m program";
            print "";
            print "The other possibility is that your model is not";
            print "well-specified, since KW prove that a model for which";
            print "any solution exists cannot fail in this way.";
            print "To see an example of how this can fail, look at";
            print "crash examples on the replication diskette";
            print "";
            print "Program should terminate";
            stop;
         endif;

         qp=maxc(maxc(abs(B[ny-npd+1:ny,.])));
         if qp>tolp;
            print "The redkw program--system reduction--has encountered";
            print "major problems with flow equations and exogenous variables";
            print "This can arise for either of two reasons. First, you";
            print "may have a well-specified model containing an equation";
            print "of the form:  0=sm*lamj(t)+bkj*k(t),";
            print "where lamj(t) is nonpredetermined and sm is sufficiently small";
            print "that elements of bkj/sm falls above the tolp value, which is" tolp;
            print "To explore this run the debugkw.m program";
            print "";
            print "The other possibility is that your model is not";
            print "well-specified, since KW prove that a model for which";
            print "any solution exists cannot fail in this way.";
            print "To see an example of how this can fail, look at";
            print "crash examples on the replication diskette";
            print "";
            print "Program should terminate";
            stop;
         endif;
      endif; @ end of ncf<nnf loop @

@ new number of flows: nf+nnf@
      nf=nf+nnf;
      nd=ny-nf;

@ undertake classical system reduction@
      {A,B,CF}=csr(A,B,CF,nf,nnf,nlead, &mconv);
      
      nlead=nlead+1;
      it=it+1;

      if (track>0);
         print "";
         print "After iteration # " it;
         print "Number of original variables (ny) = " ny;
         print "Number of flow    variables (nf) = " nf;
         print "Number of dynamic variables (nd) = " nd;
      endif;

@ USE THE SVD TO COMPUTE RANK AND PREPARE FOR NEXT ITERATION @

      Al=A[nf+1:ny,nf+1:ny];
      Be=B[nf+1:ny,nf+1:ny];
print " i am at line 468 and about to do svd ";
      {U,S,V}=svd1(Al);
/*       print Al;
      print U;
      print;
      print S;
      print ;
      print V;
      print;  */
      Sd=diag(S);
      tol = cols(Al)*Sd[1,1]*tolp;
      ra = sumc(Sd .> tol);
@       print ra; @

      if ra<ny-nf;  @additional reduction steps must be undertaken @

         UP=U';

         A[nf+1:ny,nf+1:ny]=UP*A[nf+1:ny,nf+1:ny];
         B[nf+1:ny,nf+1:ny]=UP*B[nf+1:ny,nf+1:ny];

         CF[nf+1:ny,.]=mconv(UP,CF[nf+1:ny,.],0,nlead);
         tem1=seqa(1,1,nf);
         tem1=tem1';
         tem2=seqa(nf+ra+1,1,ny-nf-ra);
         tem2=tem2';
         tem3=seqa(nf+1,1,ra);
         tem3=tem3';
         rowr=tem1~tem2~tem3;

         if rowr[1,1]>0;
            A=A[rowr,.];
            B=B[rowr,.];
            CF=CF[rowr,.];
         endif;
/*          print A;
         print;
         print B;
         print;
         print CF;
         print; */

      endif;

   else;  @ if nnf=0 @
      print "";
      print "There are no new flows that can be isolated";
      print "(nnf=0) and the matrix A is singular.";
      print "The system cannot be reduced.";
      print "";
      print "Run the debugkw.m program";
      print "Also see crash examples";
      print "";
      print "The matrx b1lam is:";
      print b1lam;
      print "";
      print "Program should terminate";
      stop;
      print "";
   endif;  @end of nnf>0 loop @

endo; @ end of iterative do loop @

@ OUTPUT OF REDUCED SYSTEM @

if ra<ny-nf;
   print "dynamic system contains irreducible singularity in A";
   print "Program will end";
   stop;
else;
   
@ Put the system in "standard form", by inverting "A1"

  | 0  0  | |Ef(t+1|t)|   | I     K | |f(t)|    |PSIf~(F)|
  |       | |         | = |          ||    | +  |        |  Ex(t|t)    
  | 0  I  | |Ed(t+1|t)|   | 0     W  ||d(t)|    |PSId~(F)| 
@


   B[nf+1:ny,nf+1:ny]=B[nf+1:ny,nf+1:ny]/A[nf+1:ny,nf+1:ny];
   IA=inv(A[nf+1:ny,nf+1:ny]);
   A[nf+1:ny,nf+1:ny]=IA*A[nf+1:ny,nf+1:ny];
   CF[nf+1:ny,.]=mconv(IA,CF[nf+1:ny,.],0,nlead);
endif;

if track>0;
   output on;
   print "";
   print "system reduction completed";
   print " ";
   output off;
endif;

nd=ny-nf;
retp(nd,nf,A,B,reord,CF);
endp;
