proc rowrot(A,c,s);
   local tau1, tau2;

/* This function implements the "row rotation"
algorithm 5.1.6 in Golub and Van Loan, page 203.
It exploits the fact that there is a 2 x 2 matrix
which is affected by the Givens rotation, so 
as to minimize the number of required operations.
Notation matches Golub and Van Loan */

tau1=A[1,.];
tau2=A[2,.];

A[1,.]=c'*tau1 - s*tau2;
A[2,.]=s'*tau1 + c*tau2;   @ Transposes and conjugates @

retp(A);
endp;
