proc(2)=schurl(W);
   local T, Q, i, Q1;

/* This procedure produces the 
Schur decomposition of the matrix W
That is  Q'*W*Q=T

Where T is LOWER triangular  (Note lower and not upper)
and the diagonal entries of T are the ordered
eigenvalues of  W with T[i,i] >= T[j,j], for i < j. */

if rows(W) == 1;
   T=W;
   Q=1;
else;

/* Step 1:  Find Real Schur Decomposition
Uses Gauss schur command, which is not the desired
schur decomposition - see Gauss help for details */

{ T,Q }=schur(W);

/* Step 2:  Convert to Strictly Upper Triangular, possibly Complex Form
using Gauss schtoc command - see Gauss help for details */

{ T,Q }=schtoc(T,Q);

/* Step 3:  Order Diagonal Elements of T
from Smallest to Largest  */

i=2;

do while i <= rows(T);
   if abs(T[i-1,i-1]) > abs(T[i,i]);
      { T,Q }=tqswitch(T,Q,i-1);
      if i > 2; i=i-2; endif;
   endif;
   i=i+1;
endo;

@ Step 4:  Reorder Elements So that T is Upper Triangular @
Q1=Q;
i=1;

do while i <= cols(Q);
   Q[.,i]=Q1[.,cols(Q1)+1-i];
   i=i+1; 
endo;

T=rev(rev(T)')';

endif;

Q=Q';
retp(Q,T);
endp;

