Proc(2)=tqswitch(T,Q,k);
   local n, c, s;

/* This function switches the k'th and (k+1)'th
diagonal elements of T.  It keeps q orthonormal and Q'W*Q=T, 
with T upper triangular. The method used is based on
is algorithm 7.6.1 in Golub and Van Loan, page 386 */

n=cols(T);

{ c,s } = givens(T[k,k+1],T[k+1,k+1]-T[k,k]);

T[k:k+1,k:n]=rowrot(T[k:k+1,k:n],c,s);

T[1:k+1,k:k+1]=colrot(T[1:k+1,k:k+1],c,s);

Q[1:n,k:k+1]=colrot(Q[1:n,k:k+1],c,s);

retp(T,Q);
endp;
