function [covmat] = frac_cov(t,d)

% Compute Covariance Matrix of fractional model with parameter d 
%   Note d must be between -0.5 and 1.5
%   If d > 0.5 then this computes variance of integrated stationary model 
%

if d < -0.5;
   error('d must be > -0.5');
end;
if d > 1.5;
   error('d must be < 1.5');
end;

dsave = d;
if dsave > 0.50;
 d=d-1;
end;

if abs(d) < 0.000001;
 covmat=eye(t);
else;
  if (0.5-d) < .0001;
    d=0.4999;
  end;
  if (d+0.5) < .0001;
    d=-0.4999;
  end;
  %  Compute autocorrelations 
  acv=zeros(t,1);
  acv(1)=1;
  if d > 0;
    gamd=gamma(d);
  else;
    gamd=gamma(1+d)/d;
  end;
  gam_md=gamma(1-d);
  fac=gam_md/gamd;
  t1=min([100;t-1]);
  h = (1:t1)';
  ghd=gamma(h+d);
  ghmd=gamma(h-d+1);
  acv(2:t1+1) = (ghd./ghmd)*fac;
  if t1+1 < t;
   hvec = (t1+1:1:t-1)';
   anum = app_log_gamma(d+hvec);
   aden = app_log_gamma(hvec-d+1);
   acv(t1+2:t) = fac*(exp(anum-aden));
   % acv(t1+2:t)=fac*(hvec.^(2*d-1));  
  end;
  covmat = acv2cov(acv);
  % Compute Variance to get correct scale -- this is useful in h_cov_ha_frac where the scale is important @
  var_scl=gamma(1-2*d)/(gamma(1-d))^2;
  covmat=covmat*var_scl;
end;

if dsave > 0.50;
  % Construct summation matrix  
  sum_mat = tril(ones(t,t));
  covmat=sum_mat*covmat*sum_mat';
end;
 
end

