% wc15_b.m
% bivariate analysis
% September 3, 2015
%
clear all;
small = 1.0e-10;
rng(9797696);

% -- File Directories   
outdir = '/Users/mwatson/Dropbox/wc15/ddisk/matlab/out/';
figdir = '/Users/mwatson/Dropbox/wc15/ddisk/matlab/fig/';
matdir = '/Users/mwatson/Dropbox/wc15/ddisk/matlab/mat/';

load_data = 1;
wc15_data_calendar;

% Set up variables to study
Xstr = 'dtfp';
Ystr = 'dln_gdp';
nper = 4;
sfirst = [1947 2];  % First obs to use (truncated if later)
slast = [2015 2];   % Last Obs to use (truncated if earlier)

q = 12;

outfile_name = [outdir 'wc15_b_' Xstr '_' Ystr '.out'];
fid_out = fopen(outfile_name,'w');


eval(['X_raw = ' Xstr ';']);
eval(['Y_raw = ' Ystr ';']);

% Save series over desired sample period
tmp = packr([calvec X_raw Y_raw]);
calvec = tmp(:,1);
X_raw = tmp(:,2);
Y_raw = tmp(:,3);
ismpl = smpl(calvec,sfirst,slast,nper);
calvec = calvec(ismpl==1);
dnobs = size(calvec,1);
X_raw = X_raw(ismpl==1);
Y_raw = Y_raw(ismpl==1);

% --- Step 2: Compute Cosine Transforms and some summary statistics
  % Some Summary Statistics 
    [X_mean,X_cos] = xp_compute(X_raw,q);
    X_var_lr = dnobs*mean(X_cos.^2);
    X_norm = X_cos/sqrt(X_cos'*X_cos); 
    psi = psi_compute(dnobs,q);
    X_proj = psi*(inv(psi'*psi))*X_cos;
    X_proj_m = X_proj + X_mean;
    
    % Some Summary Statistics 
    [Y_mean,Y_cos] = xp_compute(Y_raw,q);
    Y_var_lr = dnobs*mean(Y_cos.^2);
    Y_norm = Y_cos/sqrt(Y_cos'*Y_cos);
    psi = psi_compute(dnobs,q);
    Y_proj = psi*(inv(psi'*psi))*Y_cos;
    Y_proj_m = Y_proj + Y_mean;
    

 %  Figure 2
    plot(calvec,Y_raw,'-b','LineWidth',1.0);
    hold on;
     plot(calvec,X_raw,'--r','LineWidth',1.0);
     plot(calvec,Y_proj_m,'-k','LineWidth',5);
     plot(calvec,X_proj_m,'--r','LineWidth',5);
    hold off;
    legend('GDP','TFP','GDP Low Frequency Projection','TFP Low Frequency Projection');
    legend('Location','NorthEast');
    xlabel('Date'); 
    ax = gca;
    ax.FontSize = 30;
    set(gcf,'PaperUnits','centimeters','PaperPosition',[0 0 25 25]);
    save_g_str = [figdir 'fig_2.png'];
    print('-dpng',save_g_str, '-r300');  
    
 % Plot Cosine Transforms
    ct_vec = [1:1:q]';
    plot(ct_vec,Y_cos,'ob','MarkerSize',30,'LineWidth',10);
    hold on;
       plot(ct_vec,X_cos,'+r','MarkerSize',30,'LineWidth',10);
    hold off;
    legend('GDP','TFP');
    legend('Location','NorthEast');
    xlabel('Cosine Transform'); 
    %ylim([-1 1]);
    ax = gca;
    ax.FontSize = 30;
    set(gcf,'PaperUnits','centimeters','PaperPosition',[0 0 25 25]);
    save_g_str = [figdir 'fig_8.png'];
    print('-dpng',save_g_str, '-r300');
     
    
    Z = [X_cos Y_cos];
    m = [X_mean Y_mean]';
    covmat = dnobs*Z'*Z/q;
    mvar = covmat/dnobs;
    ht2_fac = (q+1-2)/(2*q);
    F_num_df = 2;
    F_den_df = q+1-2;
    c_95 = finv(0.95,F_num_df,F_den_df);
    c_67 = finv(0.67,F_num_df,F_den_df);
    V = inv(mvar);
    V = ht2_fac*V;
    [x95 y95] = ellipse_yx(m,V,c_95);
    [x67 y67] = ellipse_yx(m,V,c_67);
    
    % Example of Code to plot the ellipse
    plot(x67(:,1),y67(:,1),'-k','LineWidth',3);
    hold on;
      plot(x67(:,2),y67(:,2),'-k','LineWidth',3);
      plot(x95(:,1),y95(:,1),'--k','LineWidth',3);
      plot(x95(:,2),y95(:,2),'--k','LineWidth',3);
      plot(m(1),m(2),'+b','MarkerSize',20,'LineWidth',4);
    hold off;
    ax = gca;
    ax.FontSize = 30;
    xlabel('TFP'); 
    ylabel('GDP');
    ax.XLim = [0.0 2.5];
    ax_YLim = [0.0 3.5];
    set(gcf,'PaperUnits','centimeters','PaperPosition',[0 0 25 25]);
    save_g_str = [figdir 'fig_7.png'];
    print('-dpng',save_g_str, '-r300');
    
    
    % Sample Correlation
    cor_I0 = (Y_cos'*X_cos)/sqrt((X_cos'*X_cos)*(Y_cos'*Y_cos));
    
    % -- Some Graphs and Output 
     fprintf(fid_out,[' Date and Time: ' datestr(now) '\n']); 
     fprintf(fid_out,'   First obs = %6.2f\n',calvec(1));
     fprintf(fid_out,'   Last obs = %6.2f\n',calvec(end));
     fprintf(fid_out,'   Number of Obs %4.0f\n',dnobs);
     fprintf(fid_out,'   Number of Years %4.1f\n',dnobs/nper);
     fprintf(fid_out,'   Number of Cosine Transformations %4d\n',q);
     fprintf(fid_out,'   Cutoff periodicity (in years) = %4.1f\n',(2*dnobs/q)/nper);
     fprintf(fid_out,'       X Series: \n');
     fprintf(fid_out,['        Series name: ' Xstr '\n']);
     fprintf(fid_out,'         Sample Mean = %6.2f\n',X_mean);
     fprintf(fid_out,'         Sample Std. Dev. = %6.2f\n',std(X_raw));
     fprintf(fid_out,'         LR SD (Low-Freq I(0)) = %6.2f\n',sqrt(X_var_lr));
     fprintf(fid_out,'       Y Series: \n');
     fprintf(fid_out,['        Series name: ' Ystr '\n']);
     fprintf(fid_out,'         Sample Mean = %6.2f\n',Y_mean);
     fprintf(fid_out,'         Sample Std. Dev. = %6.2f\n',std(Y_raw));
     fprintf(fid_out,'         LR SD (Low-Freq I(0)) = %6.2f\n',sqrt(Y_var_lr));
     fprintf(fid_out,'       Sample Correlations: \n');
     fprintf(fid_out,'         I(0) weighted: %6.2f\n',cor_I0);  
%     
%   % Compute Regression Coefficient, etc.
  bhat = X_cos\Y_cos;
  xxi = 1/(X_cos'*X_cos);
  Yhat_cos = X_cos*bhat;
  U_cos = Y_cos-Yhat_cos;
  ssr = U_cos'*U_cos;
  tss = Y_cos'*Y_cos;
  rss = Yhat_cos'*Yhat_cos;
  s2_u = ssr/(q-1);
  se_bhat = sqrt(s2_u*xxi);
  r2 = 1-ssr/tss;
  tcv = tinv(0.95,q-1);
  fprintf(fid_out,'       Regression of GDP onto TFP: \n');
  fprintf(fid_out,'          BetaHat: %6.2f ',bhat);
  fprintf(fid_out,' (%5.2f) \n',se_bhat);
  fprintf(fid_out,'            tstat for BetaHat: %6.2f \n',bhat/se_bhat);
  fprintf(fid_out,'       90 Percent CI for Beta: %6.2f ',bhat-(se_bhat*tcv));
  fprintf(fid_out,' to %6.2f \n',bhat+(se_bhat*tcv)); 
  fprintf(fid_out,'          SER: %6.2f \n',sqrt(s2_u));
  fprintf(fid_out,'          R^2: %6.2f \n',r2);
 
  
  % Construct confidence set for correlation
  cor_size = .100;
  pctl = cor_size/2;
  pctu = 1-pctl;
  nrep = 50000;
  e1 = randn(q,nrep);
  e2 = randn(q,nrep);
  a11 = sum(e1.^2)';
  a22 = sum(e2.^2)';
  a12 = sum(e1.*e2)';
  ngrid = 501;
  rho_grid = linspace(-1,1,ngrid)';
  pctl_vec = NaN(ngrid,1);
  pctu_vec = NaN(ngrid,1);
  syy = a11;
  for i = 1:ngrid;
      rho = rho_grid(i);
      tmp = sqrt(1-rho*rho);
      syx = rho*a11+tmp*a12;
      sxx = rho*rho*a11 + tmp*tmp*a22 + 2*rho*tmp*a12;
      rhat = syx./sqrt(sxx.*syy);
      pct = pctile(rhat,[pctl;pctu]);
      pctl_vec(i) = pct(1);
      pctu_vec(i) = pct(2);
  end;
  tmp = (pctl_vec < cor_I0).*(pctu_vec > cor_I0);
  cor_cset = rho_grid(tmp==1);
  cor_ci_lower = min(cor_cset);
  cor_ci_upper = max(cor_cset);
  fprintf(fid_out,'       90 Percent CI for correlation: %6.2f ',cor_ci_lower);
  fprintf(fid_out,' to %6.2f \n',cor_ci_upper);
  fprintf(fid_out,'       90 Percent CI for R^2: %6.2f ',cor_ci_lower^2);
  fprintf(fid_out,' to %6.2f \n',cor_ci_upper^2);
  
  
 % Plot Projections onto Cosine
    ytmp = Y_proj + Y_mean;
    yx_proj = bhat*X_proj;
    yx_tmp = yx_proj + Y_mean;
    plot(calvec,ytmp,'-k','LineWidth',5);
    hold on;
     plot(calvec,yx_tmp,'--r','LineWidth',5);
    hold off;
%     legend('GDP','TFP','GDP Low Frequency Projection','Fitted Value from');
%     legend('Location','NorthEast');
    xlabel('Date'); 
    ax = gca;
    ax.FontSize = 30;
    xp = 1960;
    yp = 0;
    text(1970,1.5,'$$\hat{y}$$','Interpreter','Latex')
    text(2010,1.0,'$$\hat{\alpha}+\hat{\beta}\hat{z}$$','Interpreter','Latex')
    set(gcf,'PaperUnits','centimeters','PaperPosition',[0 0 25 25]);
    save_g_str = [figdir 'fig_9.png'];
    print('-dpng',save_g_str, '-r300');
    
    type(outfile_name);
  
      

    



