% wc15_u
% mww, 9/2/2015
% Compute all univariate statistics
% 
clear all;
small = 1.0e-10;

% -- File Directories   
outdir = '/Users/mwatson/Dropbox/wc15/ddisk/matlab/out/';
figdir = '/Users/mwatson/Dropbox/wc15/ddisk/matlab/fig/';
matdir = '/Users/mwatson/Dropbox/wc15/ddisk/matlab/mat/';
rng(9797696);

load_data = 1;
wc15_data_calendar;

%Xstr = 'dln_gdp';
Xstr = 'dln_p';
nper = 4;
sfirst = [1947 2];  % First obs to use (truncated if later)
slast = [2015 2];   % Last Obs to use (truncated if earlier)

q = 12;

str_label = [];  % Label for Output and so forth
outfile_name = [outdir 'wc15_univariate_' Xstr '.out'];
fid_out = fopen(outfile_name,'w');

eval(['X_raw = ' Xstr ';']);

% Save series over desired sample period
tmp = packr([calvec X_raw]);
calvec = tmp(:,1);
X_raw = tmp(:,2);
ismpl = smpl(calvec,sfirst,slast,nper);
calvec = calvec(ismpl==1);
dnobs = size(calvec,1);
X_raw = X_raw(ismpl==1);

% --- Step 2: Compute Cosine Transforms and some summary statistics
% Some Summary Statistics 
  [X_mean,X_cos] = xp_compute(X_raw,q);
  X_var_lr = dnobs*mean(X_cos.^2);
  X_norm = X_cos/sqrt(X_cos'*X_cos); 
  psi = psi_compute(dnobs,q);
  X_proj = psi*(inv(psi'*psi))*X_cos;
  X_proj_m = X_proj + X_mean;
  
  % Confidence interval for var_lr
  chi_l = chi2inv(.05,q);
  chi_u = chi2inv(.95,q);
  sig_l = sqrt(X_var_lr*q/chi_u);
  sig_u = sqrt(X_var_lr*q/chi_l);
  

  m_t_lower = X_mean + sqrt(X_var_lr/dnobs)*tinv(0.05,q);
  m_t_upper = X_mean + sqrt(X_var_lr/dnobs)*tinv(0.95,q);

% -- Some Summary Statistics 
     fprintf(fid_out,[' Date and Time: ' datestr(now) '\n']); 
     fprintf(fid_out,'   First obs = %6.2f\n',calvec(1));
     fprintf(fid_out,'   Last obs = %6.2f\n',calvec(end));
     fprintf(fid_out,'   Number of Obs %4.0f\n',dnobs);
     fprintf(fid_out,'   Number of Years %4.1f\n',dnobs/nper);
     fprintf(fid_out,'   Number of Cosine Transformations %4d\n',q);
     fprintf(fid_out,'   Cutoff periodicity (in years) = %4.1f\n',(2*dnobs/q)/nper);
     fprintf(fid_out,'       X Series: \n');
     fprintf(fid_out,['        Series name: ' Xstr '\n']);
     fprintf(fid_out,'         Sample Mean = %6.2f\n',X_mean);
     fprintf(fid_out,'         Sample Std. Dev. = %6.2f\n',std(X_raw));
     fprintf(fid_out,'         LR SD (Low-Freq I(0)) = %6.2f\n',sqrt(X_var_lr)); 
     fprintf(fid_out,'         90 Percent CI for sigma (chi-2 dist): (%6.2f, %6.2f) \n',[sig_l sig_u]); 
     fprintf(fid_out,'         90 Percent CI for Mean LR- t distribution: (%6.2f, %6.2f) \n',[m_t_lower m_t_upper]);
     
% LFST and LFUR Tests
  [lfst,lfst_pvalue] = lfst_pv(X_norm,10);
  [lfur,lfur_pvalue] = lfur_pv(X_norm,10);
  fprintf(fid_out,'         LFST Pvalue: %6.2f \n',lfst_pvalue);
  fprintf(fid_out,'         LFUR Pvalue: %6.2f \n',lfur_pvalue);

% Confidence Set for d
  % Compute I(d) likelihood for scale invariant 
  dvec = (-0.49:.01:1.49)';
  lvec = NaN(size(dvec,1),1);
  Sigma_d_mat = NaN(q,q,size(dvec,1));
  Sigma_inv_d_mat = NaN(q,q,size(dvec,1));
  for i = 1:size(dvec,1);
   d = dvec(i);
   [Sigma,ier] = Sigma_Compute(0,0,d,q,0);
   sig_inv = inv(Sigma);
   lvec(i) = den_invariant(X_norm,sig_inv);
   Sigma_d_mat(:,:,i) = Sigma;
   Sigma_inv_d_mat(:,:,i) = sig_inv;
  end;
  % compute LR with uniform prior 
  lr_stat = mean(lvec)./lvec;
  % Compute critical values for each value of d
  pct_vec = [2/3 0.90 0.95]';
  lr_d_cv = NaN(size(dvec,1),size(pct_vec,1));
  nsim = 50000;
  Ysim = randn(q,nsim);
  for i = 1:size(dvec,1);
     sig_ho = Sigma_d_mat(:,:,i);
     chol_ho = chol(sig_ho);
     Xsim = chol_ho*Ysim;
     tmp = sqrt(sum(Xsim.^2));
     Xsim_norm = Xsim./repmat(tmp,q,1);
     lvec_sim = NaN(size(dvec,1),nsim);
     for j = 1:size(dvec,1);
         sig_inv = Sigma_inv_d_mat(:,:,j);
         lvec_sim(j,:) = den_invariant(Xsim_norm,sig_inv);
     end;
     lr_stat_ho = mean(lvec_sim)./lvec_sim(i,:);
     tmp = pctile(lr_stat_ho',pct_vec);
     lr_d_cv(i,:) = tmp';
  end;
  [tmp,ii]=max(lvec);
  fprintf(fid_out,'         MLE (from grid) for d: %6.2f \n',dvec(ii));
  cond_mat = repmat(lr_stat,1,size(lr_d_cv,2)) < lr_d_cv;
  fprintf(fid_out,'         Confidence Set for d: \n');
  for i = 1: size(pct_vec,1);
     tmp = dvec(cond_mat(:,i)==1);
     fprintf(fid_out,'            Level = %6.2f:  (%6.2f, %6.2f) \n',[pct_vec(i) tmp(1) tmp(end)]);
  end;
     
% Band pass values
[ xbp, sebp ] = bpassar(X_raw,(2*dnobs/q),1.0E+32,floor(dnobs/2),4,0,0);     

% Figure 1: Data and Trends
    plot(calvec,X_raw,'-k','LineWidth',1);
    hold on;
     plot(calvec,xbp,'-k','LineWidth',4);
     plot(calvec,X_proj_m,'--b','LineWidth',4);
    hold off;
    legend('GDP Growth Rate','Low Frequency Band Pass','Low Frequency Cosine Projection');
    %legend('Inflation Rate','Low Frequency Band Pass','Low Frequency Cosine Projection');
    legend('Location','NorthEast');
    xlabel('Date'); 
    ax = gca;
    ax.FontSize = 30;
    set(gcf,'PaperUnits','centimeters','PaperPosition',[0 0 25 25]);
    save_g_str = [figdir Xstr '_fig_1.png'];
    print('-dpng',save_g_str, '-r300');  
   
    
 % Figure 3: Cosine Transforms
    ct_vec = [1:1:q]';
    plot(ct_vec,X_cos,'ob','MarkerSize',30,'LineWidth',10);
    xlabel('Cosine Transform'); 
    %ylim([-1 1]);
    ax = gca;
    %ax.Xlim = [0 12];
    ax.FontSize = 30;
    set(gcf,'PaperUnits','centimeters','PaperPosition',[0 0 25 25]);
    save_g_str = [figdir Xstr '_fig_3.png'];
    print('-dpng',save_g_str, '-r300');  
 
%  Figure 4: low-frequency log-likelihood as a function of sigma
  tmp1 = sqrt(chi2inv(0.01,q)/q);
  tmp2 = sqrt(chi2inv(0.99,q)/q);
  ngrid = 500;
  tmp = linspace(tmp1,tmp2,ngrid)';
  sig_grid = sqrt(X_var_lr)*tmp;
  var_grid = sig_grid.^2;
  sig_mle = sqrt(X_var_lr);
  ssr = dnobs*sum(X_cos.^2);
  log_llf = -(q/2)*log(var_grid) - 0.5*ssr./var_grid;
  log_max = -(q/2)*log(X_var_lr) - 0.5*ssr./X_var_lr;
  log_llf_norm = log_llf - log_max*ones(ngrid,1);
  plot(sig_grid,log_llf_norm,'-b','LineWidth',4);
  xlabel('{\omega}'); 
  ylabel('Log Likelihood');
  %ylim([-1 1]);
  ax = gca;
  ax.FontSize = 30;
%   ax.YLim = [-4 0];
%   ax.XLim = [3 7];
  set(gcf,'PaperUnits','centimeters','PaperPosition',[0 0 25 25]);
  save_g_str = [figdir Xstr '_fig_4.png'];
  print('-dpng',save_g_str, '-r300'); 
  
  % Figure 5: I(d) log-likelihood
  [tmp,ii] = min(abs(dvec-0));
  lvec = lvec/lvec(ii);
  ln_lvec = log(lvec);
  plot(dvec,ln_lvec,'-b','LineWidth',4);
  xlabel('d');
  ylabel('Log Likelihood');
  ax = gca;
  ax.FontSize = 30;
  %ax.YLim = [-14 2];
  % ax.YLim =[-5 4];
  %ax.XLim = [-0.5 1.5];
  set(gcf,'PaperUnits','centimeters','PaperPosition',[0 0 25 25]);
  save_g_str = [figdir Xstr '_fig_5.png'];
  print('-dpng',save_g_str, '-r300');  

  
 % Figure 6 Calculations
 % Compute phi normalized to be orthonormal
 psi = psi_compute(dnobs,q);
 tmp = mean(sqrt(diag(psi'*psi)));
 psi = psi/tmp;
 X_cos = psi'*X_raw;
 X_sd_lr = sqrt(X_var_lr);
 mgrid = (.005:.005:.995);
 mgrid = [mgrid 1 1./fliplr(mgrid)];
 ngrid = size(mgrid,2);
 X_sd_lr_grid = X_sd_lr*mgrid;
 X_cos_grid = repmat(X_cos,1,ngrid)./repmat(X_sd_lr_grid,q,1);
 
 % Read in LFD 
 % --- LFDs and WAP factors for "exp" ... 
 str_lfd_lrd = 'lamsfin';
 str_test = [str_lfd_lrd '_33'];
 str_tmp = [matdir str_test]; load(str_tmp,'lams');
 dvec = lams(1,2:end)';
 rvec = lams(2:end,1);
 lfd_mat_33 = lams(2:end,2:end);
 nr = size(rvec,1);
 nd = size(dvec,1);
 str_test = [str_lfd_lrd '_10'];
 str_tmp = [matdir str_test]; load(str_tmp,'lams');
 lfd_mat_10 = lams(2:end,2:end);
 str_test = [str_lfd_lrd '_5'];
 str_tmp = [matdir str_test]; load(str_tmp,'lams');
 lfd_mat_05 = lams(2:end,2:end);
 % Weight factors 
 tmp = (1:1:50)';
 wfac = exp(0.1*tmp);
%  
 % Carry out analysis for each horizon;
 ci_indicator_33 = NaN(ngrid,nr);
 ci_indicator_10 = NaN(ngrid,nr);
 ci_indicator_05 = NaN(ngrid,nr);
 rmax = max(rvec);
 T = 250;
 PSI = psi_compute(T,q);
 tmp = mean(sqrt(diag(PSI'*PSI)));
 PSI = PSI/tmp;
 Tmax = max([T;2*rmax*T]);
 if Tmax > T;
     PSI = [PSI;zeros(Tmax-T,q)];
 end;
 for ih = 1:nr;
     r = rvec(ih);
     scale = 1/sqrt(r*T);
     n = ceil(r*T);
     pm = zeros(Tmax,1);
     pm(1:n) = -1;
     pm(1+n:2*n) = 1;
     pm = pm*scale;
     psi_m = [pm PSI];
     lfho_den = NaN(nd,ngrid);
     lfha_den = zeros(nd,ngrid);  % Use the fact that these will be added .. equal weights
     for i = 1:nd;
         d = dvec(i);
         cov_Id = frac_cov(Tmax,d);
         sigma_m = psi_m'*cov_Id*psi_m;
         sigma_ho = sigma_m(2:end,2:end)/(0.5*sigma_m(1,1));
         sigma_ho_inv = inv(sigma_ho);
         lfho_den(i,:) = den_norm(X_cos_grid,sigma_ho_inv);
         for j = 1:size(wfac,1);
           sigma_ha_inv = sigma_ho_inv*wfac(j);
           tmp = den_norm(X_cos_grid,sigma_ha_inv);
           lfha_den(i,:) = lfha_den(i,:) + tmp;
           sigma_ha_inv = sigma_ho_inv/wfac(j);
           tmp = den_norm(X_cos_grid,sigma_ha_inv);
           lfha_den(i,:) = lfha_den(i,:) + tmp;
         end;
     end;
     lfho_33 = lfd_mat_33(ih,:)*lfho_den/nd;
     lfho_10 = lfd_mat_10(ih,:)*lfho_den/nd;
     lfho_05 = lfd_mat_05(ih,:)*lfho_den/nd; 
     lfha = sum(lfha_den)/(2*size(wfac,1)*nd);
     ci_indicator_33(:,ih) = ((lfha./lfho_33) < 1)';
     ci_indicator_10(:,ih) = ((lfha./lfho_10) < 1)';
     ci_indicator_05(:,ih) = ((lfha./lfho_05) < 1)';
 end;
 % Confidence Sets for STD of Difference
 % Compute Upper and Lower CI for LR variance
 chil = chi2inv(0.33/2,q)/q;
 chiu = chi2inv(1-0.33/2,q)/q;
 X_sd_lr_l33 = sqrt(chil*X_var_lr);
 X_sd_lr_u33 = sqrt(chiu*X_var_lr);
 chil = chi2inv(0.10/2,q)/q;
 chiu = chi2inv(1-0.10/2,q)/q;
 X_sd_lr_l10 = sqrt(chil*X_var_lr);
 X_sd_lr_u10 = sqrt(chiu*X_var_lr);
 chil = chi2inv(0.05/2,q)/q;
 chiu = chi2inv(1-0.05/2,q)/q;
 X_sd_lr_l05 = sqrt(chil*X_var_lr);
 X_sd_lr_u05 = sqrt(chiu*X_var_lr);
 
 
%  fprintf(fid_out,'  Confidence Sets for SD of difference of sample averages \n');
%  fprintf(fid_out,['    LFD used:' str_lfd_lrd]);
%  for ih = 1:nr;
%      r = rvec(ih);
%      h = r*dnobs;
%      fprintf(fid_out,'        Horizon (r and quaters) %6.2f  %4.1f \n',[r h]);
%      fprintf(fid_out,'           I(0): \n');
%      fprintf(fid_out,'             Size = 0.33: (%6.2f - %6.2f)  [%6.2f - %6.2f] \n',[X_sd_lr_l33 X_sd_lr_u33 X_sd_lr_l33/sqrt(h) X_sd_lr_u33/sqrt(h)]);
%      fprintf(fid_out,'             Size = 0.10: (%6.2f - %6.2f)  [%6.2f - %6.2f] \n',[X_sd_lr_l10 X_sd_lr_u10 X_sd_lr_l10/sqrt(h) X_sd_lr_u10/sqrt(h)]);
%      fprintf(fid_out,'             Size = 0.05: (%6.2f - %6.2f)  [%6.2f - %6.2f] \n',[X_sd_lr_l05 X_sd_lr_u05 X_sd_lr_l05/sqrt(h) X_sd_lr_u05/sqrt(h)]);     
%      fprintf(fid_out,'           I(d):  \n');
%      fprintf(fid_out,'              Size = 0.33:  \n');
%      ci_indicator = ci_indicator_33;
%      iclose = 1;
%      for ig = 1:ngrid-1;
%          sd_lr = X_sd_lr_grid(1,ig);
%          ii_0 = ci_indicator(ig,ih);
%          ii_1 = ci_indicator(ig+1,ih);
%          if (ii_0 == 1);
%              if iclose == 1;
%                  iclose = 0;
%                    sd_lr_l = sd_lr;
%                    sds_lr_l = sqrt(2)*sd_lr/sqrt(h);
%              end;
%              if (ii_1 == 0);
%                    sd_lr_u = sd_lr;
%                    sds_lr_u = sqrt(2)*sd_lr/sqrt(h);
%                    fprintf(fid_out,'               (%6.2f - %6.2f)  [%6.2f - %6.2f] \n',[sd_lr_l sd_lr_u sds_lr_l sds_lr_u]);
%                    iclose = 1;
%              end;
%          end;
%      end;
%      sd_lr = X_sd_lr_grid(1,end);
%      ii_0 = ci_indicator(end,ih); 
%      if ii_0 == 1;
%          if iclose == 0;
%              sd_lr_u = sd_lr;
%              sds_lr_u = sqrt(2)*sd_lr/sqrt(h);
%              fprintf(fid_out,'               (%6.2f - %6.2f)  [%6.2f - %6.2f] \n',[sd_lr_l sd_lr_u sds_lr_l sds_lr_u]);
%          else;
%              sd_lr_l = sd_lr;
%              sds_lr_l = sqrt(2)*sd_lr/sqrt(h);
%              sd_lr_u = sd_lr;
%              sds_lr_u = sqrt(2)*sd_lr/sqrt(h);
%              fprintf(fid_out,'               (%6.2f - %6.2f)  [%6.2f - %6.2f] \n',[sd_lr_l sd_lr_u sds_lr_l sds_lr_u]);
%          end;
%      end;
%      
%      fprintf(fid_out,'              Size = 0.10:  \n');
%      ci_indicator = ci_indicator_10;
%      iclose = 1;
%      for ig = 1:ngrid-1;
%          sd_lr = X_sd_lr_grid(1,ig);
%          ii_0 = ci_indicator(ig,ih);
%          ii_1 = ci_indicator(ig+1,ih);
%          if (ii_0 == 1);
%              if iclose == 1;
%                  iclose = 0;
%                    sd_lr_l = sd_lr;
%                    sds_lr_l = sqrt(2)*sd_lr/sqrt(h);
%              end;
%              if (ii_1 == 0);
%                    sd_lr_u = sd_lr;
%                    sds_lr_u = sqrt(2)*sd_lr/sqrt(h);
%                    fprintf(fid_out,'               (%6.2f - %6.2f)  [%6.2f - %6.2f] \n',[sd_lr_l sd_lr_u sds_lr_l sds_lr_u]);
%                    iclose = 1;
%              end;
%          end;
%      end;
%      sd_lr = X_sd_lr_grid(1,end);
%      ii_0 = ci_indicator(end,ih); 
%      if ii_0 == 1;
%          if iclose == 0;
%              sd_lr_u = sd_lr;
%              sds_lr_u = sqrt(2)*sd_lr/sqrt(h);
%              fprintf(fid_out,'               (%6.2f - %6.2f)  [%6.2f - %6.2f] \n',[sd_lr_l sd_lr_u sds_lr_l sds_lr_u]);
%          else;
%              sd_lr_l = sd_lr;
%              sds_lr_l = sqrt(2)*sd_lr/sqrt(h);
%              sd_lr_u = sd_lr;
%              sds_lr_u = sqrt(2)*sd_lr/sqrt(h);
%              fprintf(fid_out,'               (%6.2f - %6.2f)  [%6.2f - %6.2f] \n',[sd_lr_l sd_lr_u sds_lr_l sds_lr_u]);
%          end;
%      end;
%     
%      fprintf(fid_out,'              Size = 0.05:  \n');
%      ci_indicator = ci_indicator_05;
%      iclose = 1;
%      for ig = 1:ngrid-1;
%          sd_lr = X_sd_lr_grid(1,ig);
%          ii_0 = ci_indicator(ig,ih);
%          ii_1 = ci_indicator(ig+1,ih);
%          if (ii_0 == 1);
%              if iclose == 1;
%                  iclose = 0;
%                    sd_lr_l = sd_lr;
%                    sds_lr_l = sqrt(2)*sd_lr/sqrt(h);
%              end;
%              if (ii_1 == 0);
%                    sd_lr_u = sd_lr;
%                    sds_lr_u = sqrt(2)*sd_lr/sqrt(h);
%                    fprintf(fid_out,'               (%6.2f - %6.2f)  [%6.2f - %6.2f] \n',[sd_lr_l sd_lr_u sds_lr_l sds_lr_u]);
%                    iclose = 1;
%              end;
%          end;
%      end;
%      sd_lr = X_sd_lr_grid(1,end);
%      ii_0 = ci_indicator(end,ih); 
%      if ii_0 == 1;
%          if iclose == 0;
%              sd_lr_u = sd_lr;
%              sds_lr_u = sqrt(2)*sd_lr/sqrt(h);
%              fprintf(fid_out,'               (%6.2f - %6.2f)  [%6.2f - %6.2f] \n',[sd_lr_l sd_lr_u sds_lr_l sds_lr_u]);
%          else;
%              sd_lr_l = sd_lr;
%              sds_lr_l = sqrt(2)*sd_lr/sqrt(h);
%              sd_lr_u = sd_lr;
%              sds_lr_u = sqrt(2)*sd_lr/sqrt(h);
%              fprintf(fid_out,'               (%6.2f - %6.2f)  [%6.2f - %6.2f] \n',[sd_lr_l sd_lr_u sds_lr_l sds_lr_u]);
%          end;
%      end;         
%  end;
 
 % Plot CI for I(0) and I(d) model -- Note this assumes that confidence set
 % is an interval
  ci_indicator = ci_indicator_10;
  X_sd_lr_l = X_sd_lr_l10; 
  X_sd_lr_u = X_sd_lr_u10; 
  X_grid = X_sd_lr_grid';
  cid_u = NaN(nr,1);
  cid_l = NaN(nr,1);
  ci0_u = NaN(nr,1);
  ci0_l = NaN(nr,1);
  hvec = rvec*dnobs;
  yvec = hvec/4;
  for ih = 1:nr;
      h = rvec(ih)*dnobs;
      cid_u(ih) = max(X_grid(ci_indicator(:,ih)==1))*sqrt(2/h);
      cid_l(ih) = min(X_grid(ci_indicator(:,ih)==1))*sqrt(2/h);
      ci0_u(ih) = X_sd_lr_u*sqrt(2/h);
      ci0_l(ih) = X_sd_lr_l*sqrt(2/h);
  end;
  plot(yvec,cid_l,'-k','LineWidth',3);
  hold on;
    plot(yvec,cid_u,'-k','LineWidth',3);
    plot(yvec,ci0_l,'--b','LineWidth',3);
    plot(yvec,ci0_u,'--b','LineWidth',3);
  hold off;
  xlabel('Years');
  ax = gca;
  ax.FontSize = 30;
  error('tmp');
  %   ax.XLim = [15 60];
  %   ax.Ylim = [0 15];
  set(gcf,'PaperUnits','centimeters','PaperPosition',[0 0 25 25]);
  save_g_str = [figdir Xstr '_fig_6.png'];
  print('-dpng',save_g_str, '-r300');  

type(outfile_name);
