% Read in Ulrich's large Matlab file and rewrite pieces

clear all;
small = 1.0e-10;

% -- File Directories   
figdir = 'fig/';
outdir = 'out/';
matdir = 'mat/';
mcmcdir = 'mcmc/';

% Model Name -- Run for each model below
mod_name = '_baseline';    % Baseline model
% mod_name = '_fgamma05';
% mod_name = '_fgamma15';
% mod_name = '_q_9';
% mod_name = '_q_23';
% mod_name = '_T68';
% mod_name = '_empdata';    % Y/L 

umdir = ['/Users/mwatson/Dropbox/Shared_Folders/SCC/output_matlab/ndata/'];  % Location of Mueller's MCMC draws
fstr = [umdir 'postdraws' mod_name]; load(fstr);

% % Save Individual Elements
F_draws = F; clear F;
fstr = [mcmcdir 'F_draws' mod_name];save(fstr,'F_draws');
fstr = [mcmcdir 'g_matrix' mod_name];save(fstr,'g_matrix');
%
m_draws = m_of_f; clear m_of_f;
fstr = [mcmcdir 'm_draws' mod_name];save(fstr,'m_draws');
% 
sigma2_F_draws = sigma2_F; clear sigma2_F;
fstr = [mcmcdir 'sigma2_F_draws' mod_name];save(fstr,'sigma2_F_draws');
% 
F_rho_draws = frho; clear frho;
fstr = [mcmcdir 'F_rho_draws' mod_name];save(fstr,'F_rho_draws');
% 
mu_U_draws = muU; clear muU;
fstr = [mcmcdir 'mu_U_draws' mod_name];save(fstr,'mu_U_draws');
%
mtau_F_draws = mtau_F; clear mtau_F;
fstr = [mcmcdir 'mtau_F_draws' mod_name];save(fstr,'mtau_F_draws');
%
pwcorr_del50U_draws = pwcorr_del50U; clear pwcorr_del50U;
fstr = [mcmcdir 'pwcorr_del50U_draws' mod_name];save(fstr,'pwcorr_del50U_draws');
% 
pwcorr_del50Y_draws = pwcorr_del50Y; clear pwcorr_del50Y;
fstr = [mcmcdir 'pwcorr_del50Y_draws' mod_name];save(fstr,'pwcorr_del50Y_draws');
% 
pwcorr_U_draws = pwcorr_U; clear pwcorr_U;
fstr = [mcmcdir 'pwcorr_U_draws' mod_name];save(fstr,'pwcorr_U_draws');
% 
stddev_del50_m_draws = stddev_del50_m; clear stddev_del50_m;
fstr = [mcmcdir 'stddev_del50_m_draws' mod_name];save(fstr,'stddev_del50_m_draws');
% 
stddev_del50U_draws = stddev_del50U; clear stddev_del50U;
fstr = [mcmcdir 'stddev_del50U_draws' mod_name];save(fstr,'stddev_del50U_draws');
% 
stddev_U_draws = stddev_U; clear stddev_U;
fstr = [mcmcdir 'stddev_U_draws' mod_name];save(fstr,'stddev_U_draws');
% 
halflife_draws = halflife; clear halflife;
fstr = [mcmcdir 'halflife_draws' mod_name];save(fstr,'halflife_draws');
% 
U0_draws = U0; clear U0;
fstr = [mcmcdir 'U0_draws' mod_name];save(fstr,'U0_draws');
% 
UT_U0_draws = UT_U0; clear UT_U0;
fstr = [mcmcdir 'UT_U0_draws' mod_name];save(fstr,'UT_U0_draws');
% 
path_F_draws = path_f; clear path_f;
fstr = [mcmcdir 'path_F_draws' mod_name];save(fstr,'path_F_draws');
% 
paths_U_draws = paths_U; clear paths_U;
fstr = [mcmcdir 'paths_U_draws' mod_name];save(fstr,'paths_U_draws');

