% Forecast Results

% Descriptive Statists
clear all;
small = 1.0e-10;
pct = [0.05 1/6 0.50 5/6 0.95]';

% Model Name
mod_name = '_baseline';

% -- File Directories   
figdir = 'fig/';
outdir = 'out/';
matdir = 'mat/';
mcmcdir = 'mcmc/';
figdir_fcst = 'fig_fcst/';

fstr = [matdir 'country_code']; load(fstr);
fstr = [matdir 'country']; load(fstr);
fstr = [matdir 'yp']; load(fstr);
fstr = [matdir 'pop']; load(fstr);
n_c = size(country_code,1);
fstr = [matdir 'yfit_mat'];load(fstr);  %Trends .. for plotting

rslt_mat = NaN(6,7);

% List Exercises
mod_name_vec = { ...
    '_poos78' ...
    '_poos78' ...
    '_poos78' ...
    '_poos88' ...
    '_poos88' ...
    '_poos98';
};
Tis_vec = [78 78 78 88 88 98];
Yos_vec = [1997 2007 2017 2007 2017 2017];

for imod = 1:6;
    mod_name = mod_name_vec{imod};
    Tis = Tis_vec(imod);
    Yos = Yos_vec(imod);

    % Read in a Forecast path
    fstr = [mcmcdir 'f_draws_poos' mod_name];load(fstr);
    fstr = [mcmcdir 'u_draws_poos' mod_name];load(fstr);

    % Compute in-sample values
    u_is_draws_poos = u_draws_poos(1:Tis,:,:);
    f_is_draws_poos = f_draws_poos(1:Tis,:);

    % Compute Out of sample values
    Tos = 1+Yos-1900;
    nTos = Tos-Tis;

    % Percentiles from POOS
    f_gr_draws_poos = (f_draws_poos(Tos,:)-f_draws_poos(Tis,:))/nTos;
    u_gr_draws_poos = (squeeze(u_draws_poos(Tos,:,:)-u_draws_poos(Tis,:,:)))/nTos;
    u_gr_mean_draws_poos = mean(u_gr_draws_poos,1);
    fu_gr_draws_poos = f_gr_draws_poos+u_gr_mean_draws_poos;
    udm_gr_draws_poos = u_gr_draws_poos - repmat(u_gr_mean_draws_poos,n_c,1);

    % Compute percentiles:
     tmp = pctile_mean(f_gr_draws_poos',pct)';
     f_gr_mean_poos = tmp(1);
     f_gr_pct_poos = tmp(2:end);
     u_gr_mean_poos = NaN(n_c,1);
     u_gr_pct_poos = NaN(n_c,size(pct,1));
     for i = 1:n_c;
        tmp = pctile_mean(u_gr_draws_poos(i,:)',pct)';
        u_gr_mean_poos(i) = tmp(1);
        u_gr_pct_poos(i,:) = tmp(2:end)';
     end;

     % Acutal Values

     %  load Paths
     mod_name = '_baseline';
     fstr = [mcmcdir 'path_F_draws' mod_name];load(fstr);
     fstr = [mcmcdir 'paths_U_draws' mod_name];load(fstr);

     % Rename;
     u_draws = paths_U_draws;
     f_draws = path_F_draws;
     clear paths_U_draws;
     clear path_F_draws;

     % Construct percentiles for average growth rates T1 to end of Sample
     f_gr_draws = (f_draws(Tos,:)-f_draws(Tis,:))/nTos;
     u_gr_draws = (squeeze(u_draws(Tos,:,:)-u_draws(Tis,:,:)))/nTos;
     u_gr_mean_draws = mean(u_gr_draws,1);

     % Compute percentiles:
     tmp = pctile_mean(f_gr_draws',pct)';
     f_gr_mean = tmp(1);
     f_gr_pct = tmp(2:end);

     tmp = pctile_mean(u_gr_mean_draws',pct)';
     u_gr_mean_mean = tmp(1);
     u_gr_mean_pct = tmp(2:end);

     u_gr_mean = NaN(n_c,1);
     u_gr_pct = NaN(n_c,size(pct,1));
     for i = 1:n_c;
        tmp = pctile_mean(u_gr_draws(i,:)',pct)';
        u_gr_mean(i) = tmp(1);
        u_gr_pct(i,:) = tmp(2:end)';
     end;

     % Compute PIT for F and each U
     f_pit = mean(f_gr_draws_poos < f_gr_mean);
     u_mean_pit = mean(u_gr_mean_draws_poos < u_gr_mean_mean);

     tmp = u_gr_draws_poos < repmat(u_gr_mean,1,size(u_gr_draws_poos,2));
     u_pit = mean(tmp,2);

     rslt_mat(imod,1)=f_pit;
     %u_mean_pit
     pvec_u=[mean(u_pit < 0.25);mean((u_pit >= 0.25).*(u_pit < 0.5));mean((u_pit >= 0.50).*(u_pit < 0.75));mean(u_pit >= 0.75)];
     rslt_mat(imod,2:5)=pvec_u;

     % Compute KS Statistic
     ks_u = ks_uniform(u_pit);

     % Compute distribution of test statistics
     nrep = size(udm_gr_draws_poos,2);
     ks_u_draws = NaN(nrep,1);
     for i = 1:nrep;
        tmp = u_gr_draws_poos < repmat(u_gr_draws_poos(:,i),1,size(u_gr_draws_poos,2));
        tmp = mean(tmp,2);
        ks_u_draws(i) = ks_uniform(tmp);
     end;
     rslt_mat(imod,6:7)= [ks_u mean(ks_u_draws > ks_u)]';

end;

% Appendix Table results
outfile_name = [outdir 'Table_POOS.csv'];
fileID = fopen(outfile_name,'w');
prtmat_comma(rslt_mat,fileID,'%5.2f','\n');
    




    



		
	