% Read in the Europe IP data 
% Save as matlab file over the relevant sample period

% Load the employment data
% Read Employment Data
Data= readtable(['IP_Europe_16.xlsx']);
% Get the state names
sec_label = Data.Properties.VariableNames(3:end);
lev_data = Data{:,3:end};
first_date = [Data.Year(1) Data.Month(1)];
last_date =[Data.Year(end) Data.Month(end)];
first_date_save = [1975 7];
last_date_save = [2023 10];
[dnobs_all,calvec_all,calds_all] = calendar_make(first_date,last_date,12);
ismpl = smpl(calvec_all,first_date_save,last_date_save,12);
calds_m = calds_all(ismpl==1,:);
calvec_m = calvec_all(ismpl==1,:);
lev_data = lev_data(ismpl==1,:);
lfd_data = dif(log(lev_data),1);
% Save key variables
save(['IP_Europe_Data.mat'],'sec_label','lev_data','lfd_data','calds_m','calvec_m');
% Save selected variables in an excel file
writetable(array2table([calds_m,lev_data],'VariableNames',['Year','Month',sec_label]),...
    ['IP_Europe_Data.xlsx'],'Sheet','Data','WriteRowNames',false);  

