module Geweke
	use compute
	use dgp
	implicit none
	
	integer, parameter	:: npriordraws=3E5
	integer, parameter	:: nqs=19
	
	contains
	
	function tstat result(stat)
		real, allocatable	:: stat(:)
!		stat=[s2s,fus] !,fus(-nphi+2:capT,1)*fus(-nphi+1:capT-1,1)]
!		stat=[tdfes]
!		stat=[tdfe_var,tdfes,s2coefs,s2coefs_var]
		stat=[s2phi_prior,s2phi]
!		stat=[s2phi_prior]
!		stat=[s2s]
!		stat=[s2loads,s2loads_prior] 
!		stat=[ymus,phis]
!		stat=[s2coefs_var,s2coefs]! ,eos(:,n+1:n+1),ymus(:,n+1:n+1)] !,ymus] !,s2phi,s2s]
!		stat=[gs2,s2mud_prior,df_prior,tcoefs] !,loads,fus]
	end function

	
	subroutine Gcheck
		integer		:: l,nstats,i,j,leff,ib,il,iy,ifs,ix
		real, allocatable	:: priorstats(:,:), tracestats(:,:)
		real, allocatable	:: pquants(:,:,:)
		real, parameter	:: pgrid(nqs)=[(real(i)/(nqs+1),i=1,nqs)]
		real, allocatable :: chkmat(:,:), chkmat2(:,:)
		integer, parameter	:: nskip=10, nbatch=200
		real			:: cps(nbatch)
		real, allocatable	:: inds(:)

		
		call prep
		nstats=size(tstat())

		call dgp_gs2
		call dgp_s2loads_prior
		call dgp_s2loads
		call dgp_loads
		
		call dgp_s2phi_prior
		call dgp_s2phi
		call dgp_aphis
		
		call dgp_tdf_var
		call dgp_tdfs

		call dgp_tdfe_var
		call dgp_tdfes
		
		call dgp_s2coefs_var
		call dgp_s2coefs
		
		call dgp_s2bs
		call dgp_s2s
		
		allocate(priorstats(nstats,npriordraws),tracestats(nstats,npriordraws),pquants(nstats,nqs,2),chkmat(nstats,nqs))
		chkmat=0
		do l=1,npriordraws
			call dgp_s2phi_prior
			call dgp_s2phi
			call dgp_aphis

			call dgp_s2loads_prior
			call dgp_s2loads		
			call dgp_loads
			
			call dgp_tdf_var
			call dgp_tdfs

			call dgp_tdfe_var
			call dgp_tdfes
   
			call dgp_gs2
			
			call dgp_s2coefs_var
			call dgp_s2coefs
			call dgp_s2bs
			
			call dgp_s2s

			call dgp_ymus
			call dgp_eos
			call dgp_us
			priorstats(:,l)=tstat()
		enddo

		call printtime
!$omp parallel do private(j)
		do i=1,nstats
			pquants(i,:,1)=quantile_v(priorstats(i,:),pgrid)
			do j=1,nqs
				pquants(i,j,2)=count(priorstats(i,:)<=pquants(i,j,1))/real(npriordraws)
			enddo
		enddo
		inds=[0.0,0.0,0.0,0.0,0.0,0.0,[(1.0+real((i-1)/2),i=1,nstats-6)]]
		print *,"quantiles of test stats"
		call mdisp(pquants(:,:,1))
		print *,"cdf evaluated at quantiles" 
		call mdisp(pquants(:,:,2))
		chkmat2=chkmat; acc=0;accj=0; imh=0
		do l=1,npriordraws*nskip			
			call draw_us
!			call draw_all_adjust(l)
if(any(.not.isfinite(us))) then
	print *,l
stop
endif
			if(nfac>0) then
				call draw_gymus
				call draw_geos
				call set_globals_mV
				if(runflags(oe)) call draw_s2eglobal
				call draw_s2mudglobal
				call draw_path_globals
			endif
			do j=1,n
				call add_ymus(j)
				call draw_s2coefs(j)
			enddo
			call draw_s2coefs_var
			do j=1,n
				call draw_ymu_ustartup(j)
			enddo
			if(nfac>0) then
				call draw_fs_fast
				do j=1,n
					call add_aloads(j)
					call draw_as2load(j)
				enddo
				call draw_as2load_prior		
				do j=1,n
					call draw_aloads(j)
				enddo
			endif
			call draw_s2phi_prior
			call draw_phi1_0
			do j=1,na
				call draw_s2phi(j)
				call draw_phi(j)
			enddo
			call draw_gs2
			do j=1,nsv
				call set_eps2(j)
			enddo
			call draw_df_prior
			call draw_dfe_prior
			do j=1,nsv
				call draw_tdfes(j)
				call draw_tdfs(j)
				call draw_s2bs(j)
			enddo
100			if(mod(l,nskip)==0) then
				tracestats(:,l/nskip)=tstat()
			endif
			if(mod(l,nskip*20000)==0) then
				leff=l/nskip
!$omp parallel do private (j,cps,ib)
				do i=1,nstats
					do j=1,nqs
						do ib=1,nbatch
							cps(ib)=count(tracestats(i,(ib-1)*leff/nbatch+1:ib*leff/nbatch)<=pquants(i,j,1))/real(ib*leff/nbatch-(ib-1)*leff/nbatch)
						enddo
						cps=cps-pquants(i,j,2)
						chkmat(i,j)=sum(cps)
						if(chkmat(i,j).ne.0) chkmat(i,j)=chkmat(i,j)/sqrt(sum(cps**2))
						chkmat2(i,j)=count(tracestats(i,1:leff)<=pquants(i,j,1))/real(leff)-pquants(i,j,2)		
					enddo
				enddo
				call mdisp(merge(chkmat2,0.0,abs(chkmat)>4.0))
				print *,maxval(abs(chkmat))
				call print_acc(l)
			endif
		enddo
		print *,"Geweke check complete"
		call printtime
		stop
	end subroutine
	
end module