module data_mod
	use basicmodule
	implicit none
	
	contains
	
	subroutine trans(y,tscode)
		real, parameter	:: nan=0.0/0.0
		real	:: y(:)
		integer	:: tscode,capT

		capT=size(y)
		select case(tscode)
		case(2)
			y(2:)=y(2:)-y(1:capT-1)
			y(1)=nan
		case(3)
			y(2:)=y(2:)-y(1:capT-1)
			y(3:)=y(3:)-y(2:capT-1)
			y(1:2)=nan
		case(4)
			y=log(y)
		case(5)
			y=log(y)
			y(2:)=y(2:)-y(1:capT-1)
			y(1)=nan
		case(6)
			y=log(y)
			y(2:)=y(2:)-y(1:capT-1)
			y(3:)=y(3:)-y(2:capT-1)
			y(1:2)=nan
		case(7)
			y(2:)=y(2:)/y(1:capT-1)-1.0
			y(3:)=y(3:)-y(2:capT-1)
			y(1:2)=nan
		end select
	end subroutine
	
	subroutine transy(y)
		real	:: y(:,:)
		real	:: qs(3)
		integer	:: j
		qs=quantile_v(pack(y(1:capT,:),mask=isfinite(y(1:capT,:))),[0.25,0.5,0.75])
		mys(1,:)=qs(2)
		mys(2,:)=(qs(3)-qs(1))/1.35
		do j=1,size(y,2)
			y(:,j)=(y(:,j)-mys(1,j))/mys(2,j)
		enddo
	end subroutine
	
	subroutine loaddata(name)
		character(len=*)	:: name
		real, allocatable	:: mdata(:,:),tmp(:)
		real	:: m(2)
		integer	:: j,ny
		integer, allocatable	:: inds(:)
		mdata=loadcsv("C:/Dropbox/Fcst_FredQD/Data/"//trim(name)//".csv",.true.)
		mdata=mdata(:,3:)
		transcode=nint(mdata(1,:))
		mdata=mdata(2:,:)
		do j=1,size(mdata,2)
			call trans(mdata(:,j),transcode(j))
		enddo
		if(maxval(transcode)>1) mdata=mdata(2:,:)
		print *,"n=",n," capT=",capT, "max capT", size(mdata,1)
		if(allocated(r_ys)) deallocate(r_ys)
		allocate(r_ys(-nphi+1:capT+nh,n))
		r_ys=-1
		ny=min(capT+nh,size(mdata,1))
		r_ys(1:ny,:)=mdata(1:ny,:)
		call transy(r_ys(1:ny,:))		
		data_name=name
	end subroutine	
	
end module	