module dgp
	use basicmodule
	use StochVola
	implicit none
	
	contains

	subroutine dgp_s2phi_prior
		real	:: z(nphi,2)
		integer	:: i
		do i=1,2
			call rnnoa(z)
if(i==2) z=0
if(i==1) z(:,2)=0
			s2phi_prior(:,:,i)=s2phi_prior_prior(:,:,i,1)+sqrt(s2phi_prior_prior(:,:,i,2))*z
			s2phi_prior(:,2,i)=exp(s2phi_prior(:,2,i))
		enddo			
	end subroutine
	
	subroutine dgp_s2phi
		integer	::	j
		real	:: z(nphi)
		do j=1,np
			s2phi(:,1,j)=s2phi_prior(:,2,1)
			call rnnoa(z)
			s2phi(:,2,j)=exp(s2phi_prior(:,1,2)+sqrt(s2phi_prior(:,2,2))*z)
		enddo
	end subroutine

	subroutine dgp_aphis
		real	:: s(nphi),z(nphi),varstate(nphi),uvarstate(nphi),sig(nphi,nphi)
		integer	:: t,j
		do j=1,na
			uvarstate=s2phi(:,1,j)
			varstate=min(s2phi(:,2,j),maxs2phid)
			call rnnoa(z)
			s=z*sqrt(uvarstate)+s2phi_prior(:,1,1)		
			phis(:,0,j)=adjust_phi(s)
			sig=choleski(toepmat(get_gamma_from_phi(phis(:,0,j))))
			call invertL(sig,acholini(:,:,j))

			do t=1,capT
				phis(:,t,j)=s
				if(t==capT) exit
				call rnnoa(z)
				s=s+sqrt(varstate)*z
			enddo
		enddo
	end subroutine
	
	subroutine dgp_ymus
		integer	::t,j
		real	:: z(capT)
		do j=1,nmu
			call rnnoa(z)
			ymus(1,j)=z(1)*sqrt(merge(s2mui,0.0,j<=n))
			do t=2,capT
				ymus(t,j)=ymus(t-1,j)+sqrt(exp(s2coefs(omud,j)))*z(t)
			enddo
		enddo
	end subroutine
	
	subroutine dgp_s2loads_prior
		real	:: z(nld,2)
		integer	:: l,i
		do l=1,nfac
			do i=1,2
				call rnnoa(z)
				if(l>1 .and. i==1) z(1,2)=0		! don't move variance of contemporaneous loadings for l>1
				s2loads_prior(:,:,i,l)=s2loads_prior_prior(:,:,i,1)+sqrt(s2loads_prior_prior(:,:,i,2))*z
				s2loads_prior(:,2,i,l)=exp(s2loads_prior(:,2,i,l))
			enddo
		enddo
	end subroutine
	
	subroutine dgp_s2loads
		integer	:: l,i,j
		real	:: z(nld)
		do l=1,nfac
			do j=1,n
				s2loads(:,1,l,j)=s2loads_prior(:,2,1,l)
				call rnnoa(z)
				s2loads(:,2,l,j)=exp(s2loads_prior(:,1,2,l)+sqrt(s2loads_prior(:,2,2,l))*z)
			enddo
		enddo
	end subroutine
		
	subroutine dgp_loads
		integer	:: j,l
		real	:: varstate(nld),uvarstate(nld),z(nld)
		real	:: s0(nld)
		integer	:: t
		do j=1,n
			do l=1,nfac
				uvarstate=s2loads(:,1,l,j)
				varstate=min(s2loads(:,2,l,j),maxs2loadd)
				call rnnoa(z)
				s0=sqrt(uvarstate)*z+s2loads_prior(:,1,1,l)
				do t=1,capT
					loads(:,t,l,j)=s0
					if(t==capT) exit
					call rnnoa(z)
					s0=s0+sqrt(varstate)*z
				enddo
			enddo
		enddo
	end subroutine
		
	subroutine dgp_gs2
		real	:: z(1)
		call rnnoa(z)
		tgs2=gs2_prior(1)+sqrt(gs2_prior(2))*z(1)
	end subroutine
	
	subroutine dgp_tdf_var
		real	:: z(1)
		call rnnoa(z)
		tdf_var=exp(tdf_prior_prior(1,1)+sqrt(tdf_prior_prior(2,1))*z(1))
		call rnnoa(z)	
		tdfs(0)=tdf_prior_prior(1,0)+sqrt(tdf_prior_prior(2,0))*z(1)
	end subroutine
	
	subroutine dgp_tdfs
		real	:: z(1)
		integer	:: j
		do j=1,na
			call rnnoa(z)
			tdfs(j)=tdfs(0)+sqrt(tdf_var)*z(1)
		enddo
	end subroutine
	
	subroutine dgp_tdfe_var
		real	:: z(1)
		call rnnoa(z)
		tdfe_var=exp(tdfe_prior_prior(1,1)+sqrt(tdfe_prior_prior(2,1))*z(1))
		call rnnoa(z)	
		tdfes(0)=tdfe_prior_prior(1,0)+sqrt(tdfe_prior_prior(2,0))*z(1)
	end subroutine
	
	subroutine dgp_tdfes
		real	:: z(1)
		integer	:: j
		do j=1,na
			call rnnoa(z)
			tdfes(j)=tdfes(0)+sqrt(tdfe_var)*z(1)
		enddo
	end subroutine

	subroutine dgp_s2coefs_var
		real	:: z(ns2c)
		call rnnoa(z(1:oup))
		s2coefs_var=exp(s2coefs_prior_prior(:,1,1)+sqrt(s2coefs_prior_prior(:,2,1))*z(1:oup))
		call rnnoa(z)
		s2coefs(1:ou0,0)=tgs2+s2coefs_prior_prior(1:ou0,1,0)+sqrt(s2coefs_prior_prior(1:ou0,2,0))*z(1:ou0)
		s2coefs(oup:,0)=sqrt(s2coefs_prior_prior(oup,2,0))*z(oup:)
	end subroutine
	
	subroutine dgp_s2coefs
		real	:: z(ns2c)
		integer	:: j,i
		do j=1,n
			call rnnoa(z)
			s2coefs(1:ou0,j)=sqrt(s2coefs_var(1:ou0))*z(1:ou0)
			s2coefs(oup:,j)=sqrt(s2coefs_var(oup))*z(oup:)
			s2coefs(:,j)=s2coefs(:,j)+s2coefs(:,0)
		enddo
		if(nfac>0) then
			call rnnoa(z)
			s2coefs([oeo,omud],n+1)=tgs2+global_eo_mud_prior(:,1)+sqrt(global_eo_mud_prior(:,2))*z([oeo,omud])
			s2coefs(ou0,n+1)=tgs2+s2fac_prior(1)+sqrt(s2fac_prior(2))*z(1)
			s2coefs(oup:,n+1)=sqrt(s2coefs_var(oup))*z(oup:)+s2coefs(oup:,0)
		endif
	end subroutine
	
	subroutine dgp_s2bs
		real	:: v(1),df,s2
		integer	:: j,t
		do j=1,na
			do t=1,capT
				df=min(df_offset+exp(tdfs(j)),df_max)
				call rnchi2(df,v)
				s2bs(t,j)=df/v(1)
			enddo
		enddo
		do j=1,na
			do t=1,capT
				df=min(df_offset+exp(tdfes(j)),df_max)
				call rnchi2(df,v)
				s2beos(t,j)=df/v(1)
			enddo
		enddo
	end subroutine
		
	subroutine dgp_s2s
		real	:: v(1),df,s2
		integer	:: j,t
		do j=1,na
			do t=1,capT
				s2s(t,j)=exp(sum(cost(:,t)*s2coefs(ou0:,j)))*s2bs(t,j)
				s2eos(t,j)=exp(s2coefs(oeo,j))*s2beos(t,j)
			enddo
			s2s(0,j)=s2s(1,j)/s2bs(1,j)
		enddo
	end subroutine

	subroutine dgp_eos
		integer	:: j,t
		do j=1,na
			call rnnoa(eos(:,j))
			eos(:,j)=eos(:,j)*sqrt(s2eos(:,j))
		enddo
	end subroutine
	
	subroutine dgp_us
		integer	::t,j
		real	:: sig(nphi,nphi),z(capT)
		do j=1,na
			sig=toepmat(s2s(0,j)*get_gamma_from_phi(phis(:,0,j)))
			call rnnoa(us(:,j))
			us(-nphi+1:0,j)=matmul(choleski(sig),us(-nphi+1:0,j))
			do t=1,capT
				us(t,j)=sqrt(s2s(t,j))*us(t,j)+sum(phis(:,t,j)*us(t-1:t-nphi:-1,j))
			enddo
		enddo
	end subroutine

	subroutine draw_us
		integer	:: j,t
		real	:: z(capT)
		do j=1,n
			call rnnoa(us(1:,j))
			do t=1,capT
				us(t,j)=sqrt(s2s(t,j))*us(t,j)+sum(phis(:,t,j)*us(t-1:t-nphi:-1,j))
			enddo
		enddo
	end subroutine
	
end module
	