module draw_gymus_mod
	use basicmodule
	implicit none

	contains
	
	subroutine set_gbandxxi(band,sm)
		real	:: band(nphi+1,2:capT),sm(2:capT)
		real	:: V(nphi+1,nphi+1),h(nphi+1),m(nphi+1),tmp
		integer	:: i,j,t,i1,t1
		band=0; sm=0
!$omp parallel do private(t,h,i,tmp,i1,V,m,t1) reduction(+:sm,band)		
		do j=1,n
			do t=2,capT
				us(t,j)=us(t,j)+ymus(t,n+1)
				h(1)=1
				h(2:)=-phis(:,t,j)
				do i=1,nphi+1
					tmp=h(i)/s2s(t,j)
					do i1=i,nphi+1
						V(i1,i)=h(i1)*tmp
					enddo
				enddo
				m=h*(us(t,j)-sum(phis(:,t,j)*us(t-1:t-nphi-1:-1,j)))/s2s(t,j)
				do i1=0,nphi+1-1
					t1=t-i1
					if(t1<2) cycle
					sm(t1)=sm(t1)+m(i1+1)
					band(i1+1:nphi+1,t1)=band(i1+1:nphi+1,t1)+V(nphi+1:i1+1:-1,i1+1)
				enddo
			enddo
		enddo
	end subroutine
	
	subroutine set_gymus_fast(ts2,bxxi,sm,ll,m)
		use lapack95, only: pbtrf,gbtrs,pbtrs
		real	:: ts2,s2i,bxxi(nphi+1,2:capT),sm(2:capT),ll,m(2:capT)
		real	:: bi(nphi+1,2:capT),bsigi(nphi+1,2:capT),mu(2:capT)

		bi=bxxi
		s2i=exp(-ts2)
		bi(nphi,3:)=bi(nphi,3:)-s2i
		bi(nphi+1,2:capT-1)=bi(nphi+1,2:capT-1)+2*s2i
		bi(nphi+1,capT)=bi(nphi+1,capT)+s2i
		call pbtrf(bi)
		mu=sm
		call pbtrs(bi,mu)
		ll=+.5*sum(sm*mu)+.5*(capT-1)*log(s2i)-sum(log(bi(nphi+1,:)))
		ll=ll-.5*(ts2-tgs2-global_eo_mud_prior(omud,1))**2/global_eo_mud_prior(omud,2)		
		call rnnoa(m)
		call gbtrs(bi,m,ipivot(1:capT-1),kl=0)
		m=m+mu
	end subroutine
	
	subroutine draw_gymus
		use lapack95, only: pbtrf,gbtrs,pbtrs
		real	:: bxxi(nphi+1,2:capT)
		real	:: sm(2:capT),ms(2:capT,2)
		real	:: new_ts2(2)
		real	:: ll(2),u(1),z(1)
		integer	:: j,t,i

		call set_gbandxxi(bxxi,sm)
		call rnnoa(z)
		z=z*mhscales(0,ogymus)	
		new_ts2=s2coefs(omud,n+1)
		new_ts2(1)=new_ts2(1)+mhscales(0,ogymus)*sqrt(global_eo_mud_prior(omud,2)/capT)*z(1)
!$omp parallel do 			
		do i=1,2
			call set_gymus_fast(new_ts2(i),bxxi,sm,ll(i),ms(:,i))
		enddo
			
		call rnun(u)
		i=merge(1,2,u(1)<exp(ll(1)-ll(2)))
		ymus(2:capT,n+1)=ms(:,i)
		if(i==1) then
			s2coefs(omud,n+1)=new_ts2(1)
			acc(0,ogymus)=acc(0,ogymus)+1
		endif
		call sub_gymus
	end subroutine
	
	subroutine sub_gymus
		integer	:: j,t
		do j=1,n
			do t=2,capT
				us(t,j)=us(t,j)-ymus(t,n+1)
			enddo
		enddo
	end subroutine 
	
end module

	