module myfuncs
	implicit none
	integer(8)	time0, time1
	real, parameter		:: pi=3.14159265358979323846
	
    interface mdisp
        module procedure mydispvec,mydispmat,mydispscalar,mydispstring
	end interface

    interface quantile
        module procedure quantile_s,quantile_v
	end interface
	
    contains


	subroutine inittime()
		call system_clock(time0)
	end subroutine
	
	subroutine printtime()
		integer(8), parameter	:: nrate=1000
		integer(8)	:: h,m,s,t
		call system_clock(time1)
		t=(time1-time0)/1000
		h=t/(3600*nrate)
		t=t-(3600*nrate)*h
		m=t/(nrate*60)
		t=t-(nrate*60)*m
		s=t/nrate
		t=t-nrate*s
	
		print *,"time elapsed ",h,":",m,":",s,".",t
	end subroutine
	
	elemental function isfinite(x) result(val)
		use, intrinsic :: ieee_arithmetic 
		real, intent(in)	:: x
		logical	:: val
		val =ieee_is_finite(x)
	end function
		
	elemental function boole(flag) result(val)
		logical, intent(in)	:: flag
		integer	:: val
		if(flag) then 
			val=1
		else
			val=0
		endif
	end function
	
	elemental function rboole(flag) result(val)
		logical, intent(in)	:: flag
		real	:: val
		if(flag) then 
			val=1
		else
			val=0
		endif
	end function

	
	subroutine invertpd(V)
		use lapack95, only: potrf,potri
		real::V(:,:)
		integer	:: i
		call potrf(V)
		call potri(V)
		do i=1,size(V,1)-1
			V(i+1:,i)=V(i,i+1:)
		enddo
	end subroutine

	subroutine invertpd8(V)
		use lapack95, only: potrf,potri
		real(8)::V(:,:)
		integer	:: i
		call potrf(V)
		call potri(V)
		do i=1,size(V,1)-1
			V(i+1:,i)=V(i,i+1:)
		enddo
	end subroutine
	
	subroutine zero_upper(A)
		real	:: A(:,:)
		integer	:: i,j
		do i=1,size(A,1)
			do j=1,i-1
				A(j,i)=0
			enddo
		enddo
	end subroutine
	
	function choleski(A) result(B)
		use lapack95, only: potrf
		real	:: A(:,:), B(size(A,1),size(A,2))
		B=A
		call potrf(B,"L")
		call zero_upper(B)
	end function
	
	subroutine zero_upper8(A)
		real(8)	:: A(:,:)
		integer	:: i,j
		do i=1,size(A,1)
			do j=1,i-1
				A(j,i)=0
			enddo
		enddo
	end subroutine

	function choleski8(A) result(B)
		use lapack95, only: potrf
		real(8)	:: A(:,:), B(size(A,1),size(A,2))
		B=A
		call potrf(B,"L")
		call zero_upper8(B)
	end function

    function outerprod(v1,v2) result(val)
        real    :: v1(:),v2(:),val(size(v1),size(v2))
        integer :: i1,i2
        do i1=1,size(v1)
            do i2=1,size(v2)
                val(i1,i2)=v1(i1)*v2(i2)
            enddo
        enddo
    end function
	
	function diagonal(A) result(val)
		real::A(:,:),val(size(A,1))
		integer :: i
		do i=1,size(A,1)
			val(i)=A(i,i)
		enddo
	end function
	
	function eye(k) result(val)
		integer	:: k
		real	:: val(k,k)
		integer	:: i
		val=0
		do i=1,k
			val(i,i)=1.0
		enddo
	end function
		
	function zeros(k) result(val)
		integer	:: k
		real	:: val(k)
		val=0
	end function

	function ones(k) result(val)
		integer	:: k
		real	:: val(k)
		val=1
	end function

	function diagmat(vec) result(val)
		implicit none
		real	:: vec(:)
		real	:: val(size(vec),size(vec))
		integer	:: i
		val=0
		do i=1,size(vec)
			val(i,i)=vec(i)
		enddo
	end function
	
	function bandmat(vec) result(val)
		real	:: vec(:)
		real	:: val(size(vec)/2+1,size(vec)/2+1)
		integer	:: i
		val=0
		do i=1,size(vec)/2+1
			val(:,i)=vec(size(vec)/2+2-i:size(vec)/2+1-i+size(vec)/2)
		enddo
	end function
	
	function toepmat(vec) result(val)
		real	:: vec(:)
		real	:: val(size(vec),size(vec))
		integer	:: i,j
		val=0
		do i=1,size(vec)
			do j=1,size(vec)
				val(j,i)=vec(abs(j-i)+1)
			enddo
		enddo
	end function

	function getdiagonal(mat) result(val)
		real	:: mat(:,:)
		real	:: val(size(mat,1))
		integer	:: i
		val=0
		do i=1,size(val)
			val(i)=mat(i,i)
		enddo
	end function
	
	elemental function logit(x)
		real, intent (in)	:: x
		real				:: logit
		if(x>0) then
			logit=1.0/(1+exp(-x))
		else
			logit=exp(x)/(1+exp(x))
		endif
	end function

	elemental function invlogit(x) result(val)
		real, intent (in)	:: x
		real				:: val
		val=log(x/(1-x))
	end function
	
	function logmeanexp(v) result(out)
		real		::v(:)
		real		::out,maxv
		maxv=maxval(v)
		out=maxv+log(sum(exp(v-maxv)))-log(real(size(v)))
	end function

	function logsumexp(v) result(out)
		real		::v(:)
		real		::out,maxv
		maxv=maxval(v)
		out=maxv+log(sum(exp(v-maxv)))
    end function
    
    function orderstat(k,a) result(val)
        integer  :: k
        real     :: a(:),val,hope,pesty
        integer  ::  n
        integer  :: l,r,l2,r2
        n=size(a)
        l = 1
        r = n
        do while (l < r)
            hope = a(k)
            l2 = l
            r2 = r
            do while (l2 <= r2)
                do while (a(l2)< hope)
                    l2 = l2 + 1
                end do
                do while (hope<a(r2))
                    r2 = r2 - 1
                end do
                if (l2 <r2) then
                    pesty = a(l2)
                    a(l2) = a(r2)
                    a(r2) = pesty
                endif
                if (l2 <= r2) then
                    l2 = l2 + 1
                    r2 = r2 - 1
                endif
            end do
            if (r2<k) l = l2
            if (k<l2) r = r2
        end do
        val = a(k)
    end function 

    function quantile_v(X,ps) result(qs)
		real		::X(:),ps(:),qs(size(ps))
        real, allocatable   :: xcopy(:)
        integer     :: i,k
        
		allocate(xcopy(size(x)+2))
		xcopy(1)=-huge(1.0); xcopy(size(x)+2)=huge(1.0)
		do i=1,size(x)
			xcopy(1+i)=x(i)
		enddo
        do i=1,size(ps)
            k=nint(ps(i)*size(x))+1
            qs(i)=orderstat(k,xcopy)
        enddo
    end function
    
    function quantile_s(X,p) result(q)
		real		::X(:),p,q
        real        :: qs(1)
        qs=quantile_v(X,[p])
        q=qs(1)
    end function

	subroutine standardize(x)
		real	:: x(:)
		x=x-sum(x)/size(x)
		x=x/sqrt(sum(x**2)/size(x))
	end subroutine
	
	function standardized(x) result(val)
		real	:: x(:),val(size(x))
		val=x-sum(x)/size(x)
		val=val/sqrt(sum(val**2)/size(x))
	end function
	
	function stddev(X) result(std)
		real		::X(:),std
        std=sqrt(sum((X-sum(X)/size(X))**2)/size(X))
	end function
	
	function getcorr(X,Y) result(val)
		real		::X(:),Y(:),val
		real		::xbar,ybar
		integer		:: n
		n=size(x)
		xbar=sum(x)/n
		ybar=sum(y)/n
		val=(sum(x*y)-n*xbar*ybar)/sqrt((sum(x**2)-n*xbar**2)*(sum(y**2)-n*ybar**2))
	end function
    
    function selectifc(X,cond) result(val)
		real	:: X(:,:)
		logical	:: cond(:)
		integer	:: i,c
		real, allocatable	:: val(:,:)
		if(size(X,2).ne.size(cond)) then
			print *,"vector size doesn't match in selectifc"
			stop
		endif
		if(allocated(val)) deallocate(val)
		allocate(val(size(X,1),count(cond)))
		c=1
		do i=1,size(X,2)
			if(cond(i)) then 
				val(:,c)=X(:,i)
				c=c+1
			endif
		enddo
	end function

	function selectifr(X,cond) result(val)
		real	:: X(:,:)
		logical	:: cond(:)
		integer	:: i,c
		real, allocatable	:: val(:,:)
		if(size(X,1).ne.size(cond)) then
			print *,"vector size doesn't match in selectifr"
			stop
		endif
		if(allocated(val)) deallocate(val)
		allocate(val(count(cond),size(X,2)))
		c=1
		do i=1,size(X,1)
			if(cond(i)) then 
				val(c,:)=X(i,:)
				c=c+1
			endif
		enddo
	end function
	
	function selectif_r(v,cond) result(val)
		real	:: v(:)
		logical	:: cond(:)
		integer	:: i,c
		real, allocatable	:: val(:)
		if(size(v).ne.size(cond)) then
			print *,"vector size doesn't match in selectif"
			stop
		endif
		allocate(val(count(cond)))
		c=1
		do i=1,size(v)
			if(cond(i)) then 
				val(c)=v(i)
				c=c+1
			endif
		enddo
	end function
	
	function reversec(A) result(val)
		real	:: A(:,:)
		real	:: val(size(A,1),size(A,2))
		integer	:: i,j
		val=A([(j,j=size(A,1),1,-1)],:)
	end function
	
	function reverser(A) result(val)
		real	:: A(:,:)
		real	:: val(size(A,1),size(A,2))
		integer	:: i,j
		val=A(:,[(j,j=size(A,2),1,-1)])
	end function

	function kron(A,B) result(val)
		real	:: A(:,:),B(:,:)
		real	:: val(size(A,1)*size(B,1),size(A,2)*size(B,2))
		integer	:: i,j
		do i=1,size(A,2)
			do j=1,size(A,1)
				val((j-1)*size(B,1)+1:j*size(B,1),(i-1)*size(B,2)+1:i*size(B,2))=A(j,i)*B
			enddo
		enddo
	end function
	
	function trace(A) result(val)
		real	:: A(:,:)
		real	:: val
		integer	:: i
		val=0
		do i=1,size(A,1)
			val=val+A(i,i)
		enddo
	end function

	function vech(A) result(val)
		real	:: A(:,:)
		real	:: val(size(A,1)*(size(A,1)+1)/2)
		integer	:: i,j,c
		c=1
		do i=1,size(A,1)
			do j=i,size(A,1)
				val(c)=A(j,i)
				c=c+1
			enddo
		enddo
	end function
	
	function loadcsv(filename, headerflag) result(mat)
        character(len=*):: filename
		logical, optional	:: headerflag
        real, allocatable  :: mat(:,:)
        integer         :: ioerr,m,n,i,j,myunit,l1,l2
        character(:), allocatable  :: line
		real	:: nanx=0.0/0.0

        open (file=filename,status='old',iostat=ioerr,newunit=myunit)
        if(ioerr/=0) then
            print *,"loadcsv: file not found: ",filename
            stop
        endif
        m=0
        do
            read (myunit,*,iostat=ioerr)
            if (ioerr/=0) exit     
            m=m+1
        enddo
        rewind(myunit)
		call getline
        n=countitems(line)
        rewind(myunit)
		if(present(headerflag)) then
			if(headerflag) then
				m=m-1
				call getline
			endif
		endif
        allocate(mat(m,n))
        do i=1,m
			call getline
			l1=1
			do j=1,n
				l2=merge(index(line(l1:),","),len(line)-l1+2,j<n)
				if(l2==0) then 
					print *,"loadcsv: not enough fields in row",i
					stop
				endif
				if(l2==1) then 
					mat(i,j)=nanx
				else
					read(line(l1:l1+l2-2),*,iostat=ioerr) mat(i,j)
					if(ioerr>0) mat(i,j)=nanx
				endif
				l1=l1+l2
			enddo
		enddo
        close(myunit)
        
        contains

			function countitems(line) result(val)
				character(len=*)    :: line
				integer				:: val
				integer				:: i,n
				val=1
				n=len(line)
				do i=1,n
					if(line(i:i)==",") val=val+1
				enddo
			end function
			
			subroutine getline
		        character(len=8192) :: buffer
				integer				:: lsize
		        line=''
		        do
		            read(myunit,"(a)",advance="no",iostat=ioerr,size=lsize) buffer
				    if(ioerr>0) then
						print *,"loadmat can't read first line: ",filename
						stop
					endif
					line=line//buffer(:lsize)
					if(ioerr<0) exit
				enddo
			end subroutine
	end function


    function loadstrings(filename) result(vec)
        character(len=*):: filename
        character(len=:), allocatable  :: vec(:)
        integer         :: ioerr,m,n,i,lsize,myunit
        character(:), allocatable  :: line
        character(len=256)    :: buffer
 
        open (file=filename,status='old',iostat=ioerr,newunit=myunit)
        if(ioerr/=0) then
            print *,"loadstrings file not found: ",filename
            stop
        endif
        m=0; n=0
        do
            read (myunit,"(a)",iostat=ioerr) buffer
            if (ioerr/=0) exit     
            m=m+1
			n=max(n,len_trim(buffer))
        enddo
        rewind(myunit)
		allocate(character(n)::vec(m))
		do i=1,m
            read(myunit,"(a)",iostat=ioerr) vec(i)
            if (ioerr/=0) then
                print *,"loadmat trouble reading from file: ",filename
				print *,i
                stop
            endif
        enddo
        close(myunit)
    end function
	
    function loadvec(filename) result(vec)
        character(len=*):: filename
        real, allocatable  :: vec(:)
        vec=[loadmat(filename)]
    end function
	
    function loadmat(filename) result(mat)
        character(len=*):: filename
        real, allocatable  :: mat(:,:)
        integer         :: ioerr,m,n,i,lsize,myunit
        character(len=256)    :: buffer
        character(:), allocatable  :: line
 
        open (file=filename,status='old',iostat=ioerr,newunit=myunit)
        if(ioerr/=0) then
            print *,"loadmat file not found: ",filename
            stop
        endif
        m=0
        do
            read (myunit,*,iostat=ioerr)
            if (ioerr/=0) exit     
            m=m+1
        enddo
        rewind(myunit)
        line=''
        do
            read(myunit,"(a)",advance="no",iostat=ioerr,size=lsize) buffer
            if(ioerr>0) then
                print *,"loadmat can't read first line: ",filename
                stop
            endif
            line=line//buffer(:lsize)
            if(ioerr<0) exit
        enddo
        n=ntokens(line)
        rewind(myunit)
        allocate(mat(m,n))
        do i=1,m
            read(myunit,*,iostat=ioerr) mat(i,:)
            if (ioerr/=0) then
                print *,"loadmat trouble reading from file: ",filename
				print *,i
                stop
            endif
        enddo
        close(myunit)
        
        contains

        function ntokens(line) result(val)
            integer :: val
            character(len=*)    :: line
            integer             :: i, n, toks
            CHARACTER TAB, space
            TAB=CHAR(9)
			space=char(32)
    
            i = 1
            n = len_trim(line)
            toks = 0
            val = 0
            do while(i <= n)
               do while(line(i:i)==space.or.line(i:i) == ' '.or.line(i:i) == tab.or.line(i:i) == ',') 
                 i = i + 1
                 if (n < i) return
               enddo
               toks = toks + 1
               val = toks
               do
                 i = i + 1
                 if (n < i) return
                 if (line(i:i) == ' '.or.line(i:i) == tab.or.line(i:i) == ',') exit
               enddo
            enddo
        end function ntokens
    end function

    subroutine savemat(filename,mat)
        character(len=*):: filename
        real            :: mat(:,:)
        integer         :: ioerr,i,j,myunit
 
        open (file=filename,iostat=ioerr,newunit=myunit)
        if(ioerr/=0) then
            print *,"savemat could not open file for writing: ",filename
            stop
        endif
        
        do i=1,size(mat,1)
            do j=1,size(mat,2)
                write(myunit,'(ES27.18E3)',advance='no') mat(i,j)
            enddo
            write(myunit,*)
        enddo
        close(myunit)
    end subroutine
        
    subroutine savevec(filename,vec)
        character(len=*):: filename
        real            :: vec(:),mat(size(vec),1)
        mat(:,1)=vec
        call savemat(filename,mat)
	end subroutine
    
    subroutine savematcsv(filename,mat)
        character(len=*):: filename
        real            :: mat(:,:)
        integer         :: ioerr,i,j,myunit
 
        open (file=filename,iostat=ioerr,newunit=myunit)
        if(ioerr/=0) then
            print *,"savemat could not open file for writing: ",filename
            stop
        endif
        
        do i=1,size(mat,1)
            do j=1,size(mat,2)
                write(myunit,'(ES27.18E3)',advance='no') mat(i,j)
				if(j<size(mat,2)) write(myunit,'(a)',advance='no') ","
            enddo
            write(myunit,*)
        enddo
        close(myunit)
	end subroutine

	subroutine mydispnames(vec)
		character(len=*)	:: vec(:)
		character(len=size(vec)*10) :: line
		integer	:: i
		do i=1,size(vec)
			write(line((i-1)*10+1:i*10),'(a)') vec(i)
		enddo
		write (*,'(a)') line
	end subroutine
	
	subroutine mydispmat(mat)
		real	:: mat(:,:)
		integer	:: i
		do i=1,size(mat,dim=1)
			call mydispline(mat(i,:))
		enddo
		write (*,*)
	end subroutine

	subroutine mydispscalar(x)
		real	:: x
		write (*,'(a)') numstr(x)
		write (*,*) 
	end subroutine

	subroutine mydispstring(str)
		character(len=*)	:: str
		write (*,'(a)') str
	end subroutine

	
	subroutine mydispvec(vec)
		real	:: vec(:)
		call mydispline(vec)
		write (*,*) 
	end subroutine
	
	subroutine mydispline(vec)
		real	:: vec(:)
		integer	:: n,i
		character(len=size(vec)*10) :: line
		n=size(vec)
		do i=1,n
			line((i-1)*10+1:i*10)=numstr(vec(i))
		enddo
		write (*,'(a)') line
	end subroutine
	
	function numstr(x) result(val)
		real	:: x,ax
		character(len=10)	:: val
		if(.not.isfinite(x)) then
			val="NaN"
			return
		endif
		ax=abs(x)
		if(ax==0) then
			write(val,'(I9)') 0
			return
		endif
		if(ax>0.001) then
			if(ax<9.999) then
				write(val,'(F9.6)') x
				return
			endif
			if(ax<99.999) then
				write(val,'(F9.5)') x
				return
			endif
			if(ax<999.99) then
				write(val,'(F9.4)') x
				return
			endif
			if(ax<9999.9) then
				write(val,'(F9.3)') x
				return
			endif
		endif
		if(ax<1) ax=1/ax
		if(ax<9.99E99) then
			write(val,'(ES9.2e2)') x
			return
		endif
		write(val,'(ES9.1e3)') x
	end function

	subroutine mydispivec(vec) 
		integer	:: vec(:)
		integer	:: n,i
		character(len=size(vec)) :: line
		
		n=size(vec)
		do i=1,n
			write(line(i:i),'(I1)') vec(i)
		enddo
		write (*,'(a)') line
	end subroutine
	
	function convtos(i,k) result(val)
		character(:),allocatable :: val
		integer	:: i
		integer, optional	:: k
		character(range(i)+2) :: tmp
		character(10)		:: fmt
		
		if(present(k)) then
			write (fmt,'(a,I0,a)') "(i0.",k,")"
			write (tmp,fmt) i
		else
		  write(tmp,'(i0)') i
		endif
		val = trim(tmp)
	end function
	
	function addvtomat(v,mat) result(val)
		real	:: v(:), mat(:,:)
		real, allocatable	:: val(:,:)
		val=reshape([mat,v],[size(mat,1),size(mat,2)+1])
	end function
		
end module	
		
		
