% Construct AO forecasts for the PCE Inlfation data
% BY AO, I mean using average inflation over the last 12 months as predictors for all horizons
clearvars;
small = 1.0e-8;
big = 1.0e+8;
this_date = datestr(now,'yyyymmdd');

% -- File Directories  
datadir='../Data/'; 
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';

% Add paths for Matlab Utility Functions
addpath('../Matlab_Utility_Programs/');

% Parameters for the exercise
first_fcst = [1984 12]; % First forecast period
n_h = 12;               % Number of forecast periods

% Read PCED Data
load([datadir 'pcomp_data_monthly.mat']);
calds = calds_m;
calvec = calvec_m;
dnobs = dnobs_m;
data_mat = dp_disagg_m;
sec_label = labelvec_short_disagg;
n_sectors = size(data_mat,2);

% Matrices for saving the results
rslt_fcsts = NaN(n_h,n_sectors,dnobs);    % Forecasted values
rslt_actual = NaN(n_h,n_sectors,dnobs);  % Actual values

% Find first forecast period .. find first_fcst in calds
t_first = find(calds(:,1) == first_fcst(1) & calds(:,2) == first_fcst(2));

for i_sec = 1:n_sectors
    for t = t_first:dnobs
        fcst = mean(data_mat(t-11:t,i_sec),1); % Average of last 12 months
        for i_h = 1:n_h
            rslt_fcsts(i_h,i_sec,t) = fcst;
            if (t+i_h <= dnobs)
                rslt_actual(i_h,i_sec,t) = data_mat(t+i_h,i_sec);
            end
        end
    end
end

% Save the results
% Variables to save
var_save = {'rslt_fcsts','rslt_actual'};
save([matdir 'AO_fcst_pced.mat'],var_save{:});
