% Plot State Employment and IP Data Including Covid Period -- results shown in Figure 8
clearvars;
small = 1.0e-8;
big = 1.0e+8;
this_date = datestr(now,'yyyymmdd');

% -- File Directories  
datadir='../Data/'; 
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';

% Read Employment Data
SData = readtable([datadir 'StateEmployment.xlsx']);
emp_data = SData{:,3:end};
demp_data = 1200*dif(log(emp_data),1);
% Get the state names
states = SData.Properties.VariableNames(3:end);
% Get the data
calvec = SData.Year + (SData.Month-1)/12;
calds = [SData.Year SData.Month];
dnobs = length(calvec);

% Dell
fig = figure('units','normalized','outerposition',[0 0 0.8 1.0]);  % Dell
leg_fs = 25;
lw_1 = 1.0;
ax_fs = 25;

plot(calvec,demp_data,'LineWidth',lw_1);
xlim([2017 2025.5]);
set(gca,'FontSize',ax_fs);
ylabel('Percent Points (Annual Rate)','FontSize',ax_fs);
xlabel('Year','FontSize',ax_fs);

figure_to_png(figdir, 'Figure8a_StateEmp_Data_Plot');
close(fig);


% Read Data
load([datadir 'IP_Europe_Data.mat']);
calvec = calvec_m;
calds = calds_m;
dnobs = size(calds,1);  
lfd_data = dif(log(lev_data),1);
data_mat = 1200*lfd_data;  % Convert to percentage change
n_sectors = size(lfd_data,2);

% Dell
fig = figure('units','normalized','outerposition',[0 0 0.8 1.0]);  % Dell
leg_fs = 25;
lw_1 = 1.0;
ax_fs = 25;

plot(calvec,data_mat,'LineWidth',lw_1);
xlim([2017 2024]);
set(gca,'FontSize',ax_fs);
ylabel('Percent Points (Annual Rate)','FontSize',ax_fs);
xlabel('Year','FontSize',ax_fs);

figure_to_png(figdir, 'Figure8b_IPEurope_Data_Plot');
close(fig);

