% Plot IP Europe Data and PCE Inflation Data for Figure 6
clearvars;
small = 1.0e-8;
big = 1.0e+8;
this_date = datestr(now,'yyyymmdd');

% -- File Directories  
datadir='../Data/'; 
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';


% Add paths for Matlab Utility Functions
addpath('../Matlab_Utility_Programs/');

% Read Data
load([datadir 'IP_Europe_Data.mat']);
calvec = calvec_m;
calds = calds_m;
dnobs = size(calds,1);  
lfd_data = dif(log(lev_data),1);
data_mat = 100*lfd_data;  % Convert to percentage change
n_sectors = size(lfd_data,2);

% Sectors to Plot
sec_plot = {'Austria','France','Ireland','Italy','Norway','UK'};
n_plot = length(sec_plot);
data_plot = zeros(dnobs,n_plot);
sec_plot_idx = zeros(n_plot,1);
offset1 = 50;
offset = offset1;
d_offset = 25;
for i = 1:n_plot
    sec = sec_plot{i};
    idx = find(strcmp(sec_label,sec));
    sec_plot_idx(i) = idx;
    data_plot(:,i) = data_mat(:,idx)-offset;
    offset = offset + d_offset;
end

% Dell
fig = figure('units','normalized','outerposition',[0 0 0.8 1.0]);  % Dell
leg_fs = 25;
ax_fs = 25;
lab_fs_1 = 25;
lw_1 = 0.8;
lw_2 = 1.5;

lab_fs_2 = ceil(lab_fs_1*0.8);

plot(calvec,data_mat,'LineWidth',lw_1);
xlim([1975 2019.99]);

hold on;
for i = 1:n_plot
    plot(calvec,data_plot(:,i),'LineWidth',lw_2);
end
hold off;
set(gca,'FontSize',ax_fs);
% suppress the y-axis
set(gca,'YTickLabel',[]);
%  Add Labels
xlab_1 = 1995;
ylab_1 = 25;
lab_1 = '(a) All Countries';
text(xlab_1,ylab_1,lab_1,'FontSize',lab_fs_1);
xlab_2 = xlab_1;
ylab_2 = ylab_1-offset1-10;
lab_2 = '(b) Select Countries';
text(xlab_2,ylab_2,lab_2,'FontSize',lab_fs_1);
d_off = d_offset;
ylab_3 = ylab_2-7;
xlab_3 = 1977;
for i = 1:n_plot
    text(xlab_3,ylab_3,sec_label{sec_plot_idx(i)},'FontSize',lab_fs_2);
    ylab_3 = ylab_3 - d_off;
end
figure_to_png(figdir, 'Figure6a_IPEurope_Data_Plot');
close(fig);


% Read PCED Data
load([datadir 'pcomp_data_monthly.mat']);
calds = calds_m;
calvec = calvec_m;
dnobs = dnobs_m;
data_mat = dp_disagg_m;
sec_label = labelvec_short_disagg;
n_sectors = size(data_mat,2);
  
% Sectors to Plot
sec_plot = {'DFDHRG','DFXARG','DCLORG','nom_hu_xes','DIFSRG','DHLCRG'};
n_plot = length(sec_plot);
data_plot = zeros(dnobs,n_plot);
sec_plot_idx = zeros(n_plot,1);
offset1 = 150;
offset = offset1;
d_offset = 50;
for i = 1:n_plot
    sec = sec_plot{i};
    idx = find(strcmp(namevec_disagg,sec));
    sec_plot_idx(i) = idx;
    data_plot(:,i) = data_mat(:,idx)-offset;
    offset = offset + d_offset;
end
% Pause for 2 seconds
pause(2);

% Dell
fig = figure('units','normalized','outerposition',[0 0 0.8 1.0]);  % Dell
leg_fs = 25;
ax_fs = 25;
lab_fs_1 = 25;
lw_1 = 0.8;
lw_2 = 1.5;

lab_fs_2 = ceil(lab_fs_1*0.8);

plot(calvec,data_mat,'LineWidth',lw_1);
xlim([1959 2025.99]);

hold on;
for i = 1:n_plot
    plot(calvec,data_plot(:,i),'LineWidth',lw_2);
end
hold off;
set(gca,'FontSize',ax_fs);
% suppress the y-axis
set(gca,'YTickLabel',[]);
%  Add Labels
xlab_1 = 1990;
ylab_1 = 125;
lab_1 = '(a) All Sectors';
text(xlab_1,ylab_1,lab_1,'FontSize',lab_fs_1);
xlab_2 = xlab_1;
ylab_2 = ylab_1-offset1-75;
lab_2 = '(b) Select Sectors';
text(xlab_2,ylab_2,lab_2,'FontSize',lab_fs_1);
d_off = d_offset;
ylab_3 = ylab_2-30;
xlab_3 = 1960;
for i = 1:n_plot
    text(xlab_3,ylab_3,sec_label{sec_plot_idx(i)},'FontSize',lab_fs_2);
    ylab_3 = ylab_3 - d_off;
end
ylim([-450 225]);

% figure_to_png(figdir, 'PCEInflation_Data_Plot_Slides_1');
figure_to_png(figdir, 'Figure6b_PCEInflation_Data_Plot');
close(fig);