% POOS forecast summary for PCE Inflation
clearvars;
small = 1.0e-8;
big = 1.0e+8;
this_date = datestr(now,'yyyymmdd');

% -- File Directories  
datadir='../Data/'; 
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';

% Relative RMSE Boxplots for three datasets
load([  matdir 'emp_rel_rmse_sector_' this_date '_1999_12_2019_6.mat']);
rel_rmse_emp = squeeze(rel_rmse_sector(:,:,end));
load([matdir 'PCE_rel_rmse_sector_' this_date '_1984_12_2024_10.mat']);
rel_rmse_pce = squeeze(rel_rmse_sector(:,:,end));
load([matdir 'IPEurope_rel_rmse_sector_' this_date '_1985_6_2019_6.mat']);
rel_rmse_ip = squeeze(rel_rmse_sector(:,:,end));

rng('default'); % reproducibility
data1 = rel_rmse_emp(1,:);
data2 = rel_rmse_ip(1,:);
data3 = rel_rmse_pce(1,:);
data4 = rel_rmse_emp(3,:);
data5 = rel_rmse_ip(3,:);
data6 = rel_rmse_pce(3,:);
data7 = rel_rmse_emp(6,:);
data8 = rel_rmse_ip(6,:);
data9 = rel_rmse_pce(6,:);


allData = {data1, data2, data3, data4, data5, data6, data7, data8, data9};

% X positions for boxplots (with spacing between pairs)
positions = [1 2 3  5 6 7  9 10 11];

% Colors: blue for odd (BP1,3,5), red for even (BP2,4,6)
colors = lines(3);
Color1  = colors(1,:);
Color2 = colors(2,:);
Color3 = colors(3,:);

ax_fs = 25;
figure('Units', 'normalized', 'Position', [0 0 0.85 1.0]); % For Dell Wide Monitor

hold on;
for i = 1:9
    % Draw each boxplot individually
    h = boxplot(allData{i}, 'positions', positions(i), 'widths', 0.6, ...
                'Colors', 'k','OutlierSize',10);  % initially black
    
    boxes = findobj(h, 'Tag', 'Box');
    
    % Pick color
    if i == 1 || i == 4 || i == 7
        thisColor = Color1; % emp
    elseif i == 2 || i == 5 || i == 8
        thisColor = Color2; % PCE
    else
        thisColor = Color3; % IPEuro
    end
    
    % Recolor the box with a filled patch
    patch(get(boxes(1),'XData'), get(boxes(1),'YData'), thisColor, ...
          'FaceAlpha', 0.5);
end

% Axis cosmetics
xlim([0 12])
ylim([0.7 1.2]);
xticks(positions)
xticklabels({'Emp','IP','Infl','Emp','IP','Infl','Emp','IP','Infl'})
ylabel('Relative Root-MSFE')
% title('Grouped Boxplots (Alternate Coloring)')
grid on


% --- Add second row of labels (group labels) ---
yl = ylim; % y-axis limits
labelY = yl(1) - 0.05*(yl(2)-yl(1)); % place slightly below axis

% Group centers
groupX = [mean([1 2 3]), mean([5 6 7]), mean([9 10 11])];
groupLabels = {'h=1','h=3','h=6'};

for j = 1:numel(groupX)
    text(groupX(j), labelY, groupLabels{j}, ...
        'HorizontalAlignment','center', 'VerticalAlignment','top', ...
        'FontWeight','bold','FontSize',ax_fs);
end

set(gca,'FontSize',ax_fs);

hold off;

saveas(gcf, [figdir 'Relative_RMSE_three.png']);
saveas(gcf, [figdir 'Figure_7.png']);
close(gcf);
