% POOS forecast summary for PCE Inflation -- AR and FRBNY-MCT Model
clearvars;
small = 1.0e-8;
big = 1.0e+8;
this_date = datestr(now,'yyyymmdd');

% -- File Directories  
datadir='../Data/'; 
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
matdir_mct = '../FRBNY_MCT/Watson_Modification/mat/';  % location of MCT forecast .mat files
umdir = '../Fortran_fcsts/';  % location of forecasts from UM's Fortran implementations

% Add paths for Matlab Utility Functions
addpath('../Matlab_Utility_Programs/');

% Dates for the various forecast files ... 
% AR forecasts
first_date_ar = [1959 1];
last_date_ar = [2025 4];

% UM forecasts
first_date_um = [1984 12];
last_date_um = [2025 4];

% Dates for forecast evaluation
first_fcst = [1984 12]; % First forecast period evaluation period
last_fcst = [2024 10];  % Last forecast period evaluation period

n_h = 12;                % Number of forecast periods in the forecast files
h_rpt = [1 3 6];         % Horizons to Report
n_max_rpt = max(h_rpt);  % Maximum horizon

% File names
% Suffix
f_suffix = ['_' this_date '_' num2str(first_fcst(1)) '_' num2str(first_fcst(2)) '_' num2str(last_fcst(1)) '_' num2str(last_fcst(2))];
% CSV file for Tabular Results
csv_file_name = [outdir 'PCE_MCT_RTS' f_suffix '.csv'];            % CSV File for tabular results

% Set up a calendar to use across forecasts
[dnobs_all,calvec_all,calds_all] = calendar_make([1959 1],[2025 4],12);

% Percentiles for quantile forecasts
pct_vec = [0.05 0.10 1/6 0.25 0.50 0.75 5/6 0.90 0.95];   % These quantiles should not be changed ... they are the quantiles computed by UM's Fortran code
n_quant = length(pct_vec);

% First and last date for each forecast
t_first_ar = find(calds_all(:,1) == first_date_ar(1) & calds_all(:,2) == first_date_ar(2));
t_last_ar = find(calds_all(:,1) == last_date_ar(1) & calds_all(:,2) == last_date_ar(2));
t_first_um = find(calds_all(:,1) == first_date_um(1) & calds_all(:,2) == first_date_um(2));
t_last_um = find(calds_all(:,1) == last_date_um(1) & calds_all(:,2) == last_date_um(2));
dnobs_ar = t_last_ar - t_first_ar + 1;
dnobs_um = t_last_um - t_first_um + 1;

% Dates for the evaluation period
t_first_fcst = find(calds_all(:,1) == first_fcst(1) & calds_all(:,2) == first_fcst(2));
t_last_fcst = find(calds_all(:,1) == last_fcst(1) & calds_all(:,2) == last_fcst(2));

% Load the PCE data
load([datadir 'pcomp_data_monthly.mat']);
first_date_data = calds_m(1,:);
last_date_data = calds_m(end,:);
t_first_data = find(calds_all(:,1) == first_date_data(1) & calds_all(:,2) == first_date_data(2));
t_last_data = find(calds_all(:,1) == last_date_data(1) & calds_all(:,2) == last_date_data(2));
n_sectors = size(dp_disagg_m,2);
data_mat = NaN(dnobs_all,n_sectors);
data_mat(t_first_data:t_last_data,:) = dp_disagg_m;
share_all = NaN(dnobs_all,n_sectors);
share_all(t_first_data:t_last_data,:) = share_avg_m;
share_xfe = NaN(dnobs_all,n_sectors);
share_xfe(t_first_data:t_last_data,:) = share_avg_xfe_m;
share_xe = NaN(dnobs_all,n_sectors);
share_xe(t_first_data:t_last_data,:) = share_avg_xe_m;

% Load the AR forecasts
load([matdir 'ar_fcst_pced.mat']);
fcsts_ar = NaN(n_h,n_sectors,dnobs_all);
fcsts_ar(:,:,t_first_ar:t_last_ar) = rslt_fcsts;
actual_ar = NaN(n_h,n_sectors,dnobs_all);
actual_ar(:,:,t_first_ar:t_last_ar) = rslt_actual;
sd_fcsts_ar = NaN(n_h,n_sectors,dnobs_all);
sd_fcsts_ar(:,:,t_first_ar:t_last_ar) = sd_fcsts;
sd_fcsts_accum_ar = NaN(n_h,n_sectors,dnobs_all);
sd_fcsts_accum_ar(:,:,t_first_ar:t_last_ar) = sd_fcsts_accum;

% Load the MCT forecasts
load([matdir_mct 'mct_fcst_pced_1984_12_2025_4.mat']);
fcsts_mct = NaN(n_h,n_sectors,dnobs_all);
fcsts_mct(:,:,t_first_ar:t_last_ar) = rslt_fcsts;
actual_mct = NaN(n_h,n_sectors,dnobs_all);
actual_mct(:,:,t_first_ar:t_last_ar) = rslt_actual;

% Load the UM forecasts
scl_um = 1;  % Scaling factor for UMs forecasts
% UM Models
UM_Models = {'FFFFF0','TFFFF0','TTFFF0','TTTFF0','TTTTF0','TTTTT0','TTTTT1'};
n_models = length(UM_Models);
fcsts_um = NaN(n_h,n_sectors,dnobs_all,n_models);
actual_um = NaN(n_h,n_sectors,dnobs_all);
quantiles_um_accum = NaN(n_quant,n_h,n_sectors,dnobs_all,n_models);
for i_model = 1:n_models
    load([umdir 'PCE_Inflation' UM_Models{i_model} '.mat' ]);
    fcsts_um(:,:,t_first_um:t_last_um,i_model) = fcsts/scl_um;
    quantiles_um_accum(:,:,:,t_first_um:t_last_um,i_model) = quantfs(:,:,:,1:dnobs_um)/scl_um;
end
for i_h = 1:n_h
        fcsts0(i_h,:,end-i_h+1:end) = NaN;
end
actual_um(:,:,t_first_um:t_last_um) = fcsts0/scl_um;

% Save the RTS model -- final model of the UM models
fcsts_rts = squeeze(fcsts_um(:,:,:,n_models));
actual_rts = actual_um;


% Save these over the max horizon reported
n_h = n_max_rpt;
fcsts_ar = fcsts_ar(1:n_h,:,:);
actual_ar = actual_ar(1:n_h,:,:);
fcsts_mct = fcsts_mct(1:n_h,:,:);
actual_mct = actual_mct(1:n_h,:,:);
fcsts_rts = fcsts_rts(1:n_h,:,:);
actual_rts = actual_rts(1:n_h,:,:);

% Check some actual values to make sure things are aligned properly
i_h = 6;
i_sec = 12;
t = find(calds_all(:,1) == 2005 & calds_all(:,2) == 1);
a_ar = actual_ar(i_h,i_sec,t);
a_mct = actual_mct(i_h,i_sec,t);
a_rts = actual_rts(i_h,i_sec,t);
a_data = data_mat(i_h+t,i_sec);
if abs(a_ar - a_data) > small
    error('Actuals from AR and data do not match');
end
if abs(a_ar - a_mct) > small
    error('Actuals from AR and MCT do not match');
end
if abs(a_ar - a_rts) > small
    error('Actuals from AR and um do not match');
end

% Create outlier adjusted versions of the data --- used to check robustness -- see below
thr = 4;
tflag = 3;
x_window = 3;
data_mat_adj = NaN(dnobs_all,n_sectors);
for i = 1:n_sectors
    data_mat_adj(:,i) = adjout_2(data_mat(:,i),thr,tflag,x_window);
end

% Create a matrix of actuals and outliers adjusted actuals
actual = NaN(n_h,n_sectors,dnobs_all);
actual_adj = NaN(n_h,n_sectors,dnobs_all);
for i = 1:n_sectors
    for j = 1:n_h
        actual(j,i,1:end-j) = data_mat(1+j:end,i);
        actual_adj(j,i,1:end-j) = data_mat_adj(1+j:end,i);
    end
end

% Compute Forecast Errors for raw series
errs_ar = fcsts_ar - actual;
errs_mct = fcsts_mct - actual;
errs_rts = fcsts_rts - actual;
% Forecast Errors for adjusted series
errs_ar_adj = fcsts_ar - actual_adj;
errs_mct_adj = fcsts_mct - actual_adj;
errs_rts_adj = fcsts_rts - actual_adj;

% Save Results to a CSV File
file_name = csv_file_name;
fid = fopen(file_name,'w');
fprintf(fid,'PCE Results AR and MCT\n');
fprintf(fid,['Sample Period:  %4i:%2i to %4i:%2i \n\n'],[first_fcst last_fcst]);

% Tabulate RMSE for AR and relative RMSE for UM models
fprintf(fid,'\n\n Results for Table 2 in paper  \n');
e_ar = errs_ar;
e_mct = errs_mct;
e_rts = errs_rts;
% Note that forecasts were for growth rates from t to t+1 .. convert forecast for t to t+h
e_ar = cumsum(e_ar,1);
e_mct = cumsum(e_mct,1);
e_rts = cumsum(e_rts,1);
ee_ar = e_ar(:,:,t_first_fcst:t_last_fcst);
ee_mct = e_mct(:,:,t_first_fcst:t_last_fcst);
ee_rts = e_rts(:,:,t_first_fcst:t_last_fcst);

fprintf(fid,',Horizon \n');
fprintf(fid,'Model,');
fprintf(fid,'%i,',h_rpt);
fprintf(fid,'\n');
fprintf(fid,',(a) rmse for AR(12)\n');
fprintf(fid,'AR(12): ,');
for j = 1:length(h_rpt)
        i_h = h_rpt(j);
        tmp1 = ee_ar(i_h,:,:);
        xtmp1 = tmp1(:);
        rmse = sqrt(mean(xtmp1.^2));
        fprintf(fid,'%6.1f,',(1/i_h)*rmse);
end
fprintf(fid,'\n');
fprintf(fid,', Relative RMSEs \n');
fprintf(fid,'AR(12),1.0,1.0,1.0 \n');
    fprintf(fid,'MCT,');
    for j = 1:length(h_rpt)
        i_h = h_rpt(j);
        tmp1 = ee_ar(i_h,:,:);
        tmp2 = ee_mct(i_h,:,:);
        xtmp1 = tmp1(:);
        xtmp2 = tmp2(:);
        rel_rmse = sqrt(sum(xtmp2.^2)/sum(xtmp1.^2));
        fprintf(fid,'%6.2f,',rel_rmse);
    end
    fprintf(fid,'\n');
    fprintf(fid,'RTS,');
    for j = 1:length(h_rpt)
        i_h = h_rpt(j);
        tmp1 = ee_ar(i_h,:,:);
        tmp2 = ee_rts(i_h,:,:);
        xtmp1 = tmp1(:);
        xtmp2 = tmp2(:);
        rel_rmse = sqrt(sum(xtmp2.^2)/sum(xtmp1.^2));
        fprintf(fid,'%6.2f,',rel_rmse);
    end
    fprintf(fid,'\n');
fprintf(fid,'\n\n');


% Tabulate RMSE for AR and relative RMSE for UM models
fprintf(fid,'\n\n Adendum -- Outlier Adjusted Data  \n');
e_ar = errs_ar_adj;
e_mct = errs_mct_adj;
e_rts = errs_rts_adj;
% Note that forecasts were for growth rates from t to t+1 .. convert forecast for t to t+h
e_ar = cumsum(e_ar,1);
e_mct = cumsum(e_mct,1);
e_rts = cumsum(e_rts,1);
ee_ar = e_ar(:,:,t_first_fcst:t_last_fcst);
ee_mct = e_mct(:,:,t_first_fcst:t_last_fcst);
ee_rts = e_rts(:,:,t_first_fcst:t_last_fcst);

fprintf(fid,',Horizon \n');
fprintf(fid,'Model,');
fprintf(fid,'%i,',h_rpt);
fprintf(fid,'\n');
fprintf(fid,',(a) rmse for AR(12)\n');
fprintf(fid,'AR(12): ,');
for j = 1:length(h_rpt)
        i_h = h_rpt(j);
        tmp1 = ee_ar(i_h,:,:);
        xtmp1 = tmp1(:);
        rmse = sqrt(mean(xtmp1.^2));
        fprintf(fid,'%6.1f,',(1/i_h)*rmse);
end
fprintf(fid,'\n');
fprintf(fid,', Relative RMSEs \n');
fprintf(fid,'AR(12),1.0,1.0,1.0 \n');
    fprintf(fid,'MCT,');
    for j = 1:length(h_rpt)
        i_h = h_rpt(j);
        tmp1 = ee_ar(i_h,:,:);
        tmp2 = ee_mct(i_h,:,:);
        xtmp1 = tmp1(:);
        xtmp2 = tmp2(:);
        rel_rmse = sqrt(sum(xtmp2.^2)/sum(xtmp1.^2));
        fprintf(fid,'%6.2f,',rel_rmse);
    end
    fprintf(fid,'\n');
    fprintf(fid,'RTS,');
    for j = 1:length(h_rpt)
        i_h = h_rpt(j);
        tmp1 = ee_ar(i_h,:,:);
        tmp2 = ee_rts(i_h,:,:);
        xtmp1 = tmp1(:);
        xtmp2 = tmp2(:);
        rel_rmse = sqrt(sum(xtmp2.^2)/sum(xtmp1 .^2));
        fprintf(fid,'%6.2f,',rel_rmse);
    end
    fprintf(fid,'\n');
fprintf(fid,'\n\n');


fprintf(fid,'\n\n Aggregate Inflation (All Items)  \n');
share = share_all;
e_ar = errs_ar;
e_mct = errs_mct;
e_rts = errs_rts;
e_ar = cumsum(e_ar,1);
e_mct = cumsum(e_mct,1);
e_rts = cumsum(e_rts,1);
e_ar = share_weight_agg(share,e_ar);
e_mct = share_weight_agg(share,e_mct);
e_rts = share_weight_agg(share,e_rts);
ee_ar = e_ar(:,:,t_first_fcst:t_last_fcst);
ee_mct = e_mct(:,:,t_first_fcst:t_last_fcst);
ee_rts = e_rts(:,:,t_first_fcst:t_last_fcst);
fprintf(fid,',Horizon \n');
fprintf(fid,'Model,');
fprintf(fid,'%i,',h_rpt);
fprintf(fid,'\n');
fprintf(fid,',(a) rmse for AR(12)\n');
fprintf(fid,'AR(12): ,');
for j = 1:length(h_rpt)
        i_h = h_rpt(j);
        tmp1 = ee_ar(i_h,:,:);
        xtmp1 = tmp1(:);
        rmse = sqrt(mean(xtmp1.^2));
        fprintf(fid,'%6.1f,',(1/i_h)*rmse);
end
fprintf(fid,'\n');
fprintf(fid,', Relative RMSEs \n');
fprintf(fid,'AR(12),1.0,1.0,1.0 \n');
    fprintf(fid,'MCT,');
    for j = 1:length(h_rpt)
        i_h = h_rpt(j);
        tmp1 = ee_ar(i_h,:,:);
        tmp2 = ee_mct(i_h,:,:);
        xtmp1 = tmp1(:);
        xtmp2 = tmp2(:);
        rel_rmse = sqrt(sum(xtmp2.^2)/sum(xtmp1.^2));
        fprintf(fid,'%6.2f,',rel_rmse);
    end
    fprintf(fid,'\n');
    fprintf(fid,'RTS,');
    for j = 1:length(h_rpt)
        i_h = h_rpt(j);
        tmp1 = ee_ar(i_h,:,:);
        tmp2 = ee_rts(i_h,:,:);
        xtmp1 = tmp1(:);
        xtmp2 = tmp2(:);
        rel_rmse = sqrt(sum(xtmp2.^2)/sum(xtmp1.^2));
        fprintf(fid,'%6.2f,',rel_rmse);
    end
    fprintf(fid,'\n');
fprintf(fid,'\n\n');

fprintf(fid,'\n\n Aggregate Inflation (XFE)  \n');
share = share_xfe;
e_ar = errs_ar;
e_mct = errs_mct;
e_rts = errs_rts;
e_ar = cumsum(e_ar,1);
e_mct = cumsum(e_mct,1);
e_rts = cumsum(e_rts,1);
e_ar = share_weight_agg(share,e_ar);
e_mct = share_weight_agg(share,e_mct);
e_rts = share_weight_agg(share,e_rts);
ee_ar = e_ar(:,:,t_first_fcst:t_last_fcst);
ee_mct = e_mct(:,:,t_first_fcst:t_last_fcst);
ee_rts = e_rts(:,:,t_first_fcst:t_last_fcst);
fprintf(fid,',Horizon \n');
fprintf(fid,'Model,');
fprintf(fid,'%i,',h_rpt);
fprintf(fid,'\n');
fprintf(fid,',(a) rmse for AR(12)\n');
fprintf(fid,'AR(12): ,');
for j = 1:length(h_rpt)
        i_h = h_rpt(j);
        tmp1 = ee_ar(i_h,:,:);
        xtmp1 = tmp1(:);
        rmse = sqrt(mean(xtmp1.^2));
        fprintf(fid,'%6.1f,',(1/i_h)*rmse);
end
fprintf(fid,'\n');
fprintf(fid,', Relative RMSEs \n');
fprintf(fid,'AR(12),1.0,1.0,1.0 \n');
    fprintf(fid,'MCT,');
    for j = 1:length(h_rpt)
        i_h = h_rpt(j);
        tmp1 = ee_ar(i_h,:,:);
        tmp2 = ee_mct(i_h,:,:);
        xtmp1 = tmp1(:);
        xtmp2 = tmp2(:);
        rel_rmse = sqrt(sum(xtmp2.^2)/sum(xtmp1.^2));
        fprintf(fid,'%6.2f,',rel_rmse);
    end
    fprintf(fid,'\n');
    fprintf(fid,'RTS,');
    for j = 1:length(h_rpt)
        i_h = h_rpt(j);
        tmp1 = ee_ar(i_h,:,:);
        tmp2 = ee_rts(i_h,:,:);
        xtmp1 = tmp1(:);
        xtmp2 = tmp2(:);
        rel_rmse = sqrt(sum(xtmp2.^2)/sum(xtmp1.^2));
        fprintf(fid,'%6.2f,',rel_rmse);
    end
    fprintf(fid,'\n');
fprintf(fid,'\n\n');






%%%%%%%%%%% Functions %%%%%%%%%%%%%
% Functions
function x_agg = share_weight_agg(share,x);
    n_h = size(x,1);
    x_agg = NaN(n_h,1,size(share,1));
    for i_h = 1:n_h
        tmp = squeeze(x(i_h,:,:))';
        tmp1 = tmp.*share;
        x_agg(i_h,1,:) = sum(tmp1,2);
    end
end