% Prior plots for the df for the innovations from Model 3
clearvars;
small = 1.0e-8;
big = 1.0e+8;
this_date = datestr(now,'yyyymmdd');

% -- File Directories  
datadir='../Data/'; 
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
umdir = '../Fortran_fcsts/';  % location of forecasts from UM's Fortran implementations

% Add paths for Matlab Utility Functions
addpath('../Matlab_Utility_Programs/');

% Dates for the various forecast files ... 
% UM forecasts
first_date_um = [1999 12];
last_date_um = [2024 4];

% Dates for prior/posteriors 
pp_date = [2019 6];  % Last forecast period evaluation period

% Set up a calendar to use across forecasts
[dnobs_um,calvec_um,calds_um] = calendar_make(first_date_um,last_date_um,12);
t_pp = find(calds_um(:,1) == pp_date(1) & calds_um(:,2) == pp_date(2));

% Load the UM forecasts
% UM Models
UM_Model_3 = 'TTFFF0';
load([umdir 'StateEmployment' UM_Model_3 '.mat' ]);
mv_mat = squeeze(hps(:,:,t_pp)); 

% Document rows for the hyperparameters
nu_row = 18;   % 

n_grid = 1000;  % Number of grid points for plotting
z_grid = linspace(-3,3,n_grid)';  % Grid for plotting z values
xgrid = linspace(-0.75,0.75,n_grid)';  % Grid for plotting
mean = mv_mat(nu_row,1);
variance = mv_mat(nu_row,2);
x_grid = sqrt(variance) * z_grid + mean;  % Transform z values to x values
nu_grid = 2 + exp(x_grid);
prior_x = normpdf(x_grid,mean,sqrt(variance));  % Prior for nu
prior_nu = prior_x .* (1./(nu_grid-2));

fig = figure('units','normalized','outerposition',[0 0 0.6 0.95]);  % Dell
ax_fs = 25;
plot(nu_grid,prior_nu,'b','LineWidth',2);
xlabel('Degrees of Freedom Parameter \nu');
set(gca,'FontSize',ax_fs);

% Save the figure
% figure_to_png(figdir, 'Prior_Plots_nu_Model3');
figure_to_png(figdir, 'Figure_4');
close(fig);

% --- Format for the input files 

% % I also now save the hyperpriors (for all runs, it's not more work and maybe useful). The new matlab files (will) have one more variable called "hps". This is a 51x4xM matrix, where M is the number of runs. The rows of the matrix contain the posterior means of the hyperpriors, with the first two columns corresponding to the level, and the last two columns corresponding to the time variation in that parameter. If not applicable, value is NaN. Each type of parameter is separated from other parameters by a single row of NaNs.

% % First row: mean mu

% % Third row: variance sigma^2

% % 5th row: phis

% % 18th row: nu, degree of freedom parameter

% % 20th row: kappa, scale of outliers

% % 22th row: lambdas, factor parameters

% % 29th row: xis, q coefficients of time varying volatility (padded with additional NaN rows so they fit even for T=770). Note that the q coefficients have a common variance parameter in the hyperprior)