% Common volatility path (mean) from Model 5
clearvars;
small = 1.0e-8;
big = 1.0e+8;
this_date = datestr(now,'yyyymmdd');

% -- File Directories  
datadir='../Data/'; 
outdir = 'out/';
figdir = 'fig/';
matdir = 'mat/';
umdir = '../Fortran_fcsts/';  % location of forecasts from UM's Fortran implementations

% Add paths for Matlab Utility Functions
addpath('../Matlab_Utility_Programs/');

% Dates for the various forecast files ... 
% UM forecasts
first_date_um = [1999 12];
last_date_um = [2024 4];

% Dates for prior/posteriors 
pp_date = [2019 6];  % Last forecast period evaluation period

% Set up a calendar to use across forecasts
[dnobs_um,calvec_um,calds_um] = calendar_make(first_date_um,last_date_um,12);
t_pp = find(calds_um(:,1) == pp_date(1) & calds_um(:,2) == pp_date(2));

% Load the UM forecasts
% UM Models
UM_Model_5 = 'TTTTF0';
load([umdir 'StateEmployment' UM_Model_5 '.mat' ]);
mv_mat = squeeze(hps(:,:,t_pp)); 

r1 = 29;
q = 9;
r2 = r1 + q - 1;
xi_mean = mv_mat(r1:r2,1);
[dnobs,calvec,calds] = calendar_make([1990 1],pp_date,12);
n_t = dnobs;

% Construct covariance matrix of demeaned random walk
A = rw_cov(n_t);
M = eye(n_t) - (1/n_t)*ones(n_t,n_t);
A = M*A*M;
% Construct eigenvalues and eigenvectors
[eigvec,eigval] = eig(A);
eval = diag(eigval);
x = sqrt(eval(1:q));
A1 = eigvec(:,1:q);

sig_mean = A1*(x.*xi_mean);
fig = figure('units','normalized','outerposition',[0 0 0.5 0.65]);  % Dell
ax_fs = 25;
plot(calvec,sig_mean,'b','LineWidth',2);
xlabel('Date');
set(gca,'FontSize',ax_fs);

% Save the figure
% figure_to_png(figdir, 'Prior_Plots_Mean_Model5');
figure_to_png(figdir, 'Figure_5');
close(fig);

% --- Format for the input files 

% % I also now save the hyperpriors (for all runs, it's not more work and maybe useful). The new matlab files (will) have one more variable called "hps". This is a 51x4xM matrix, where M is the number of runs. The rows of the matrix contain the posterior means of the hyperpriors, with the first two columns corresponding to the level, and the last two columns corresponding to the time variation in that parameter. If not applicable, value is NaN. Each type of parameter is separated from other parameters by a single row of NaNs.

% % First row: mean mu

% % Third row: variance sigma^2

% % 5th row: phis

% % 18th row: nu, degree of freedom parameter

% % 20th row: kappa, scale of outliers

% % 22th row: lambdas, factor parameters

% % 29th row: xis, q coefficients of time varying volatility (padded with additional NaN rows so they fit even for T=770). Note that the q coefficients have a common variance parameter in the hyperprior)