function [acv] = SS_Model_ACV_Univariate(s,phi,theta,n_acv)
    % The model has the form:
    %   h(t) = phi*h(t-1) + theta*u(t)
    %   y(t) = s*h(t)
    %   Where u(t) is iid (0,I) 
    %   and where y(t) is a scalar
    %   
    %   This function computes the autocovariances of y(t) from lag 0 to n_acv
    %
    % Check to make sure that y is a scalar
    if size(s,1) ~= 1
        error('y must be a scalar, s has the wrong dimension')
    end

    n_state = size(phi,1);  % Number of states
    V = theta*theta'; % Variance of the innovations

    % Step 1: Compute variance of state
    tmp = eye(n_state^2) - kron(phi,phi);
    vec_Sigma = tmp\V(:);
    Sigma = reshape(vec_Sigma,n_state,n_state);

    % Step 2: compute autocovariances
    acv = NaN(n_acv+1,1);
    for i = 1:n_acv+1
        acv(i) = s*Sigma*s';
        Sigma = phi*Sigma;
    end

end