function [s,phi,theta] = ar_to_ss(rho,se)
    % Convert to AR model to a SS model of the form
    % h(t) = phi*h(t-1) + theta*u(t)
    % y(t) = s*h(t)
    % where h(t) is the state variable, u(t) is the innovation with unit variance, and y(t) is the observation
    % rho is a colum vector the vector AR coefficients
    % se is the standard error of the innovations from the AR model
    % Note that there is no constant in the AR model
    n_ar = size(rho,1);
    phi = zeros(n_ar,n_ar);
    phi(1,:) = rho';
    if n_ar > 1
        phi(2:end,1:end-1) = eye(n_ar-1);
    end
    s = zeros(1,n_ar);
    s(1,1)=1;
    theta = zeros(n_ar,1);
    theta(1,1) = se;
end