function [risk] = interval_sample_risk(Y,Qlower,Qupper,perc);
    % Y is the data
    % Qlower is the lower quantile forecast where P(Y < Qlower) = perc
    % Qupper is the upper quantile forecast where P(Y > Qupper) = perc
    % risk is the sample risk
    n = length(Y);
    tau = 1/perc;
    risk = (Qupper-Qlower) + tau*((Qlower-Y).*(Y < Qlower) + (Y-Qupper).*(Y > Qupper));
    risk = mean(risk);
end
