function [risk] = quantile_sample_risk(Y,Q,perc);
    % Y is the data
    % Q is the quantile forecast
    % perc is the percentile
    % risk is the sample risk
    n = length(Y);
    risk = (1-perc)*((Q-Y).*(Y < Q)) + perc*((Y-Q).*(Y > Q));
    risk = mean(risk);
end
