function [arcoef,constant,ser] = uar_c(y,n_lags,i_constant)
% AR coefficients and SER ... flag for constant term

    x = NaN(size(y,1),n_lags);
    for i = 1:n_lags
        x(:,i) = lag(y,i);
    end
    if i_constant == 1
        x = [ones(size(x,1),1) x];
    end
    tmp = packr([y x]);
    y = tmp(:,1);
    x = tmp(:,2:end);
    bols = x\y;
    e = y - x*bols;
    ssr = e'*e;
    ser = sqrt(ssr/(size(x,1)-size(x,2)));
    if i_constant == 1
        arcoef = bols(2:end);
        constant = bols(1);
    else
        arcoef = bols;
        constant = NaN;
    end

end

