
CPS_Rslt = TMP;



function Rslt = TMP
% Read in IP Summary Data
Series_File = 'CPS_Series.xlsx';
Data_File = 'CPS.xlsx';
Data_File_sheet = 'Monthly';
n_series_series_file = 14;    % Number of Series in Series File
n_series_data_file = 14;      % Number of Series in Data File
n_codes_series_file = 1;
First_Obs = [1948 1];
Last_Obs = [2021 10];
nperiod = 12;           % Periods per year
Sdesc_Prefix = 'CPS: ';  % Preface for Series Descriptions   

Rslt = Get_Fred_Data(Series_File,Data_File,Data_File_sheet,n_series_series_file,n_series_data_file,n_codes_series_file,First_Obs,Last_Obs,nperiod,Sdesc_Prefix);

Sname = Rslt.Sname;
Sdesc = Rslt.Sdesc;
Data_Mat = Rslt.Data_Mat;

% Create New Series
[~,j]=ismember('CNP16OV',Sname);
CNP16OV = Data_Mat(:,j);

[~,j]=ismember('CLF16OV',Sname);
CLF16OV = Data_Mat(:,j);

[~,j]=ismember('CE16OV',Sname);
CE16OV = Data_Mat(:,j);

[~,j]=ismember('UNEMPLOY',Sname);
UNEMPLOY = Data_Mat(:,j);

[~,j]=ismember('UEMPLT5',Sname);
UNEMPLT5 = Data_Mat(:,j);

[~,j]=ismember('UEMP5TO14',Sname);
UNEMP5TO14 = Data_Mat(:,j);

[~,j]=ismember('UEMP15T26',Sname);
UNEMP15TO26 = Data_Mat(:,j);

[~,j]=ismember('UEMP27OV',Sname);
UNEMP27OV = Data_Mat(:,j);

LFPR = CLF16OV./CNP16OV;
UNEMPLOYRate=UNEMPLOY./CLF16OV;
UNEMPLT5Rate=UNEMPLT5./CLF16OV;
UNEMP5TO14Rate=UNEMP5TO14./CLF16OV;
UNEMP15TO26Rate=UNEMP15TO26./CLF16OV;
UNEMP27OVRate=UNEMP27OV./CLF16OV;

[~,j]=ismember('LNS13023621',Sname);
UNJobLosers = Data_Mat(:,j)./CLF16OV;

[~,j]=ismember('LNS13023653',Sname);
UNJL_Layoff = Data_Mat(:,j)./CLF16OV;

[~,j]=ismember('LNS13025699',Sname);
UNJL_NotLayoff = Data_Mat(:,j)./CLF16OV;

[~,j]=ismember('LNS13023705',Sname);
UNJobLeavers = Data_Mat(:,j)./CLF16OV;

[~,j]=ismember('LNS13023557',Sname);
UNReEntrants = Data_Mat(:,j)./CLF16OV;

[~,j]=ismember('LNS13023569',Sname);
UNNewEntrants = Data_Mat(:,j)./CLF16OV;

Sname1{1} = 'CE16OV';
Sname1{2} = 'LFPR';
Sname1{3} = 'UNEMPLOYRate';
Sname1{4} = 'UNEMPLT5Rate';
Sname1{5} = 'UNEMP5TO14Rate';
Sname1{6} = 'UNEMP15TO26Rate';
Sname1{7} = 'UNEMP27OVRate';
Sname1{8} = 'UNJobLosers';
Sname1{9} = 'UNJL_Layoff';
Sname1{10} = 'UNJL_NotLayoff';
Sname1{11} = 'UNJobLeavers';
Sname1{12} = 'UNReEntrants';
Sname1{13} = 'UNNewEntrants';
Sname1 = Sname1';

Sdesc1 = Sname1;
Sdesc1{1} = 'Employment';


Data_Mat = [CE16OV LFPR UNEMPLOYRate UNEMPLT5Rate UNEMP5TO14Rate UNEMP15TO26Rate UNEMP27OVRate UNJobLosers UNJL_Layoff UNJL_NotLayoff UNJobLeavers UNReEntrants UNNewEntrants];
InclCode = [   2     1       2             1           1                1              1             2           1           1              1           1            1       ]';
%TransCode = [  5     2       1             1           1                1              1             1           1           1              1           1            1       ]';
TransCode = [  5     2       2             2           2                2              2             2           2           2              2           2            2       ]';


% Save Data, etc;
for i = 1:size(Data_Mat,2);
    tmp = char(Sdesc1(i));
    tmp = [Sdesc_Prefix tmp];
    Sdesc1(i) = {tmp};
end;

Code_Desc1{1} = 'TransCode';
Code_Desc1{2} = 'InclCode';
Code_Desc1{3} = 'OutlierCode';
OutlierCode = zeros(size(Data_Mat,2),1);
Code_Mat1 = [TransCode InclCode OutlierCode];


Rslt.Sname = Sname1;
Rslt.Sdesc = Sdesc1;
Rslt.Data_Mat = Data_Mat;
Rslt.Code_Mat = Code_Mat1;
Rslt.Code_Desc = Code_Desc1;

end

