
PersonalIncome_Rslt = TMP;



function Rslt = TMP
% Read in Personal Income Data
Series_File = 'PersonalIncome_Series.xlsx';
Data_File = 'PersIncome.xlsx';
Data_File_sheet = 'Monthly';
n_series_series_file = 16;    % Number of Series in Series File
n_series_data_file = 16;      % Number of Series in Data File
n_codes_series_file = 5;
First_Obs = [1959 1];
Last_Obs = [2021 10];
nperiod = 12;                 % Periods per year
Sdesc_Prefix = 'PI: ';       % Preface for Series Descriptions   

Rslt1 = Get_Fred_Data(Series_File,Data_File,Data_File_sheet,n_series_series_file,n_series_data_file,n_codes_series_file,First_Obs,Last_Obs,nperiod,Sdesc_Prefix);

% Carry Out some additional Processing;
Data_Mat = Rslt1.Data_Mat; 
Sname = Rslt1.Sname;
Sdesc = Rslt1.Sdesc;
Code_Mat = Rslt1.Code_Mat;
calds = Rslt1.calds;
calvec = Rslt1.calvec;
Code_Desc = Rslt1.Code_Desc;

[~,j] = ismember('DefCode',Code_Desc);
DefCode = Code_Mat(:,j);
[~,j] = ismember('TransCode',Code_Desc);
TransCode = Code_Mat(:,j);
[~,j] = ismember('InclCode',Code_Desc);
InclCode = Code_Mat(:,j);
[~,j] = ismember('OutlierCode',Code_Desc);
OutlierCode = Code_Mat(:,j);

N = size(TransCode,1);
i_keep = zeros(N,1);

% Find Price Series to us as deflator
[~,j_price]=ismember('PCEPI',Sname);
price = Data_Mat(:,j_price)/100;

for i = 1:N;
    if DefCode(i) == 1
       Data_Mat(:,i) = Data_Mat(:,i)./price;
       tmp = char(Sdesc(i));
       tmp = [tmp ' real'];
       Sdesc(i) = {tmp};
       tmp = char(Sname(i));
       tmp = [tmp 'R'];
       Sname(i) = {tmp};
    end
    if InclCode(i) ~= 0
        i_keep(i) = 1;
    end
end;

Code_Mat = [TransCode InclCode OutlierCode];
Code_Mat = Code_Mat(i_keep==1,:);
tmpa(1,1) = {'TransCode'};
tmpa(2,1) = {'InclCode'};
tmpa(3,1) = {'OutlierCode'};
Code_Desc = tmpa;

Rslt.Sname = Sname(i_keep==1);
Rslt.Sdesc = Sdesc(i_keep==1);
Rslt.Code_Mat = Code_Mat;
Rslt.Code_Desc = Code_Desc;
Rslt.Data_Mat = Data_Mat(:,i_keep==1);
Rslt.calds = calds;
Rslt.calvec = calvec;
       
       






end

