PCE_Rslt = TMP;

function Rslt = TMP
% Read in PCE Sectoral Data from BEA excel files
Series_File = 'PCE_Series_List.xlsx';
n_series_series_file = 27;    % Number of Series in Series File
n_codes_series_file = 2;      % Number of Codes
Sdesc_Prefix = 'PCE: ';       % Preface for Series Descriptions   
nperiod = 12;                 % Periods per year

% Observations on each sheet
F_0 = [1959 1];
L_0 = [1980 2];
F_1 = [1980 3];
L_1 = [2001 4];
F_2 = [2001 5];
L_2 = [2021 10];
First_Obs = F_0;
Last_Obs = L_2;
[nobs,calvec,calds] = calendar_make(First_Obs,Last_Obs,nperiod);


% Read Series Names, Descriptions, etc.
[~,Sname,~]=xlsread(Series_File,['A3:A' num2str(2+n_series_series_file)]);
[~,Sdesc,~]=xlsread(Series_File,['B3:B' num2str(2+n_series_series_file)]);
[~,Code_Desc,~] = xlsread(Series_File,['C2:' fixed_to_aa(2+n_codes_series_file) '2']);
Code_Desc = Code_Desc';
Code_Mat = xlsread(Series_File,['C3:' fixed_to_aa(2+n_codes_series_file) num2str(2+n_series_series_file)]);
[~,j]=ismember('e_code',Code_Desc);
ecode = Code_Mat(:,j);

% Read Nominal PCE Data
xlsname = 'nipa_2_3_5u.xlsx';
[nobs_a,~,~]=calendar_make(F_0,L_0,nperiod);
tmp = xlsread(xlsname,'Sheet0',['C9:' fixed_to_aa(2+nobs_a) num2str(8+n_series_series_file)]);
d_mat = tmp';
[nobs_a,~,~]=calendar_make(F_1,L_1,nperiod);
tmp = xlsread(xlsname,'Sheet1',['C9:' fixed_to_aa(2+nobs_a) num2str(8+n_series_series_file)]);
d_mat = [d_mat;tmp'];
[nobs_a,~,~]=calendar_make(F_2,L_2,nperiod);
tmp = xlsread(xlsname,'Sheet2',['C9:' fixed_to_aa(2+nobs_a) num2str(8+n_series_series_file)]);
d_mat = [d_mat;tmp'];
nom_pce = d_mat;
% Read Price Indices
xlsname = 'nipa_2_3_4u.xlsx';
[nobs_a,~,~]=calendar_make(F_0,L_0,nperiod);
tmp = xlsread(xlsname,'Sheet0',['C9:' fixed_to_aa(2+nobs_a) num2str(8+n_series_series_file)]);
d_mat = tmp';
[nobs_a,~,~]=calendar_make(F_1,L_1,nperiod);
tmp = xlsread(xlsname,'Sheet1',['C9:' fixed_to_aa(2+nobs_a) num2str(8+n_series_series_file)]);
d_mat = [d_mat;tmp'];
[nobs_a,~,~]=calendar_make(F_2,L_2,nperiod);
tmp = xlsread(xlsname,'Sheet2',['C9:' fixed_to_aa(2+nobs_a) num2str(8+n_series_series_file)]);
d_mat = [d_mat;tmp'];
p_pce = d_mat;

% Refine list to remove energy 

% Compute Total and Values for Included Series
isel = ecode==2;
p_agg = p_pce(:,isel==1);         % Aggregrate Price Index  
nom_agg = nom_pce(:,isel==1);     % Aggregate Nominal PCE
isel = ecode==5;
p_agg_xfe = p_pce(:,isel==1);     % Aggregrate Price Index XFE  
nom_agg_xfe = nom_pce(:,isel==1);  % Aggregate Nominal PCE XFE

% Compute Energy Services Component of Household Expenditures
isel = ecode==3;              % Gasoline and other energy goods
nom_eg = nom_pce(:,isel==1);    
p_eg = p_pce(:,isel==1);        
isel = ecode==4;              % Housing and utilities
nom_hu = nom_pce(:,isel==1);    
p_hu = p_pce(:,isel==1);
isel = ecode==6;              % Energy Goods and Services
nom_egs = nom_pce(:,isel==1);   
p_egs = p_pce(:,isel==1);

nom_hu_es = nom_egs - nom_eg;    % Energy services component of housing and utilities
nom_hu_xes = nom_hu - nom_hu_es; % Housing and Utilities excluding energy services

% Compute some inflation rates
infl_eg = NaN*zeros(nobs,1);
infl_eg(2:end) = log(p_eg(2:end)./p_eg(1:end-1));
infl_egs = NaN*zeros(nobs,1);
infl_egs(2:end) = log(p_egs(2:end)./p_egs(1:end-1));
s_eg_egs = nom_eg./nom_egs;   % Share of energy goods in energy goods and services 
infl_hu_es = (infl_egs - (s_eg_egs.*infl_eg))./(1-s_eg_egs);
p_hu_es = NaN*zeros(nobs,1);
p_hu_es(1) = 100;
for i = 2:nobs;
    p_hu_es(i) = p_hu_es(i-1)*exp(infl_hu_es(i));
end;
infl_hu = NaN*zeros(nobs,1);
infl_hu(2:end) = log(p_hu(2:end)./p_hu(1:end-1));
s_es_hu = nom_hu_es./nom_hu;  % Share of energy in housing and utilities
infl_hu_xes = (infl_hu - (s_es_hu.*infl_hu_es))./(1-s_es_hu);
p_hu_xes = NaN*ones(nobs,1);
p_hu_xes(1) = 100;
for i = 2:nobs;
    p_hu_xes(i) = p_hu_xes(i-1)*exp(infl_hu_xes(i));
end;

% Append Housing and Utilities 
Sname{size(Sname,1)+1,1} = 'DHUTRG_XE';
Sdesc{size(Sdesc,1)+1,1} = '    Housing and utilites (excl. energy)';
Sname{size(Sname,1)+1,1} = 'DHUTRG_Energy';
Sdesc{size(Sdesc,1)+1,1} = '    Housing and utilites (energy)';
nom_pce = [nom_pce nom_hu_xes nom_hu_es];
p_pce = [p_pce p_hu_xes p_hu_es];
cc = [1 0];
Code_Mat = [Code_Mat;cc;cc];
real_pce = nom_pce./p_pce;

% Save Relevant Series and Codes
[~,j] = ismember('InclCode',Code_Desc);
isel = Code_Mat(:,j) ~= 0;
Data_Mat = real_pce(:,isel==1);
Sname = Sname(isel==1);
Sdesc = Sdesc(isel==1);
Code_Mat = Code_Mat(isel==1,:);
[~,j] = ismember('InclCode',Code_Desc);
Code_Mat = Code_Mat(:,j);
Code_Desc = Code_Desc(j);
Code_Desc{size(Code_Desc,1)+1,1} = 'TransCode';
Code_Mat = [Code_Mat 5*ones(size(Code_Mat,1),1)];  % Transformation code = 5 for all series 
Code_Desc{size(Code_Desc,1)+1,1} = 'OutlierCode';
Code_Mat = [Code_Mat 0*ones(size(Code_Mat,1),1)];  % Outliner code = 0 for all series 
for i = 1:size(Data_Mat,2);
    tmp = char(Sdesc(i));
    tmp = [Sdesc_Prefix tmp];
    Sdesc(i) = {tmp};
end;

% % ... Append PCE Share
% nom_pce = nom_pce(:,isel==1);
% pce_share = nom_pce./repmat(nom_pce(:,1),1,size(nom_pce,2));
% pce_share = pce_share(:,2:end);
% for i = 2:size(nom_pce,2);
%     tmp = char(Sname(i));
%     tmp = ['Share ' tmp];
%     Sname{size(Sname,1)+1,1} = tmp;
%     tmp = char(Sdesc(i));
%     tmp = ['Share ' tmp];
%     Sdesc{size(Sdesc,1)+1,1} = tmp;
% end;
% tmp = zeros(size(pce_share,2),size(Code_Mat,2));
% Code_Mat = [Code_Mat;tmp];
% [~,j] = ismember('InclCode',Code_Desc);
% Code_Mat(end-size(pce_share,2)+1:end,j) = 2;
% [~,j] = ismember('TransCode',Code_Desc);
% Code_Mat(end-size(pce_share,2)+1:end,j) = 1;
% [~,j] = ismember('OutlierCode',Code_Desc);
% Code_Mat(end-size(pce_share,2)+1:end,j) = 0;
% size(Data_Mat)
% Data_Mat = [Data_Mat pce_share];

Rslt.Sname = Sname;
Rslt.Sdesc = Sdesc;
Rslt.Code_Mat = Code_Mat;
Rslt.Code_Desc = Code_Desc;
Rslt.Data_Mat = Data_Mat;
Rslt.calds = calds;
Rslt.calvec = calvec;

end







